/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.fastrakReader;

import de.grogra.fastrakReader.Branch;
import de.grogra.fastrakReader.Point;
import de.grogra.fastrakReader.XContentHandler;
import de.grogra.graph.impl.Node;
import de.grogra.pf.boot.Main;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.util.Map;
import de.grogra.util.Utils;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.Line;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Fastrak_Import {
    Boolean diameterTax;

    public Fastrak_Import(InputStream inp, Node root) {
        XMLReader xmlReader = null;
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        Object reader = null;
        InputSource inputSource = new InputSource(inp);
        Item ite = Item.resolveItem((RegistryContext)Main.getRegistry(), (String)"/fastrak/reader");
        String diameterKey = (String)Utils.get((Map)ite, (Object)"diameter", (Object)"");
        String leafKey = (String)Utils.get((Map)ite, (Object)"leafKey", (Object)"");
        this.diameterTax = (Boolean)Utils.get((Map)ite, (Object)"diameterTaxonmy", (Object)"");
        XContentHandler xc = new XContentHandler(diameterKey, leafKey);
        xmlReader.setContentHandler(xc);
        try {
            xmlReader.parse(inputSource);
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
        }
        ArrayList<Branch> allBranches = xc.getAllBranches();
        for (int i = 0; i < allBranches.size(); ++i) {
            while (i < allBranches.size() && allBranches.get((int)i).points.size() <= 1) {
                if (allBranches.get((int)i).parendId == -1) {
                    allBranches.remove(i);
                    allBranches.get((int)i).parendId = -1;
                    continue;
                }
                allBranches.remove(i);
            }
        }
        Branch treeRoot = null;
        for (int i = 0; i < allBranches.size(); ++i) {
            Branch part = allBranches.get(i);
            if (part.parendId != -1) {
                this.getParentBranchPoint(allBranches, i, part.points.get(0).getX(), part.points.get(0).getY(), part.points.get(0).getZ(), part.order);
                continue;
            }
            treeRoot = part;
        }
        Node scaleton = new Node();
        scaleton.setName("branch");
        Point p = treeRoot.points.get(0);
        root.addEdgeBitsTo(scaleton, 512, null);
        treeRoot.createGraph(root, allBranches, p.getX(), p.getY(), p.getZ(), null, null, scaleton);
    }

    Branch getBranchByTag(String tag, ArrayList<Branch> list) {
        if (tag == null) {
            return list.get(0);
        }
        int i = tag.lastIndexOf(114);
        if (i == -1) {
            return list.get(0);
        }
        tag = tag.substring(0, i);
        for (Branch b : list) {
            if (!b.getTag().equals(tag)) continue;
            return b;
        }
        return list.get(0);
    }

    double getDistance(double startx, double starty, double startz, double d, double e, double f) {
        return Math.sqrt(Math.sqrt(Math.pow(startx - d, 2.0) + Math.pow(starty - e, 2.0)) + Math.pow(startz - f, 2.0));
    }

    double getDistanceSquared(double cSx, double cSy, double cSz, double pSx, double pSy, double pSz, double pEx, double pEy, double pEz, double pD) {
        Point3d childStart = new Point3d(cSx, cSy, cSz);
        Point3d parentStart = new Point3d(pSx, pSy, pSz);
        Point3d parentEnd = new Point3d(pEx, pEy, pEz);
        double len = parentStart.distance(parentEnd);
        Vector3d dir = new Vector3d((Tuple3d)parentEnd);
        dir.sub((Tuple3d)parentStart);
        Line parent = new Line((Tuple3d)parentStart, dir, 0.0, len);
        double u = Math2.dot((Tuple3d)childStart, (Tuple3d)parentStart, (Tuple3d)dir) / dir.lengthSquared();
        double dist = u < 0.0 ? parentStart.distance(childStart) : (u > len ? parentEnd.distance(childStart) : parent.distance((Tuple3d)childStart));
        return dist;
    }

    void getParentBranchPoint(ArrayList<Branch> posParent, int kiddoId, double startx, double starty, double startz, int order) {
        int minp = 0;
        double tmp = 0.0;
        int bid = 0;
        double min = 100000.0;
        for (int pi = 0; pi < posParent.size(); ++pi) {
            if (pi >= kiddoId) continue;
            Branch parent = posParent.get(pi);
            if (parent.points.size() <= 1) continue;
            for (int i = 0; i < parent.points.size() - 1; ++i) {
                tmp = this.getDistanceSquared(startx, starty, startz, parent.points.get(i).getX(), parent.points.get(i).getY(), parent.points.get(i).getZ(), parent.points.get(i + 1).getX(), parent.points.get(i + 1).getY(), parent.points.get(i + 1).getZ(), parent.points.get(i).getDiameter());
                if (!(tmp < min) || this.diameterTax.booleanValue() && !(parent.points.get(i).getDiameter() >= posParent.get((int)kiddoId).points.get(0).getDiameter())) continue;
                minp = i;
                min = tmp;
                bid = pi;
            }
        }
        Point x = posParent.get((int)bid).points.get(minp);
        x.addChild(kiddoId);
    }
}

