/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.fastrakReader;

import de.grogra.fastrakReader.Fastrak_Import;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.icon.IconSource;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.MimeTypeItem;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ProjectLoader;
import de.grogra.pf.io.ResourceLoader;
import de.grogra.pf.io.VirtualFileReaderSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.TypeItem;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Showable;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.registry.UIItem;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Method;
import de.grogra.reflect.Type;
import de.grogra.util.Lock;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.lang.ObjectToBoolean;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class FastrakSourceFile
extends Item
implements UIItem,
ObjectToBoolean,
TreeModelListener,
Showable {
    private static final long serialVersionUID = 1L;
    protected MimeType mimeType;
    protected boolean editable = true;
    protected boolean disabled = false;
    protected transient String deactivationCategory;
    protected transient int activationStamp = -1;
    public static final Node.NType $TYPE = new Node.NType((Node)new FastrakSourceFile());
    public static final Node.NType.Field mimeType$FIELD = new _Field("mimeType", 0x200004, (Type)ClassAdapter.wrap(MimeType.class), null, 0);
    public static final Node.NType.Field editable$FIELD;
    public static final Node.NType.Field disabled$FIELD;

    public int getActivationStamp() {
        return this.activationStamp;
    }

    public void setActivationStamp(int stamp) {
        this.activationStamp = stamp;
    }

    private FastrakSourceFile() {
        this(null, null);
    }

    public FastrakSourceFile(String key, MimeType mimeType) {
        super(key);
        this.mimeType = mimeType;
    }

    public FileSource toFileSource() {
        return FileSource.createFileSource((String)this.getName(), (MimeType)this.mimeType, (RegistryContext)this, (ModifiableMap)new StringMap((Map)this));
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public MimeTypeItem getMimeTypeItem() {
        return MimeTypeItem.get((RegistryContext)this, (MimeType)this.mimeType);
    }

    private void reinstantiateMTG() {
        Node rootNode = this.getRegistry().getProjectGraph().getRoot();
        if (rootNode != null) {
            this.reinstantiateMTGInternal(rootNode);
        }
    }

    private boolean isObsoleteInstance(Node node) {
        if (this.isMTGNode(node)) {
            Item dir = this.getRegistry().getItem("/classes");
            for (Item c = (Item)dir.getBranch(); c != null; c = (Item)c.getSuccessor()) {
                Type t = (Type)((TypeItem)c).getObject();
                if (!node.getNType().getName().equals(t.getName())) continue;
                return !t.isInstance((Object)node);
            }
        }
        return false;
    }

    private boolean isMTGNode(Node node) {
        Node.NType nType = node.getNType();
        if (nType != null) {
            return nType.getName().contains("mtg_");
        }
        return false;
    }

    private Type getNewType(Node node) {
        Item dir = this.getRegistry().getItem("/classes");
        for (Item c = (Item)dir.getBranch(); c != null; c = (Item)c.getSuccessor()) {
            Type t = (Type)((TypeItem)c).getObject();
            if (!node.getNType().getName().equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    public static void copyNodeFields(Node oldNode, Node newNode) {
        Node.NType oldType = oldNode.getNType();
        Node.NType newType = newNode.getNType();
        int methodCount = oldType.getDeclaredMethodCount();
        int newMethodCount = newType.getDeclaredMethodCount();
        for (int m = 0; m < methodCount; ++m) {
            Method method = oldType.getDeclaredMethod(m);
            if (!method.getName().startsWith("get")) continue;
            String variableName = method.getName();
            variableName = variableName.substring(3);
            for (int i = 0; i < newMethodCount; ++i) {
                Method newMethod = newType.getDeclaredMethod(i);
                if (!newMethod.getName().equals("set" + variableName)) continue;
                Object[] oldParameters = new Object[]{};
                Object[] newParameters = new Object[1];
                try {
                    newParameters[0] = method.invoke((Object)oldNode, oldParameters);
                    newMethod.invoke((Object)newNode, newParameters);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            for (int i = 0; i < newType.getManagedFieldCount(); ++i) {
                ManageableType.Field mf = newType.getManagedField(i);
                if (!FastrakSourceFile.isStandardAttribute(mf.getName())) continue;
                ManageableType.Field mfOld = null;
                for (int j = 0; j < oldType.getManagedFieldCount(); ++j) {
                    mfOld = oldType.getManagedField(j);
                    if (!mfOld.getName().equals(mf.getName())) continue;
                    if (FastrakSourceFile.isStandardAttributeDouble(mfOld.getName())) {
                        mf.setDouble((Object)newNode, mfOld.getDouble((Object)oldNode));
                    }
                    if (FastrakSourceFile.isStandardAttributeInt(mfOld.getName())) {
                        mf.setInt((Object)newNode, mfOld.getInt((Object)oldNode));
                    }
                    if (!FastrakSourceFile.isStandardAttributeObject(mfOld.getName())) continue;
                    mf.setObject((Object)newNode, mfOld.getObject((Object)oldNode));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static boolean isStandardAttribute(String featureName) {
        if (featureName == null) {
            return false;
        }
        return FastrakSourceFile.isStandardAttributeDouble(featureName) || FastrakSourceFile.isStandardAttributeInt(featureName) || FastrakSourceFile.isStandardAttributeObject(featureName);
    }

    private static boolean isStandardAttributeDouble(String featureName) {
        return featureName.equals("L1") || featureName.equals("L2") || featureName.equals("L3") || featureName.equals("DAB") || featureName.equals("DAC") || featureName.equals("DBC") || featureName.equals("XX") || featureName.equals("YY") || featureName.equals("ZZ") || featureName.equals("Length") || featureName.equals("Azimut") || featureName.equals("Alpha") || featureName.equals("AA") || featureName.equals("BB") || featureName.equals("CC") || featureName.equals("TopDia") || featureName.equals("BotDia") || featureName.equals("Position");
    }

    private static boolean isStandardAttributeInt(String featureName) {
        return featureName.equals("Category") || featureName.equals("Order") || featureName.equals("mtgClassID") || featureName.equals("mtgID") || featureName.equals("mtgScale") || featureName.equals("stdAttFlag");
    }

    private static boolean isStandardAttributeObject(String featureName) {
        return featureName.equals("DirectionPrimary") || featureName.equals("mtgClass");
    }

    private void reinstantiateMTGInternal(Node node) {
        boolean isObsolete = this.isObsoleteInstance(node);
        Node newNode = null;
        if (isObsolete) {
            ArrayList<Node> inNodes = new ArrayList<Node>();
            ArrayList<Integer> inEdges = new ArrayList<Integer>();
            ArrayList<Node> outNodes = new ArrayList<Node>();
            ArrayList<Integer> outEdges = new ArrayList<Integer>();
            for (Edge e = node.getFirstEdge(); e != null; e = e.getNext(node)) {
                if (e.getTarget() == node) {
                    inEdges.add(new Integer(e.getEdgeBits()));
                    inNodes.add(e.getSource());
                }
                if (e.getSource() != node) continue;
                outEdges.add(new Integer(e.getEdgeBits()));
                outNodes.add(e.getTarget());
            }
            Type newType = this.getNewType(node);
            try {
                newNode = (Node)newType.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (newNode != null) {
                FastrakSourceFile.copyNodeFields(node, newNode);
                for (int i = 0; i < inNodes.size(); ++i) {
                    ((Node)inNodes.get(i)).addEdgeBitsTo(newNode, ((Integer)inEdges.get(i)).intValue(), null);
                }
                for (int j = 0; j < outNodes.size(); ++j) {
                    newNode.addEdgeBitsTo((Node)outNodes.get(j), ((Integer)outEdges.get(j)).intValue(), null);
                }
                for (Edge e = node.getFirstEdge(); e != null; e = e.getNext(node)) {
                    if (e.getSource() == node) {
                        node.removeEdgeBitsTo(e.getTarget(), e.getEdgeBits(), null);
                        continue;
                    }
                    if (e.getTarget() != node) continue;
                    e.getSource().removeEdgeBitsTo(node, e.getEdgeBits(), null);
                }
            }
        } else {
            newNode = node;
        }
        ArrayList<Node> outNodes = new ArrayList<Node>();
        for (Edge e = newNode.getFirstEdge(); e != null; e = e.getNext(newNode)) {
            if (e.getSource() != newNode) continue;
            outNodes.add(e.getTarget());
        }
        for (int i = 0; i < outNodes.size(); ++i) {
            Node outNode = (Node)outNodes.get(i);
            if (this.isMTGNode(outNode)) {
                if (!this.isObsoleteInstance(outNode)) continue;
                this.reinstantiateMTGInternal(outNode);
                continue;
            }
            this.reinstantiateMTGInternal(outNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateImpl() {
        FileSource fs;
        FilterSource s;
        if (this.disabled) {
            this.activationStamp = -1;
            return;
        }
        Object f = this.getRegistry().getProjectFile(this.getName());
        if (f != null) {
            this.getRegistry().addFileSystemListener((TreeModelListener)this);
            this.getRegistry().getFileSystem().setMimeType(f, this.mimeType);
        }
        if (!((s = IO.createPipeline((FilterSource)(fs = this.toFileSource()), (IOFlavor)IOFlavor.RESOURCE_LOADER)) instanceof ObjectSource)) {
            return;
        }
        s.initProgressMonitor(UI.createProgressAdapter((Context)Workbench.get((RegistryContext)this)));
        try {
            final ResourceLoader rl = (ResourceLoader)((ObjectSource)s).getObject();
            this.deactivationCategory = rl.getJoinedDeactivationCategory();
            if (this.activationStamp != this.getRegistry().getActivationStamp()) {
                this.activationStamp = this.getRegistry().getActivationStamp();
                ((Item)this.getAxisParent()).forAll(null, null, new ItemVisitor(){

                    public void visit(Item item, Object info) {
                        if (!item.isActivated() && item instanceof FastrakSourceFile && !((FastrakSourceFile)item).disabled && ((FastrakSourceFile)item).activationStamp != FastrakSourceFile.this.activationStamp && rl.addResource((FilterSource)((FastrakSourceFile)item).toFileSource())) {
                            ((FastrakSourceFile)item).activationStamp = FastrakSourceFile.this.activationStamp;
                        }
                    }
                }, null, false);
                rl.loadResource(this.getRegistry());
                if (this.getName().contains("generated.xl")) {
                    this.reinstantiateMTG();
                }
            }
        }
        catch (Exception e) {
            Workbench.get((RegistryContext)this).logGUIInfo(IO.I18N.msg("openfile.failed", (Object)fs.getSystemId()), (Throwable)e);
        }
        finally {
            s.setProgress(null, 2.0f);
        }
    }

    protected void deactivateImpl() {
        this.getRegistry().removeFileSystemListener((TreeModelListener)this);
    }

    protected Object getDescriptionImpl(String type) {
        if ("Name".equals(type)) {
            return IO.toPath((String)this.getName());
        }
        Object d = super.getDescriptionImpl(type);
        return "Icon".equals(type) ? UI.getIcon((String)this.getName(), (String)this.mimeType.getMediaType(), (IconSource)((IconSource)d), (RegistryContext)this, (boolean)true) : d;
    }

    public Object invoke(Context ctx, String method, Object arg) {
        return null;
    }

    public void show(Context ctx) {
        this.show(ctx, null);
    }

    public void show(Context ctx, String ref) {
        MimeTypeItem m = this.getMimeTypeItem();
        if (m != null) {
            if (this.editable && m.isEditable()) {
                TextEditor t;
                Panel[] p = ctx.getWindow().getPanels((ObjectToBoolean)this);
                for (int i = 0; i < p.length; ++i) {
                    t = (TextEditor)p[i];
                    if (!Utils.isContained((Object)this.getName(), (Object[])t.getDocuments())) continue;
                    t.openDocument(this.getName(), ref);
                    t.show(false, null);
                    return;
                }
                t = p.length > 0 ? (TextEditor)p[0] : (TextEditor)PanelFactory.createPanel((Context)ctx, (String)"/ui/panels/texteditor", null);
                t.openDocument(this.getName(), ref);
                t.show(false, null);
            } else if (m.isViewable()) {
                ctx.getWorkbench().showViewerPanel(this.getName(), this.getName(), (Map)this);
            }
        }
    }

    public void showLater(Context ctx) {
        UI.getJobManager((Context)ctx).runLater(new Command(){

            public void run(Object arg, Context ctx) {
                FastrakSourceFile.this.show(ctx, null);
            }

            public String getCommandName() {
                return null;
            }
        }, null, ctx, 10000);
    }

    public boolean isAvailable(Context ctx) {
        return true;
    }

    public boolean isEnabled(Context ctx) {
        return true;
    }

    public int getUINodeType() {
        return 8;
    }

    public boolean evaluateBoolean(Object o) {
        return o instanceof TextEditor;
    }

    public void addRequiredFiles(Collection list) {
        Object f = this.getRegistry().getProjectFile(this.getName());
        if (f != null) {
            list.add(f);
        }
    }

    public static FastrakSourceFile get(RegistryContext ctx, String systemId) {
        Item dir = ctx.getRegistry().getItem("/project/objects/files");
        return dir != null ? (FastrakSourceFile)dir.getItem((CharSequence)systemId) : null;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        if (FileSystem.isContainedInChildren((Object)this.getRegistry().getProjectFile(this.getName()), (TreeModelEvent)e)) {
            FastrakSourceFile.refresh((Item)this.getAxisParent(), this, this.deactivationCategory, new Command(){

                public String getCommandName() {
                    return null;
                }

                public void run(Object info, Context context) {
                    if (Utils.getBoolean((Map)UI.getOptions((Context)context), (Object)"saveProjectOnFileModification")) {
                        context.getWorkbench().save(false);
                    }
                }
            });
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    public static void refresh(final Item dir, final FastrakSourceFile file, final String category, final Command afterRefresh) {
        Workbench w = Workbench.get((RegistryContext)dir);
        class Deactivator
        extends LockProtectedCommand
        implements ItemVisitor {
            Deactivator(Workbench w) {
                super((Lockable)w.getRegistry().getProjectGraph(), true, 10000);
            }

            public String getCommandName() {
                return null;
            }

            protected void runImpl(Object info, Context context, Lock lock) {
                dir.forAll(null, null, (ItemVisitor)this, null, false);
                dir.getRegistry().activateItems();
                if (afterRefresh != null) {
                    UI.getJobManager((Context)context).runLater(afterRefresh, info, context, 70536);
                }
            }

            public void visit(Item item, Object info) {
                if (!item.isActivated() || !(item instanceof FastrakSourceFile)) {
                    return;
                }
                if (item == file || ((FastrakSourceFile)item).activationStamp == -1 || category != null && item instanceof FastrakSourceFile && category.equals(((FastrakSourceFile)item).deactivationCategory)) {
                    item.deactivate();
                }
            }
        }
        w.getJobManager().runLater((Command)new Deactivator(w), null, (Context)w, 10000);
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new FastrakSourceFile();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean value) {
        this.disabled = value;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)mimeType$FIELD);
        editable$FIELD = new _Field("editable", 0x200004, Type.BOOLEAN, null, 1);
        $TYPE.addManagedField((ManageableType.Field)editable$FIELD);
        disabled$FIELD = new _Field("disabled", 0x200004, Type.BOOLEAN, null, 2);
        $TYPE.addManagedField((ManageableType.Field)disabled$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String name, int modifiers, Type type, Type componentType, int id) {
            super($TYPE, name, modifiers, type, componentType);
            this.id = id;
        }

        public void setBoolean(Object o, boolean value) {
            switch (this.id) {
                case 1: {
                    ((FastrakSourceFile)o).editable = value;
                    return;
                }
                case 2: {
                    ((FastrakSourceFile)o).disabled = value;
                    return;
                }
            }
            super.setBoolean(o, value);
        }

        public boolean getBoolean(Object o) {
            switch (this.id) {
                case 1: {
                    return ((FastrakSourceFile)o).isEditable();
                }
                case 2: {
                    return ((FastrakSourceFile)o).isDisabled();
                }
            }
            return super.getBoolean(o);
        }

        protected void setObjectImpl(Object o, Object value) {
            switch (this.id) {
                case 0: {
                    ((FastrakSourceFile)o).mimeType = (MimeType)value;
                    return;
                }
            }
            super.setObjectImpl(o, value);
        }

        public Object getObject(Object o) {
            switch (this.id) {
                case 0: {
                    return ((FastrakSourceFile)o).mimeType;
                }
            }
            return super.getObject(o);
        }
    }

    public static class Loader
    extends FilterBase
    implements ObjectSource,
    ProjectLoader {
        public Loader(FilterItem item, FilterSource source) {
            super(item, source);
            this.setFlavor(IOFlavor.PROJECT_LOADER);
        }

        public Object getObject() {
            return this;
        }

        public void loadRegistry(Registry r) {
            File f = ((FileSource)this.source).getInputFile();
            Workbench w = Workbench.get((RegistryContext)r);
            r.initFileSystem((FileSystem)new LocalFileSystem("pfs", f.getParentFile()));
            if (w != null) {
                Item i = this.item.getItem((CharSequence)"layout");
                if (i != null) {
                    i = i.resolveLink((RegistryContext)r);
                }
                if (i != null) {
                    w.setProperty("initial-layout", (Object)i.getAbsoluteName());
                }
            }
        }

        public void loadGraph(Registry r) {
            VirtualFileReaderSource src = (VirtualFileReaderSource)this.getSource();
            try {
                InputStream inp = src.getFileSystem().getInputStream(src.getFile());
                r.setEmptyGraph();
                GraphManager graph = r.getProjectGraph();
                graph.setRoot("test", new Node());
                Node root = graph.getRoot();
                new Fastrak_Import(inp, root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

