/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.fastrakReader;

import de.grogra.fastrakReader.Point;
import de.grogra.graph.impl.Node;
import de.grogra.math.TMatrix4d;
import de.grogra.turtle.F;
import de.grogra.vecmath.Math2;
import java.util.ArrayList;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Branch {
    ArrayList<Point> points;
    String tag;
    int rootId;
    int parendId;
    int diameterId;
    int isLeafId;
    int order;
    boolean visited = false;

    public Branch(int pid) {
        this.parendId = pid;
        this.points = new ArrayList();
        this.diameterId = 0;
    }

    public void addDiameter(float d) {
        this.points.get(this.diameterId).setDiameter(d / 100.0f);
        ++this.diameterId;
    }

    public TMatrix4d setDirection(Vector3d direction) {
        Matrix3d m = new Matrix3d();
        Math2.getOrthogonalBasis((Tuple3d)direction, (Matrix3d)m, (boolean)true);
        TMatrix4d tx = new TMatrix4d();
        tx.setRotationScale(m);
        return tx;
    }

    public void setRootId(int rootId) {
        this.rootId = rootId;
    }

    public void addPoint(float x, float y, float z) {
        this.points.add(new Point(x / 100.0f, y / 100.0f, z / 100.0f));
    }

    public Point getLastPoint() {
        int i = this.points.size();
        if (i == 0) {
            return null;
        }
        return this.points.get(i - 1);
    }

    public double getDistance(Point p, Point pn) {
        return Math.sqrt(Math.pow(p.getX() - pn.getX(), 2.0) + Math.pow(p.getY() - pn.getY(), 2.0) + Math.pow(p.getZ() - pn.getZ(), 2.0));
    }

    public int getParendId() {
        return this.parendId;
    }

    public void createGraph(Node last, ArrayList<Branch> allRoots, double x, double y, double z, Matrix3d oldRot, Matrix4d gT, Node scaleton) {
        Matrix4d globalT;
        if (gT == null) {
            globalT = new Matrix4d();
            globalT.setIdentity();
        } else {
            globalT = new Matrix4d(gT);
        }
        Point p_old = this.points.get(0);
        boolean isFirst = true;
        for (int i = 1; i < this.points.size(); ++i) {
            Point p_new = this.points.get(i);
            Vector3d a = new Vector3d(p_new.getX() - p_old.getX(), p_new.getY() - p_old.getY(), p_new.getZ() - p_old.getZ());
            double len = a.length();
            Matrix3d globalRot = new Matrix3d();
            Math2.getOrthogonalBasis((Tuple3d)a, (Matrix3d)globalRot, (boolean)true);
            Matrix3d localRot = new Matrix3d();
            if (oldRot == null) {
                localRot.setIdentity();
            } else {
                localRot.transpose(oldRot);
            }
            localRot.mul(localRot, globalRot);
            TMatrix4d t = new TMatrix4d();
            t.m03 = x;
            t.m13 = y;
            t.m23 = z;
            t.setRotationScale(localRot);
            globalT.mul((Matrix4d)t);
            F f = new F((float)len);
            f.setTransform(t);
            f.diameter = p_new.getDiameter();
            last.addEdgeBitsTo((Node)f, isFirst ? 512 : 256, null);
            scaleton.addEdgeBitsTo((Node)f, 4096, null);
            last = f;
            for (int rid : p_old.childs) {
                Point p = allRoots.get((int)rid).points.get(0);
                Point3d offs = new Point3d(p.getX() - p_new.getX(), p.getY() - p_new.getY(), p.getZ() - p_new.getZ());
                TMatrix4d t2 = new TMatrix4d(globalT);
                t2.transpose(globalT);
                Math2.transformPoint((Matrix4d)t2, (Tuple3d)offs);
                Node scaletonKid = new Node();
                scaletonKid.setName("branch");
                scaleton.addEdgeBitsTo(scaletonKid, 512, null);
                allRoots.get(rid).createGraph(last, allRoots, offs.x, offs.y, offs.z, globalRot, globalT, scaletonKid);
            }
            isFirst = false;
            oldRot = globalRot;
            x = 0.0;
            y = 0.0;
            z = 0.0;
            p_old = p_new;
        }
    }

    public void setEndPoints(F f, double xs, double ys, double zs, double xe, double ye, double ze) {
        Vector3d a = new Vector3d(xe - xs, ye - ys, ze - zs);
        double len = a.length();
        f.length = (float)len;
        if (len > 0.0) {
            Matrix3d m = new Matrix3d();
            Math2.getOrthogonalBasis((Tuple3d)a, (Matrix3d)m, (boolean)true);
            TMatrix4d t = new TMatrix4d();
            t.m03 = xs;
            t.m13 = ys;
            t.m23 = zs;
            t.setRotationScale(m);
            f.setTransform(t);
        } else {
            f.setTransform(xs, ys, zs);
        }
    }

    public String getTag() {
        if (this.tag == null) {
            return "xxx";
        }
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setIsLeaf(boolean isLeaf) {
        this.points.get(this.isLeafId).setIsLeaf(isLeaf);
        ++this.isLeafId;
    }
}

