/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.api;

import de.grogra.pf.io.FilterSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.TypeItem;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.reflect.Field;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.rgg.Library;
import de.grogra.rgg.model.CompilationFilter;
import de.grogra.rgg.model.Runtime;
import de.grogra.rgg.model.ShellFilter;
import de.grogra.rgg.model.XLFilter;
import de.grogra.util.DelegatingClassLoader;
import de.grogra.util.DetailedException;
import de.grogra.util.Utils;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.scope.ClassPath;
import de.grogra.xl.compiler.scope.CompilationUnitScope;
import de.grogra.xl.lang.DisposableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class XLinLineRunner
implements Runnable,
Command,
ItemVisitor {
    public static final String SHELL_PACKAGE = "$shell$";
    public static final String SHELL_CLASS = "Shell";
    static final String PROMPT = "> ";
    ClassPath path = new ClassPath(XLFilter.getLoaderForAll());
    CClass shell;
    ArrayList<ClassLoader> loaders = new ArrayList();
    private CompilationUnitScope lastScope;
    private Type lastShell;

    XLinLineRunner() {
        this.shell = new CClass(SHELL_CLASS, "$shell$.Shell", 1025, null, true);
        this.shell.initSupertype(Type.OBJECT);
        this.shell.initTypeLoader((TypeLoader)this.path);
    }

    public void visit(Item item, Object info) {
        Type t;
        if (item instanceof TypeItem && (t = (Type)((TypeItem)item).getObject()).getDeclaringType() == null) {
            this.path.getPackage(t.getPackage(), true).declareType(t);
            Class cls = t.getImplementationClass();
            if (!Reflection.canLoad((ClassLoader)this.path.getClassLoader(), (Class)cls)) {
                int i;
                ClassLoader x = cls.getClassLoader();
                for (i = this.loaders.size() - 1; i >= 0; --i) {
                    if (!Reflection.canLoad((ClassLoader)this.loaders.get(i), (Class)cls)) continue;
                    return;
                }
                for (i = this.loaders.size() - 1; i >= 0; --i) {
                    if (!Reflection.isAncestorOrSame((ClassLoader)this.loaders.get(i), (ClassLoader)x)) continue;
                    this.loaders.remove(i);
                }
                this.loaders.add(x);
            }
        }
    }

    public String getCommandName() {
        return "xxx";
    }

    public synchronized void run(Object info, Context c) {
        Object cmd = (String)info;
        Throwable ex = null;
        if (this.shell != null && ((String)cmd).trim().length() > 0) {
            Type compiledShell;
            CompilationFilter f;
            for (int i = this.shell.getDeclaredMethodCount() - 1; i >= 0; --i) {
                this.shell.removeMethod(this.shell.getDeclaredMethod(i));
            }
            Registry reg = c.getWorkbench().getRegistry();
            this.loaders.clear();
            Item.forAll((RegistryContext)reg, (String)"/classes", null, null, (ItemVisitor)this, null, (boolean)false);
            ClassLoader cl = this.path.getClassLoader();
            if (!this.loaders.isEmpty()) {
                this.loaders.add(cl);
                cl = new DelegatingClassLoader(this.loaders.toArray(new ClassLoader[this.loaders.size()]));
            }
            HashSet<String> removedFields = new HashSet<String>();
            HashSet<Field> oldFields = new HashSet<Field>();
            for (int i = this.shell.getDeclaredFieldCount() - 1; i >= 0; --i) {
                Field x = this.shell.getDeclaredField(i);
                if (!Reflection.isPrimitive((Type)x.getType()) && !Reflection.canLoad((ClassLoader)cl, (Class)x.getType().getImplementationClass())) {
                    this.shell.removeField(x);
                    removedFields.add(x.getDescriptor());
                    continue;
                }
                oldFields.add(x);
            }
            try {
                if (((String)cmd).charAt(((String)cmd).length() - 1) != ';') {
                    cmd = (String)cmd + "\n;";
                }
                f = new CompilationFilter(null, (FilterSource)new ShellFilter(reg, this.path, (String)cmd, this.lastScope));
                compiledShell = f.compile(this.shell, cl)[0];
            }
            catch (IOException e) {
                for (int i = this.shell.getDeclaredFieldCount() - 1; i >= 0; --i) {
                    Field x = this.shell.getDeclaredField(i);
                    if (oldFields.contains(x)) continue;
                    this.shell.removeField(x);
                }
                f = null;
                compiledShell = null;
                Throwable t = Utils.getMainException((Throwable)e);
                if (t instanceof DetailedException) {
                    c.getWorkbench().logGUIInfo(((DetailedException)t).getDetailedMessage(false));
                    System.err.println(((DetailedException)t).getDetailedMessage(false));
                }
                ex = t;
            }
            if (f != null) {
                this.lastScope = f.getCompilationUnit();
                if (this.lastShell != null) {
                    for (int i = this.lastShell.getDeclaredFieldCount() - 1; i >= 0; --i) {
                        Field y;
                        Field x = this.lastShell.getDeclaredField(i);
                        if ((x.getModifiers() & 0x1001) != 1 || (y = Reflection.getDeclaredField((Type)compiledShell, (String)x.getDescriptor())) == null || removedFields.contains(x.getDescriptor())) continue;
                        try {
                            Object value = Reflection.get(null, (Field)x);
                            Reflection.set(null, (Field)y, (Object)value);
                            continue;
                        }
                        catch (Exception e) {
                            c.getWorkbench().logGUIInfo(x.getDescriptor() + " " + String.valueOf(e));
                            System.err.println(x.getDescriptor() + " " + String.valueOf(e));
                        }
                    }
                }
                this.lastShell = compiledShell;
                Method m = Reflection.getDeclaredMethod((Type)compiledShell, (String)"execute");
                if (m != null) {
                    try {
                        if (Runtime.INSTANCE.currentGraph() != null) {
                            DisposableIterator i = Library.apply((int)1);
                            try {
                                while (i.next()) {
                                    m.invoke(null, null);
                                }
                                i.dispose(null);
                            }
                            catch (Throwable e) {
                                i.dispose(e);
                                Utils.rethrow((Throwable)e);
                            }
                        } else {
                            m.invoke(null, null);
                        }
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                }
            }
        }
        if (ex != null) {
            c.getWorkbench();
            Workbench.log(ex);
            System.err.println(ex);
        }
        Utils.rethrow(ex);
    }

    @Override
    public void run() {
    }
}

