/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.api;

import de.grogra.api.APIApplication;
import de.grogra.api.APIRunner;
import de.grogra.api.XLinLineRunner;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.View3D;
import de.grogra.pf.boot.Main;
import de.grogra.pf.data.DatasetRef;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.io.OutputStreamSource;
import de.grogra.pf.registry.Executable;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.SharedValue;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.ProjectWorkbench;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIApplication;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.FileFactory;
import de.grogra.pf.ui.registry.SourceFile;
import de.grogra.rgg.RGGRoot;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.jfree.data.json.impl.JSONArray;
import org.jfree.data.json.impl.JSONObject;

public class APIWorkbench
extends ProjectWorkbench
implements TreeModelListener {
    private Window window;
    private APILogHandler loggy;

    public APIWorkbench(Registry registry, JobManager jm, UIToolkit ui, Map initParams) {
        super(jm, ui, initParams);
    }

    public APIWorkbench(Registry registry, JobManager jm, UIApplication app, Map initParams) {
        super(jm, app.getToolkit(), initParams);
        this.app = (APIApplication)app;
    }

    public void init() {
        Executable.runExecutables((Registry)this.getRegistry().getRootRegistry(), (String)"/hooks/apiLaunch", (RegistryContext)this.getRegistry(), (StringMap)new StringMap());
        this.loggy = new APILogHandler();
        this.loggy.setLevel(Level.ALL);
        this.getLogger().addHandler(this.loggy);
    }

    public JSONArray popLogsRecords() {
        JSONArray result = this.loggy.getRecords();
        this.loggy.cleanRecords();
        return result;
    }

    public static void getProjectGraph(Item item, Object info, Context ctx) {
        ((APIWorkbench)ctx.getWorkbench()).getProjectGraph(info);
    }

    public void getProjectGraph(Object info) {
        Node root = this.getRegistry().getProjectGraph().getRoot();
        ArrayList<Node> nList = new ArrayList<Node>();
        this.visitNode(root, nList);
        JSONArray nodes = new JSONArray();
        JSONArray edges = new JSONArray();
        for (Node n : nList) {
            JSONObject step = new JSONObject();
            step.put((Object)"type", (Object)n.getNType().toString());
            step.put((Object)"id", (Object)n.getId());
            nodes.add((Object)step);
            edges.addAll((Collection)this.catNode(n));
        }
        ((APIRunner)info).addList("projectgraphNodes", nodes);
        ((APIRunner)info).addList("projectgraphEdges", edges);
        ((APIRunner)info).addResponseContent("projectgraphRoot", "" + root.getId());
    }

    private void visitNode(Node n, ArrayList<Node> visited) {
        if (visited.contains(n)) {
            return;
        }
        visited.add(n);
        for (Edge e = n.getFirstEdge(); e != null; e = e.getNext(n)) {
            if (e.isSource(n)) {
                this.visitNode(e.getTarget(), visited);
                continue;
            }
            this.visitNode(e.getSource(), visited);
        }
    }

    public void compile(Object info) {
        ((APIRunner)info).setSendLater();
        final APIRunner a = (APIRunner)info;
        Command x = new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object info, Context context) {
                a.collectAndSend(a);
            }
        };
        this.project.compile((Context)this, x);
    }

    private JSONArray catNode(Node n) {
        JSONArray children = new JSONArray();
        for (Edge e = n.getFirstEdge(); e != null; e = e.getNext(n)) {
            if (!e.isSource(n)) continue;
            Node x = e.getTarget();
            JSONArray child = new JSONArray();
            child.add((Object)n.getId());
            child.add((Object)x.getId());
            child.add((Object)e.getEdgeBits());
            children.add((Object)child);
        }
        return children;
    }

    public Window getWindow() {
        return this.window;
    }

    public void getProjectInfo(Object info) {
    }

    public void export(Object info) throws Exception {
        ((Command)Item.resolveItem((RegistryContext)this, (String)"/ui/panels/3d/defaultview")).run(null, (Context)this);
        View3D view = (View3D)this.getWindow().getPanel("/ui/panels/3d/defaultview");
        if (view != null) {
            ObjectSourceImpl src = new ObjectSourceImpl((Object)view, "view", view.getFlavor(), this.getRegistry(), null);
            String path = ((APIRunner)info).getParameter("path", true);
            String extension = ((APIRunner)info).getParameter("extension", true);
            File f = null;
            MimeType m = null;
            if (extension != null && extension.contains("/")) {
                m = new MimeType(extension, null);
                extension = extension.split("/")[1];
            }
            boolean stream = false;
            if (path != null) {
                f = new File(path);
            } else if (extension != null) {
                f = File.createTempFile("groIMP", "." + extension);
                stream = true;
            }
            if (f != null) {
                this.setProperty("export-visible-layer", false);
                if (m == null) {
                    m = IO.getMimeTypeToWrite((String)f.getName(), (IOFlavor)src.getFlavor());
                }
                this.export((FilterSource)src, m, f);
                if (stream) {
                    FileInputStream in = new FileInputStream(f);
                    ((APIRunner)info).addResponseContent(in.readAllBytes());
                }
            }
        }
    }

    public boolean saveAs(Object info) {
        try {
            String path = ((APIRunner)info).getParameter("path", false);
            if (this.saveAs(new File(path), IO.getMimeType((String)path))) {
                ((APIRunner)info).addResponseContent("message", "file saved");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            FilterSource fs = IO.createPipeline((FilterSource)new ObjectSourceImpl((Object)this.getRegistry(), "registry", IOFlavor.valueOf(this.getRegistry().getClass()), this.getRegistry(), null), (IOFlavor)new IOFlavor(new MimeType("application/x-grogra-project+zip"), 64, null));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ((OutputStreamSource)fs).write((OutputStream)baos);
                ((APIRunner)info).addResponseContent(baos.toByteArray());
                return true;
            }
            catch (IOException e1) {
                ((APIRunner)info).addResponseContent("exception message", e1.getMessage());
                ((APIRunner)info).addResponseContent("exception", e1.getStackTrace());
                ((APIRunner)info).setCode(500);
                return false;
            }
        }
    }

    public void addNode(Object info) throws Exception {
        FileFactory ex = (FileFactory)Item.resolveItem((RegistryContext)this.getProject(), (String)"/objects/objects/file");
        StringMap x = new StringMap();
        URL u = null;
        String path = ((APIRunner)info).getParameter("path", true);
        if (path != null) {
            f = new File(path);
            if (f.exists()) {
                u = Utils.fileToURL((File)f);
            }
        } else if (((APIRunner)info).getParameter("extension", true) != null && ((APIRunner)info).getContent() != null) {
            f = File.createTempFile("groIMP", "." + ((APIRunner)info).getParameter("extension", true));
            FileOutputStream outputStream = new FileOutputStream(f);
            outputStream.write(((APIRunner)info).getContent());
            outputStream.close();
            u = Utils.fileToURL((File)f);
        }
        if (u != null) {
            String nodeId = ((APIRunner)info).getParameter("nodeId", true);
            if (nodeId != null) {
                Node parent;
                if (nodeId.equals("RGGRoot")) {
                    parent = RGGRoot.getRoot((GraphManager)this.getProject().getRegistry().getProjectGraph());
                } else {
                    int id = Integer.parseInt(nodeId);
                    parent = (Node)this.getRegistry().getProjectGraph().getNodeForId((long)id);
                }
                if (parent != null) {
                    this.addNode((Node)ex.addFromURL(this.getRegistry(), u, (ModifiableMap)x, (Workbench)this), parent);
                }
            } else {
                this.addNode((Node)ex.addFromURL(this.getRegistry(), u, (ModifiableMap)x, (Workbench)this));
            }
        } else {
            ((APIRunner)info).setCode(415);
            ((APIRunner)info).addResponseContent("error", "file does not exist");
        }
    }

    private void addNode(final Node node, final Node parent) {
        UI.executeLockedly((Lockable)this.getRegistry().getProjectGraph(), (boolean)true, (Command)new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object arg, Context c) {
                node.setExtentIndex(6);
                GraphManager g = APIWorkbench.this.getRegistry().getProjectGraph();
                parent.addEdgeBitsTo(node, 512, g.getActiveTransaction());
            }
        }, null, (Context)this, (int)10000);
    }

    public void addSourceFile(Object info) throws Exception {
        String path = ((APIRunner)info).getParameter("path", true);
        if (path != null) {
            File f = new File(path);
            if (f.exists()) {
                this.addSourceFile(f, IO.getMimeType((String)path), null);
            }
        } else if (((APIRunner)info).getParameter("name", true) != null && ((APIRunner)info).getContent() != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(((APIRunner)info).getContent());
            this.addSourceFile(((APIRunner)info).getParameter("name", true), IO.getMimeType((String)((APIRunner)info).getParameter("name", true)), in, null);
        }
    }

    public static void getSourceFiles(Item item, Object info, Context ctx) {
        Item fileDir = ctx.getWorkbench().getRegistry().getDirectory("/project/objects/files", null);
        Item[] files = Item.findAll((Item)fileDir, (ItemCriterion)ItemCriterion.INSTANCE_OF, SourceFile.class, (boolean)true);
        Object[] names = new String[files.length];
        int i = 0;
        for (Item f : files) {
            names[i++] = f.getAbsoluteName().substring("/project/objects/files/".length());
        }
        ((APIRunner)info).addResponseContent("data", names);
    }

    public static void getSourceFileContent(Item item, Object info, Context ctx) throws Exception {
        String name = ((APIRunner)info).getParameter("name", false);
        Item i = Item.resolveItem((RegistryContext)ctx.getWorkbench().getRegistry(), (String)("/project/objects/files/" + name));
        if (i != null) {
            Object f = ctx.getWorkbench().getRegistry().getProjectFile(i.getSystemId());
            try {
                InputStream ins = ctx.getWorkbench().getRegistry().getFileSystem().getInputStream(f);
                ((APIRunner)info).addResponseContent(ins.readAllBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ((APIRunner)info).setCode(400);
            ((APIRunner)info).setReason("File not found");
        }
    }

    public static void setSourceFileContent(Item item, Object info, Context ctx) throws Exception {
        ((APIWorkbench)ctx.getWorkbench()).setSourceFileContent(info);
    }

    public void setSourceFileContent(Object info) throws Exception {
        Registry.setCurrent((RegistryContext)this.getRegistry());
        String name = ((APIRunner)info).getParameter("name", false);
        if (name != null && ((APIRunner)info).getContent() != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(((APIRunner)info).getContent());
            try {
                this.getProject().setSourceFileContent(name, (InputStream)in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void renameSourceFile(Object info) throws Exception {
        String file = ((APIRunner)info).getParameter("name", false);
        String name = ((APIRunner)info).getParameter("newName", false);
        this.renameSourceFile(file, name);
    }

    public void removeSourceFile(Object info) throws Exception {
        String file = ((APIRunner)info).getParameter("name", false);
        if (file != null) {
            this.removeSourceFile(file);
        } else {
            ((APIRunner)info).setCode(204);
            ((APIRunner)info).setReason("No File name presented");
        }
    }

    public static void getDatasets(Item item, Object info, Context ctx) {
        Item fileDir = ctx.getWorkbench().getRegistry().getDirectory("/project/objects/datasets", null);
        Item[] files = Item.findAll((Item)fileDir, (ItemCriterion)ItemCriterion.INSTANCE_OF, SharedValue.class, (boolean)true);
        Object[] names = new String[files.length];
        int i = 0;
        for (Item f : files) {
            names[i++] = f.getName();
        }
        ((APIRunner)info).addResponseContent("data", names);
    }

    public static void getDataset(Item item, Object info, Context ctx) throws Exception {
        Registry.setCurrent((RegistryContext)ctx.getWorkbench().getRegistry());
        String name = ((APIRunner)info).getParameter("name", false);
        DatasetRef d = new DatasetRef(name);
        StringBuffer sb = new StringBuffer();
        d.export(sb, ",");
        ((APIRunner)info).addResponseContent(sb.toString().getBytes());
    }

    public static void close(Item item, Object info, Context ctx) {
        ((APIRunner)info).setSendLater();
        final APIRunner a = (APIRunner)info;
        Command x = new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object info, Context context) {
                a.collectAndSend(a);
            }
        };
        ((APIWorkbench)ctx.getWorkbench()).close(x);
    }

    public void listFunctions(Object info) {
        Command[] fc = this.getFunctions();
        Object[] fs = new String[fc.length];
        int i = 0;
        for (Command c : fc) {
            fs[i++] = c.getCommandName();
        }
        ((APIRunner)info).addResponseContent("data", fs);
    }

    public String getApplicationName() {
        return "API";
    }

    public void dispose(Command afterDispose) {
        if (this.window != null) {
            this.window.dispose();
        }
        this.getRegistry().removeFileSystemListener((TreeModelListener)this);
        this.getRegistry().removeTreeModelListener((TreeModelListener)this);
        this.getRegistry().dispose();
        if (afterDispose != null) {
            afterDispose.run(null, (Context)this);
        }
        APIWorkbench.setCurrent(null);
        this.window = null;
    }

    protected void close(final Command afterDispose) {
        if (this.getWindow() != null) {
            final Panel[] panels = this.getWindow().getPanels(null);
            new Command(){

                public void run(Object info, Context ctx) {
                    for (int i = 0; i < panels.length; ++i) {
                        Panel p = panels[i];
                        if (p == null) continue;
                        panels[i] = null;
                        p.checkClose((Command)this);
                        return;
                    }
                    APIWorkbench.this.close0(afterDispose);
                }

                public String getCommandName() {
                    return null;
                }
            }.run(null, (Context)this);
        } else {
            this.close0(afterDispose);
        }
    }

    void close0(Command afterDispose) {
        Registry r = this.getRegistry().getRootRegistry();
        Executable.runExecutables((Registry)r, (String)"/hooks/close", (RegistryContext)r, (StringMap)UI.getArgs((Context)this, null));
        this.getApplication().getWorkbenchManager().closeWorkbench((ProjectWorkbench)this, afterDispose);
    }

    public Workbench getMainWorkbench() {
        return this.app.getMainWorkbench();
    }

    public void stopLocalFileSynchronization() {
    }

    public void startLocalFileSynchronization() {
    }

    public void initialize() {
        super.initialize();
        APIWorkbench.setCurrent((Workbench)this);
        this.getRegistry().addFileSystemListener((TreeModelListener)this);
        this.updateName();
        this.getLogger().setFilter(null);
        Map propMap = Map.EMPTY_MAP;
        Object o = this.getRegistry().getRootRegistry().getUserProperty(Main.SCREEN_PROPERTY_ID.intValue());
        if (o != null) {
            propMap = new StringMap().putInt("screen", ((Integer)o).intValue());
        }
        this.window = this.getToolkit().createWindow(CLOSE, propMap);
        if (this.window != null) {
            this.initializeWindow();
            this.window.show(true, null);
        }
        StringMap m = new StringMap().putObject("registry", (Object)this.getRegistry());
        m.putObject("workbench", (Object)this);
        m.putObject("filesystem", (Object)this.getRegistry().getFileSystem());
        Executable.runExecutables((Registry)this.getRegistry().getRootRegistry(), (String)"/hooks/projectloaded", (RegistryContext)this.getRegistry(), (StringMap)m);
    }

    void initializeWindow() {
        this.initializeWindow(this.window);
    }

    public boolean isSelected() {
        return false;
    }

    public void execute(Object info) throws Exception {
        String func = ((APIRunner)info).getParameter("name", false);
        this.execute(func);
    }

    public static void runXLQuery(Item item, Object info, Context ctx) throws Exception {
        ((APIWorkbench)ctx.getWorkbench()).runXLQuery(info);
    }

    private void runXLQuery(Object info) throws Exception {
        String query;
        try {
            query = ((APIRunner)info).getParameter("xl", false);
        }
        catch (Exception e) {
            query = new String(((APIRunner)info).getContent(), StandardCharsets.UTF_8);
        }
        XLinLineRunner xlIn = new XLinLineRunner();
        xlIn.run(query, (Context)this);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    public Workbench open(FilterSource fs, Map initParams) {
        return null;
    }

    public void open(Object info) {
    }

    public static void exportFromRGGRoot(Item item, Object info, Context ctx) throws Exception {
        ((APIWorkbench)ctx.getWorkbench()).exportFromRGG(info);
    }

    public void exportFromRGG(Object info) throws Exception {
        Node rggroot = RGGRoot.getRoot((GraphManager)this.getProject().getRegistry().getProjectGraph());
        this.exportFromNode(info, rggroot);
    }

    public void exportFromNode(Object info) throws Exception {
        String nodeId = ((APIRunner)info).getParameter("nodeId", false);
        int id = Integer.parseInt(nodeId);
        Node n = (Node)this.getProject().getRegistry().getProjectGraph().getNodeForId((long)id);
        this.exportFromNode(info, n);
    }

    public void exportFromNode(Object info, Node root) throws Exception {
        if (root == null) {
            return;
        }
        HashMap allNodes = new HashMap();
        ObjectList v = new ObjectList();
        GraphManager graph = this.getRegistry().getProjectGraph();
        graph.getListOfNodes(graph.getRoot(), null, false, allNodes, v);
        HashMap<Node, String> visited = new HashMap<Node, String>();
        ObjectList toVisit = new ObjectList();
        graph.getListOfNodes(root, null, false, visited, toVisit);
        visited.put(root, "");
        for (Map.Entry entry : allNodes.entrySet()) {
            entry.setValue(Boolean.toString(((Node)entry.getKey()).getIgnored()));
            if (visited.containsKey(entry.getKey())) {
                ((Node)entry.getKey()).setIgnored(Boolean.valueOf(false));
                continue;
            }
            ((Node)entry.getKey()).setIgnored(Boolean.valueOf(true));
        }
        this.setProperty("export-visible-layer", true);
        this.export(info);
        for (Map.Entry entry : allNodes.entrySet()) {
            ((Node)entry.getKey()).setIgnored(Boolean.valueOf((String)entry.getValue()));
        }
    }

    private class APILogHandler
    extends Handler {
        private JSONArray records = new JSONArray();

        private APILogHandler() {
        }

        @Override
        public synchronized void publish(LogRecord record) {
            JSONObject logR = new JSONObject();
            logR.put((Object)"message", (Object)record.getMessage());
            this.records.add((Object)logR);
        }

        public JSONArray getRecords() {
            return this.records;
        }

        public void cleanRecords() {
            this.records = new JSONArray();
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

