/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.api;

import de.grogra.api.APIApplication;
import de.grogra.api.APICommandNotFoundException;
import de.grogra.api.APIParameterNotDefinedException;
import de.grogra.api.APIReturn;
import de.grogra.api.APIWorkbench;
import de.grogra.cli.ui.CLIConsolePanel;
import de.grogra.cli.ui.CLITextComponent;
import de.grogra.http.Request;
import de.grogra.http.Server;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.ProjectWorkbench;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.StringMap;
import de.grogra.util.WrapException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.jfree.data.json.impl.JSONArray;
import org.jfree.data.json.impl.JSONObject;

public class APIRunner
implements Command {
    public static final int STATUS_NO_CONTENT = 204;
    public static final int STATUS_OK = 200;
    public static final int STATUS_BAD_REQUEST = 400;
    public static final int STATUS_NOT_FOUND = 404;
    public static final int STATUS_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int STATUS_IM_A_TEAPOT = 418;
    public static final int STATUS_LOCKED = 423;
    public static final int STATUS_INTERNAL_SERVER_ERROR = 500;
    public static final int STATUS_NOT_IMPLEMENTED = 501;
    public static final String INP_NAME = "name";
    public static final String INP_NEW_NAME = "newName";
    public static final String INP_SYSTEM_PATH = "path";
    public static final String INP_FILE_EXTENSION = "extension";
    public static final String INP_NODE_ID = "nodeId";
    public static final String RETURN_DATA = "data";
    public static final String RETURN_RESULT = "result";
    public static final String RETURN_MESSAGE = "message";
    public static final String RETURN_ID = "id";
    public static final String RETURN_ERROR = "error";
    public static int gcCounter = 0;
    private Request request;
    private Socket socket;
    private StringMap params;
    private String path;
    private APIWorkbench wb;
    private Command c;
    private APIApplication app;
    private APIReturn jsonData;
    private byte[] binaryData;
    private int code;
    private String reason;
    private String responseType;
    private boolean sendLater;

    public APIRunner(Request request, Socket socket, APIApplication app) {
        this.socket = socket;
        this.request = request;
        this.path = request.getPath();
        this.app = app;
        this.jsonData = new APIReturn();
        this.code = 200;
        this.reason = "";
        this.sendLater = false;
        this.responseType = "application/json";
        try {
            this.params = this.parseToStingMap(request.getQuery());
            this.setWB();
            this.setCommand();
            this.execute();
        }
        catch (Exception e) {
            this.addResponseContent("exception_class", e.getClass().getName());
            this.addResponseContent("exception_message", e.getMessage());
            this.jsonData.addList("exception", e.getStackTrace());
            this.setCode(404);
            this.send();
        }
    }

    private void setWB() throws Exception {
        String path = this.getPath();
        if (path.startsWith("/api/wb/")) {
            int index = (path = path.substring("/api/wb/".length())).indexOf(47);
            if (index == -1) {
                throw new APIParameterNotDefinedException("workbench ID");
            }
            String wbToken = path.substring(0, index);
            path = path.substring(index);
            this.setPath(path);
            this.wb = (APIWorkbench)this.app.getWorkbenchManager().getWorkbench((Object)Integer.parseInt(wbToken));
        } else if (path.startsWith("/api/app/")) {
            path = path.substring("/api/app".length());
            this.wb = (APIWorkbench)this.app.getMainWorkbench();
            this.setPath(path);
        } else {
            throw new APICommandNotFoundException();
        }
        if (this.wb == null) {
            throw new APIParameterNotDefinedException("workbench ID");
        }
    }

    public void setCommand() throws APICommandNotFoundException {
        this.c = (Command)Item.resolveItem((RegistryContext)this.wb.getRegistry(), (String)this.path);
        if (this.c == null) {
            throw new APICommandNotFoundException();
        }
    }

    private StringMap parseToStingMap(String query) throws UnsupportedEncodingException {
        StringMap s = new StringMap();
        if (query == null || query.equals("")) {
            return s;
        }
        for (String pair : query.split("&")) {
            int index = pair.indexOf(61);
            if (index == -1) continue;
            s.put(pair.substring(0, index), (Object)URLDecoder.decode(pair.substring(index + 1, pair.length()), StandardCharsets.UTF_8.name()));
        }
        return s;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Object info, Context context) {
        try {
            Workbench.setCurrent((Workbench)this.getWorkbench());
            Registry.setCurrent((RegistryContext)this.getWorkbench().getRegistry());
            this.c.run((Object)this, (Context)this.getWorkbench());
        }
        catch (WrapException we) {
            if (we.getCause() instanceof APIParameterNotDefinedException) {
                this.setCode(400);
                this.jsonData.addPoint(RETURN_ERROR, "Parameter is missing: \"" + ((APIParameterNotDefinedException)we.getCause()).getVarName() + "\"");
                this.setReason("Parameter is missing");
            } else {
                this.setCode(500);
                this.addResponseContent("exception_class", ((Object)((Object)we)).getClass().getName());
                this.addResponseContent("exception_message", we.getCause().getMessage());
                this.jsonData.addList("exception", we.getCause().getStackTrace());
            }
        }
        catch (Exception e) {
            this.setCode(500);
            this.addResponseContent("exception_class", e.getClass().getName());
            this.addResponseContent("exception_message", e.getMessage());
            this.jsonData.addList("exception", e.getStackTrace());
            this.send();
            return;
        }
        finally {
            if (!this.sendLater) {
                this.collectAndSend(this);
            }
        }
    }

    public void collectAndSend(APIRunner a) {
        if (this.app.getMainWorkbench() != a.wb) {
            try {
                CLITextComponent cont;
                CLIConsolePanel con = (CLIConsolePanel)PanelFactory.getAndShowPanel((Context)a.wb, (String)"/ui/panels/rgg/console", (Map)Map.EMPTY_MAP);
                if (con != null && (cont = (CLITextComponent)con.getContent()) != null) {
                    a.jsonData.addList("console", cont.writeAll());
                }
                a.jsonData.addPoint("logs", a.wb.popLogsRecords());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        a.send();
        if (gcCounter++ > 100) {
            System.gc();
            gcCounter = 0;
        }
    }

    public void execute() throws APICommandNotFoundException {
        if (this.c == null || this.wb == null) {
            throw new APICommandNotFoundException();
        }
        UI.executeLockedly((Lockable)this.wb.getRegistry().getProjectGraph(), (boolean)true, (Command)this, (Object)this, (Context)this.wb, (int)10000);
    }

    public String getParameter(String key, boolean nullable) throws Exception {
        if (!nullable && !this.params.containsKey(key)) {
            throw new APIParameterNotDefinedException(key);
        }
        return (String)this.params.get(key);
    }

    public byte[] getContent() {
        return this.request.getContent();
    }

    public void addResponseContent(String key, String value) {
        this.jsonData.addPoint(key, value);
    }

    public void addResponseContent(String key, Object[] value) {
        this.jsonData.addList(key, value);
    }

    public void addResponseContent(byte[] value) {
        this.binaryData = value;
    }

    public void setCode(int c) {
        this.code = c;
    }

    public void setReason(String r) {
        this.reason = r;
    }

    public void setResponseType(String s) {
        this.responseType = s;
    }

    public void setSendLater() {
        this.sendLater = true;
    }

    private void send() {
        try {
            if (this.binaryData != null) {
                Server.writeResponse((int)this.code, (String)this.reason, null, (byte[])this.binaryData, (boolean)true, (OutputStream)this.socket.getOutputStream());
            } else {
                Server.writeResponse((int)this.code, (String)this.reason, (String)this.responseType, (byte[])this.jsonData.toString().getBytes(), (boolean)true, (OutputStream)this.socket.getOutputStream());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addPoint(String string, JSONObject obj) {
        this.jsonData.addPoint(string, obj);
    }

    public void addList(String string, Object[] list) {
        this.jsonData.addList(string, list);
    }

    public void addResponseContent(String key, JSONArray list) {
        this.jsonData.addPoint(key, list);
    }

    public ProjectWorkbench getWorkbench() {
        return this.wb;
    }

    public void addList(String string, JSONArray nodes) {
        this.jsonData.addPoint(string, nodes);
    }

    public String getCommandName() {
        return null;
    }
}

