/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.api;

import de.grogra.api.APIRunner;
import de.grogra.api.APIServer;
import de.grogra.api.APIToolkit;
import de.grogra.api.APIWorkbench;
import de.grogra.api.APIWorkbenchManager;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.InputStreamSourceImpl;
import de.grogra.pf.registry.Application;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.ProjectManager;
import de.grogra.pf.ui.ProjectWorkbench;
import de.grogra.pf.ui.UIApplication;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.WorkbenchManager;
import de.grogra.pf.ui.registry.FilterSourceFactory;
import de.grogra.pf.ui.registry.ProjectDirectory;
import de.grogra.pf.ui.registry.ProjectFactory;
import de.grogra.projectmanager.ProjectFactoryImpl;
import de.grogra.projectmanager.ProjectManagerImpl;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.data.json.impl.JSONArray;
import org.jfree.data.json.impl.JSONObject;

public class APIApplication
extends UIApplication {
    private APIServer server;
    static APIApplication PLUGIN;

    public APIApplication() {
        assert (PLUGIN == null);
        PLUGIN = this;
    }

    public APIApplication getInstance() {
        return PLUGIN;
    }

    public static void run(Application app) {
        Item ite = Item.resolveItem((RegistryContext)Main.getRegistry(), (String)"/api/http");
        int port = (Integer)Utils.get((Map)ite, (Object)"port", (Object)58081);
        if (Main.getProperty((String)"port") != null) {
            try {
                port = Integer.parseInt(Main.getProperty((String)"port"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Welcome, \nthe GroIMP HTTP api is running on port:" + port + ".\n \n You can now connect to it via http or by using a client libary. \n Closing this window will stop the API-server!\n For additional information: \n \t * Visit https://wiki.grogra.de/doku.php?id=user-guide:additional_interfaces:api \n \t * Try the embedded doc: http://localhost:58081/api/app/ui/commands/app/doc. ");
        ProjectManager pm = ProjectManagerImpl.getInstance();
        APIWorkbenchManager wbm = new APIWorkbenchManager(Registry.create((Registry)app.getRegistry()), PLUGIN);
        APIToolkit uitoolkit = new APIToolkit();
        try {
            PLUGIN.init(pm, (UIToolkit)uitoolkit, (WorkbenchManager)wbm, port);
            PLUGIN.start();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void run(Object arg, Context context) {
        System.out.println("welcome to the API");
        ProjectManager pm = ProjectManagerImpl.getInstance();
        APIWorkbenchManager wbm = new APIWorkbenchManager(Registry.create((Registry)context.getWorkbench().getRegistry()), PLUGIN);
        APIToolkit uitoolkit = new APIToolkit();
        int port = 58081;
        try {
            PLUGIN.init(pm, (UIToolkit)uitoolkit, (WorkbenchManager)wbm, port);
            PLUGIN.start();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void start() {
        try {
            this.setMainWorkbench((APIWorkbench)this.wbm.createWorkbench((ProjectFactory)new ProjectFactoryImpl()));
        }
        catch (IOException e1) {
            System.out.println("main workbench cant be created");
            Main.exit();
        }
        this.server.run();
        System.out.println("bye bye");
    }

    public void init(ProjectManager pm, UIToolkit uitoolkit, WorkbenchManager wbm, int port) throws IOException {
        super.init(pm, uitoolkit, wbm);
        ServerSocket socket = new ServerSocket(port);
        Logger log = Logger.getGlobal();
        Level info = Level.INFO;
        Level warning = Level.WARNING;
        this.server = new APIServer(socket, log, info, warning, this);
    }

    public String getCommandName() {
        return null;
    }

    public Workbench getCurrentWorkbench() {
        return null;
    }

    public ProjectWorkbench open(Object info) throws Exception {
        ProjectWorkbench wb = null;
        String path = ((APIRunner)info).getParameter("path", true);
        if (path != null) {
            File f = new File(path);
            if (f.exists()) {
                FileSource fs = FileSource.createFileSource((String)f.getAbsolutePath(), (MimeType)IO.getMimeType((String)path), (RegistryContext)this, null);
                wb = this.open((FilterSource)fs, (Map)new StringMap());
            } else {
                ((APIRunner)info).setCode(404);
            }
        } else {
            byte[] c = ((APIRunner)info).getContent();
            if (c != null) {
                ByteArrayInputStream in = new ByteArrayInputStream(c);
                InputStreamSourceImpl fs = new InputStreamSourceImpl((InputStream)in, "", IO.getMimeType((String)"fake.gsz"), this.getRegistry(), (ModifiableMap)new StringMap());
                wb = this.open((FilterSource)fs, (Map)new StringMap());
            }
        }
        if (wb != null) {
            ((APIRunner)info).addResponseContent("id", this.wbm.getWorkbenchId(wb).toString());
        }
        return wb;
    }

    public ProjectWorkbench open(FilterSource fs, Map initParams) {
        try {
            return this.open(fs, (ProjectFactory)new ProjectFactoryImpl(), initParams);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close(Object info) {
        ((APIRunner)info).addResponseContent("message", "Bye Bye");
        this.exit();
    }

    public void create(Object info) throws Exception {
        String name;
        try {
            name = ((APIRunner)info).getParameter("name", false);
        }
        catch (Exception e) {
            name = "newRGG";
        }
        String newName = ((APIRunner)info).getParameter("newName", true);
        Object id = this.create(name, newName);
        ((APIRunner)info).addResponseContent("id", id.toString());
    }

    public void loadExample(Object info) throws Exception {
        String name = ((APIRunner)info).getParameter("name", false);
        String newName = ((APIRunner)info).getParameter("newName", true);
        Object id = this.loadExample(name, newName);
        ((APIRunner)info).addResponseContent("id", id.toString());
    }

    public Object loadExample(String name, String newName) {
        Item fileDir = Item.resolveItem((RegistryContext)this.getMainWorkbench().getRegistry().getRootRegistry(), (String)"/examples");
        ProjectDirectory projDir = (ProjectDirectory)Item.findFirst((Item)fileDir, (ItemCriterion)new ItemCriterion(){

            public boolean isFulfilled(Item item, Object info) {
                return ProjectDirectory.class.isInstance(item) && item.getName().equals(info);
            }

            public String getRootDirectory() {
                return null;
            }
        }, (Object)name, (boolean)true);
        Item p = projDir.getProjectForVersion((Context)this.getMainWorkbench(), "latest");
        if (p != null && p instanceof FilterSourceFactory) {
            StringMap m = new StringMap();
            Object x = ((FilterSourceFactory)p).evaluate((RegistryContext)this.getMainWorkbench().getRegistry(), m);
            if (x != null) {
                m.putBoolean("start-as-demo", Boolean.TRUE.booleanValue());
                ProjectWorkbench wb = this.open((FilterSource)x, (Map)new StringMap());
                if (wb != null) {
                    wb.getProject().setName(newName != null ? newName : ((FilterSourceFactory)p).getName());
                    if (wb != null) {
                        this.selectWorkbench(wb);
                        return this.wbm.getWorkbenchId(wb);
                    }
                }
            }
        }
        return null;
    }

    public void listExamples(Object info) {
        String tag = null;
        try {
            tag = ((APIRunner)info).getParameter("tags", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.listExampleFilterSourceFactorys(info, "/examples", tag);
    }

    public void listTemplates(Object info) {
        this.listFilterSourceFactorys(info, "/ui/templates", null);
    }

    private void listExampleFilterSourceFactorys(Object info, String path, String tag) {
        Item[] files;
        JSONArray result = new JSONArray();
        Item fileDir = Item.resolveItem((RegistryContext)((APIRunner)info).getWorkbench().getRegistry(), (String)path);
        for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)ItemCriterion.INSTANCE_OF, ProjectDirectory.class, (boolean)true)) {
            if (tag != null && (f.getDescription("Tags") == null || !Arrays.asList(f.getDescription("Tags").toString().split(",")).contains(tag))) continue;
            JSONObject part = new JSONObject();
            part.put((Object)"id", (Object)f.getName());
            part.put((Object)"title", f.getDescription("Name"));
            part.put((Object)"description", f.getDescription("ShortDescription"));
            part.put((Object)"tags", f.getDescription("Tags"));
            result.add((Object)part);
        }
        ((APIRunner)info).addResponseContent("data", result);
    }

    private void listFilterSourceFactorys(Object info, String path, String tag) {
        Item[] files;
        JSONArray result = new JSONArray();
        Item fileDir = Item.resolveItem((RegistryContext)((APIRunner)info).getWorkbench().getRegistry(), (String)path);
        for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)ItemCriterion.INSTANCE_OF, FilterSourceFactory.class, (boolean)true)) {
            if (tag != null && (f.getDescription("Tags") == null || !Arrays.asList(f.getDescription("Tags").toString().split(",")).contains(tag))) continue;
            JSONObject part = new JSONObject();
            part.put((Object)"id", (Object)f.getName());
            part.put((Object)"title", f.getDescription("Name"));
            part.put((Object)"description", f.getDescription("ShortDescription"));
            part.put((Object)"tags", f.getDescription("Tags"));
            result.add((Object)part);
        }
        ((APIRunner)info).addResponseContent("data", result);
    }

    public void selectWorkbench(Object info) {
    }

    public void listWorkbenches(Object info) {
        JSONArray result = new JSONArray();
        for (Workbench wb : this.wbm.getWorkbenches()) {
            JSONObject part = new JSONObject();
            part.put((Object)"id", this.wbm.getWorkbenchId((ProjectWorkbench)wb));
            part.put((Object)"title", (Object)wb.getName());
            result.add((Object)part);
        }
        ((APIRunner)info).addResponseContent("data", result);
    }

    public void listProjects(Object info) {
        ((APIRunner)info).addResponseContent("data", this.pm.listOpenProjects());
    }

    public void stop() {
        this.exit();
    }

    public void exit() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getSwagger(Item item, Object info, Context ctx) throws Exception {
        I18NBundle bundel = I18NBundle.getInstance(ctx.getWorkbench().getApplication().getClass());
        ((APIRunner)info).addResponseContent(bundel.getString("saggercode").getBytes());
    }

    public static void getOpenAPI(Item item, Object info, Context ctx) throws Exception {
        I18NBundle bundel = I18NBundle.getInstance(ctx.getWorkbench().getApplication().getClass());
        ((APIRunner)info).addResponseContent(bundel.getString("openAPI").getBytes());
    }
}

