/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.grophysics;

import com.bulletphysics.linearmath.Transform;
import de.grogra.graph.impl.Node;
import de.grogra.rgg.Library;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PhysicsUtils {
    public Matrix4d offsetMatrix(Matrix4d in, Point3d offset) {
        return this.offsetMatrix(in, new Vector3d((Tuple3d)offset));
    }

    public Matrix4d offsetMatrix(Matrix4d in, Vector3d offset) {
        Matrix4d result = new Matrix4d();
        result.set(in);
        Matrix4d trans = this.getTranslation(offset);
        result.mul(trans);
        return result;
    }

    public Matrix4d getMatrix4d(Transform transform) {
        Matrix4f mf = new Matrix4f();
        transform.getMatrix(mf);
        Matrix4d result = new Matrix4d(mf);
        return result;
    }

    public Matrix4d getTranslation(Vector3d v) {
        Matrix4d result = new Matrix4d();
        result.setIdentity();
        result.setTranslation(v);
        return result;
    }

    public Matrix4d getDifference(Matrix4d mNew, Matrix4d mOld) {
        Matrix4d result = new Matrix4d();
        result.invert(mOld);
        result.mul(mNew);
        return result;
    }

    public void showNodeInfo(Node node) {
        Library.println((Object)("Node " + node.getId() + " " + node.getName() + " has " + node.getDirectChildCount() + " children"));
    }
}

