/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.grophysics;

import com.bulletphysics.collision.broadphase.AxisSweep3;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CylinderShapeZ;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.Generic6DofConstraint;
import com.bulletphysics.dynamics.constraintsolver.RotationalLimitMotor;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.TranslationalLimitMotor;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.imp3d.objects.Frustum;
import de.grogra.imp3d.objects.Null;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.math.TMatrix4d;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import de.grogra.turtle.F;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import uk.ac.soton.grophysics.Attributes;
import uk.ac.soton.grophysics.FlexNode;
import uk.ac.soton.grophysics.MassObject;
import uk.ac.soton.grophysics.PhysicsUtils;
import uk.ac.soton.grophysics.PhysicsVisitor;

public class PhysicsModel
extends Node {
    private static final long serialVersionUID = -7481390093150351783L;
    protected DynamicsWorld dynamicWorld;
    private CollisionConfiguration collisionConfiguration;
    private CollisionDispatcher dispatcher;
    RigidBody groundBody;
    float groundDepth = 10.0f;
    Transform groundJointFrame;
    public boolean debugText;
    private ArrayList<MassObject> massObjects;
    final PhysicsVisitor visitor = new PhysicsVisitor();
    public final PhysicsUtils utils = new PhysicsUtils();
    private int autoIndex = 0;
    public static final Node.NType $TYPE = new Node.NType((Node)new PhysicsModel());
    public static final Node.NType.Field debugText$FIELD = new _Field("debugText", 0x200001, Type.BOOLEAN, null, 0);
    public static final Node.NType.Field massObjects$FIELD;

    public PhysicsModel() {
        this.init();
        this.massObjects = new ArrayList();
        this.debugText = false;
        this.initVisitor();
    }

    protected void init() {
        this.collisionConfiguration = new DefaultCollisionConfiguration();
        this.dispatcher = new CollisionDispatcher(this.collisionConfiguration);
        Vector3f worldAabbMin = new Vector3f(-1000.0f, -1000.0f, -1000.0f);
        Vector3f worldAabbMax = new Vector3f(1000.0f, 1000.0f, 1000.0f);
        AxisSweep3 overlappingPairCache = new AxisSweep3(worldAabbMin, worldAabbMax);
        SequentialImpulseConstraintSolver solver = new SequentialImpulseConstraintSolver();
        this.dynamicWorld = new DiscreteDynamicsWorld((Dispatcher)this.dispatcher, (BroadphaseInterface)overlappingPairCache, (ConstraintSolver)solver, this.collisionConfiguration);
        this.dynamicWorld.setGravity(new Vector3f(0.0f, 0.0f, -9.81f));
        this.dynamicWorld.getDispatchInfo().allowedCcdPenetration = 0.0f;
        this.addGround(100.0f, this.groundDepth / 2.0f);
    }

    public void initVisitor() {
        GraphState gs = Library.graph().getMainState();
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        this.visitor.init(gs, m, this);
    }

    protected void addGround(float size, float depth) {
        BoxShape groundShape = new BoxShape(new Vector3f(size, size, depth));
        groundShape.setUserPointer((Object)"Ground");
        Transform groundTransform = new Transform();
        groundTransform.setIdentity();
        groundTransform.origin.set((Tuple3f)new Vector3f(0.0f, 0.0f, -depth));
        float mass = 0.0f;
        Vector3f localInertia = new Vector3f(0.0f, 0.0f, 0.0f);
        DefaultMotionState myMotionState = new DefaultMotionState(groundTransform);
        RigidBodyConstructionInfo rbInfo = new RigidBodyConstructionInfo(mass, (MotionState)myMotionState, (CollisionShape)groundShape, localInertia);
        this.groundBody = new RigidBody(rbInfo);
        this.groundBody.setRestitution(0.7f);
        this.groundBody.setDamping(0.5f, 0.5f);
        this.dynamicWorld.addRigidBody(this.groundBody);
        this.groundJointFrame = new Transform();
        this.groundJointFrame.setIdentity();
        Vector3f groundOrigin = new Vector3f(0.0f, 0.0f, this.groundDepth / 2.0f);
        this.groundJointFrame.origin.set((Tuple3f)groundOrigin);
    }

    public void add(Object o) {
        String name = "AutoItem" + this.autoIndex++;
        float mass = this.getMass(o);
        this.add(name, o, mass);
    }

    public void add(String name, Object o) {
        float mass = this.getMass(o);
        this.add(name, o, mass);
    }

    public void add(Object o, float mass) {
        String name = "AutoItem" + this.autoIndex++;
        this.add(name, o, mass);
    }

    public void add(String name, Object o, float mass) {
        if (o == null) {
            Library.println((Object)"WARNING: Can't add a null object to the PhysicsModel");
        } else {
            MassObject m = new MassObject(name, o, mass);
            if (this.debugText) {
                Library.println((Object)("PhysicsModel: Adding " + name + " mass " + mass));
            }
            this.massObjects.add(m);
        }
    }

    public void remove(Object o) {
        MassObject mo = this.getMassObject(o);
        if (mo != null) {
            this.massObjects.remove((Object)mo);
        }
    }

    public void setMass(Object o, float mass) {
        MassObject mo = this.getMassObject(o);
        if (mo != null) {
            mo.mass = mass;
        }
    }

    public void updateReference(String name, Object o) {
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject m = this.massObjects.get(i);
            if (!name.equals(m.getName())) continue;
            m.setObject(o);
            Library.println((Object)("Updating " + name));
            break;
        }
    }

    private void updateMass(MassObject m) {
        if (this.debugText) {
            Library.println((Object)"\nStart updateMass");
        }
        Object o = m.getObject();
        float mass = 0.0f;
        if (o instanceof FlexNode) {
            FlexNode f = (FlexNode)((Object)o);
            mass = f.getMass();
        } else {
            mass = this.getMass(o);
        }
        m.setMass(mass);
    }

    public float getMass(Object o) {
        float mass = 0.0f;
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod("getMass", new Class[]{null});
            Object ret = method.invoke(null, new Object[0]);
            if (method.getReturnType().equals(Float.TYPE)) {
                mass = ((Float)ret).floatValue();
            }
        }
        catch (Exception e) {
            Library.println((Object)("WARNING: can't find mass for " + o.getClass().getName()));
            Library.println((Object)e.getMessage());
        }
        return mass;
    }

    protected void addDeferred(MassObject m) {
        Object o = m.getObject();
        RigidBody body = null;
        SphereShape shape = null;
        if (o == null) {
            Library.println((Object)"WARNING: Adding a null object to the PhysicsModel");
        } else if (o instanceof Sphere) {
            if (this.debugText) {
                Library.println((Object)"Adding a Sphere to the PhysicsModel");
            }
            Sphere sphere = (Sphere)o;
            shape = new SphereShape(sphere.getRadius());
            shape.setUserPointer(o);
            body = this.createAndAddBody(m, (CollisionShape)shape);
        } else if (o instanceof FlexNode) {
            if (this.debugText) {
                Library.println((Object)("Adding a FlexNode to the PhysicsModel, mass " + m.getMass()));
            }
            FlexNode flexNode = (FlexNode)((Object)o);
            float r = flexNode.getRadius();
            float l = flexNode.getLength();
            body = this.createCylinder(m, o, l, r);
            this.join(flexNode, m, body);
        } else if (o instanceof Frustum) {
            if (this.debugText) {
                Library.println((Object)("Adding a Frustum to the PhysicsModel (as Cylinder), mass " + m.getMass()));
            }
            Frustum frust = (Frustum)o;
            float r = frust.getTopRadius();
            float rb = frust.getBaseRadius();
            if (rb > r) {
                r = rb;
            }
            float l = frust.getLength();
            body = this.createCylinder(m, o, l, r);
        } else if (o instanceof Cylinder) {
            if (this.debugText) {
                Library.println((Object)("Adding a Cylinder to the PhysicsModel, mass " + m.getMass()));
            }
            Cylinder cyl = (Cylinder)o;
            float r = cyl.getRadius();
            float l = cyl.getLength();
            body = this.createCylinder(m, o, l, r);
        } else if (o instanceof F) {
            if (this.debugText) {
                Library.println((Object)("Adding a Cylinder to the PhysicsModel, mass " + m.getMass()));
            }
            F fcyl = (F)o;
            float r = fcyl.diameter / 2.0f;
            float l = fcyl.length;
            body = this.createCylinder(m, o, l, r);
        } else {
            Library.println((Object)("Can't add a " + o.getClass() + " to the PhysicsModel (yet)"));
            Library.println((Object)"\tPossible Classes:");
            Library.println((Object)("      " + o.getClass().getSuperclass() + " (super)"));
            Class<?>[] carr = o.getClass().getClasses();
            for (int i = 0; i < carr.length; ++i) {
                Library.println((Object)("      " + carr[i].getName()));
            }
        }
    }

    protected void updatePosition(MassObject m) {
        if (this.debugText) {
            Library.println((Object)"\nStart updatePosition");
        }
        CollisionObject o = m.getBody();
        Object nodeObject = m.getObject();
        if (nodeObject == null) {
            Library.println((Object)"WARNING: MassObject reference object is NULL");
        } else if (nodeObject instanceof Node) {
            Matrix4d im;
            Node node = (Node)nodeObject;
            FlexNode flexNode = null;
            FlexNode parentFlexNode = null;
            if (node instanceof FlexNode) {
                flexNode = (FlexNode)node;
                parentFlexNode = flexNode.getParentFlexNode();
            }
            Transform worldTransform = new Transform();
            worldTransform.setIdentity();
            o.getWorldTransform(worldTransform);
            Matrix4d pm = this.utils.getMatrix4d(worldTransform);
            if (this.debugText) {
                Library.println((Object)("Physics world transform =" + pm));
            }
            Point3d offsetP = m.getOffsetCoG();
            Vector3d noffset = new Vector3d();
            noffset.negate((Tuple3d)offsetP);
            Matrix4d nm = this.utils.offsetMatrix(pm, noffset);
            if (this.debugText) {
                Library.println((Object)("compensated for centre of mass =" + nm));
            }
            m.setCurrentGlobalTransform(nm);
            if (this.debugText) {
                Library.println((Object)("set current global " + m.getName() + " to " + nm));
            }
            if (flexNode == null || parentFlexNode == null) {
                im = new Matrix4d(m.getInitialTransform());
                if (im == null) {
                    Library.println((Object)("ERROR: Parent transform for " + m.getName() + " is NULL"));
                }
                if (this.debugText) {
                    Library.println((Object)("Initial transform with no parent =" + im));
                }
            } else {
                MassObject parentMassObject;
                if (this.debugText) {
                    Library.println((Object)("Parent FlexNode " + parentFlexNode.getName()));
                }
                if ((parentMassObject = this.getMassObject((Node)parentFlexNode)) == null) {
                    Library.println((Object)"WARNING: Can't find a MassObject for the parent");
                    im = new Matrix4d(m.getInitialTransform());
                } else {
                    im = parentMassObject.getCurrentGlobalTransform();
                    if (this.debugText) {
                        Library.println((Object)("Parent (" + parentMassObject.getName() + ") current transform =" + im));
                    }
                    Matrix4d dm = m.getParentFrameTransform();
                    if (this.debugText) {
                        Library.println((Object)("Joint offset -\n" + dm.toString()));
                    }
                    im.mul(dm);
                    if (this.debugText) {
                        Library.println((Object)("Parent with joint offset -\n" + im.toString()));
                    }
                }
            }
            Matrix4d delta = this.utils.getDifference(nm, im);
            if (this.debugText) {
                Library.println((Object)("Change matrix =" + delta));
            }
            TMatrix4d deltaTM = new TMatrix4d(delta);
            ((Null)nodeObject).setTransform(deltaTM);
        }
        if (this.debugText) {
            Library.println((Object)"End updatePosition");
        }
    }

    protected RigidBody createCylinder(MassObject mo, Object o, float l, float r) {
        RigidBody body = null;
        CylinderShapeZ shape = null;
        Vector3f extents = new Vector3f(r, r, l / 2.0f);
        shape = new CylinderShapeZ(extents);
        shape.setUserPointer(o);
        Point3d offCoG = new Point3d(0.0, 0.0, (double)(l / 2.0f));
        mo.setOffsetCoG(offCoG);
        body = this.createAndAddBody(mo, (CollisionShape)shape);
        return body;
    }

    protected void join(FlexNode flexNode, MassObject massObject, RigidBody body) {
        MassObject parentMassObject = this.getParentMassObject((Node)flexNode);
        if (parentMassObject == null) {
            Matrix4d parentTransform;
            if (this.debugText) {
                Library.println((Object)"Join to ground");
            }
            if ((parentTransform = massObject.getParentFrameTransform()) == null) {
                parentTransform = Library.transformation((Node)flexNode).toMatrix4d();
                massObject.setParentFrameTransform(parentTransform);
                if (this.debugText) {
                    Library.println((Object)("Set parent transform to " + parentTransform));
                }
            } else if (this.debugText) {
                Library.println((Object)("  parent transform is " + parentTransform));
            }
            Matrix4f gm4f = new Matrix4f();
            this.groundJointFrame.getMatrix(gm4f);
            Matrix4d groundJoint = new Matrix4d(gm4f);
            if (this.debugText) {
                Library.println((Object)("Ground Joint Frame -\n" + groundJoint.toString()));
            }
            groundJoint.mul(parentTransform);
            if (this.debugText) {
                Library.println((Object)("Anchor Frame -\n" + groundJoint.toString()));
            }
            Transform groundAnchorFrame = new Transform();
            groundAnchorFrame.set(new Matrix4f(groundJoint));
            this.joinToBodyFrame(flexNode, groundAnchorFrame, body, this.groundBody);
        } else {
            Object parentObj = parentMassObject.getObject();
            if (!(parentObj instanceof FlexNode)) {
                if (!(parentObj instanceof Node)) {
                    Library.println((Object)"WARNING: Can't find a Node for the parent");
                    Matrix4d parentTransform = Library.transformation((Node)flexNode).toMatrix4d();
                    massObject.setParentFrameTransform(parentTransform);
                } else {
                    Matrix4d parentTransform;
                    Node parentNode = (Node)parentObj;
                    RigidBody parentBody = (RigidBody)parentMassObject.getBody();
                    if (this.debugText) {
                        Library.println((Object)("Store transform from " + parentMassObject.getName() + " to " + massObject.getName()));
                    }
                    if ((parentTransform = massObject.getParentFrameTransform()) == null) {
                        parentTransform = this.calcParentTransform((Node)flexNode, parentNode);
                        massObject.setParentFrameTransform(parentTransform);
                        if (this.debugText) {
                            Library.println((Object)("Set parent transform to " + parentTransform));
                        }
                    } else if (this.debugText) {
                        Library.println((Object)("  parent transform is " + parentTransform));
                    }
                    Matrix4d parentGlobal = Library.transformation((Node)parentNode).toMatrix4d();
                    Point3d offsetP = parentMassObject.getOffsetCoG();
                    Matrix4d parentCoG = this.utils.offsetMatrix(parentGlobal, offsetP);
                    if (this.debugText) {
                        Library.println((Object)("parent Centre of Mass " + parentCoG.toString()));
                    }
                    Matrix4d tm4 = Library.transformation((Node)flexNode).toMatrix4d();
                    if (this.debugText) {
                        Library.println((Object)("Object Transformation " + tm4.toString()));
                    }
                    Matrix4d jointFrame = this.utils.getDifference(tm4, parentCoG);
                    if (this.debugText) {
                        Library.println((Object)(" jointFrame " + jointFrame.toString()));
                    }
                    if (this.debugText) {
                        Library.println((Object)("Anchor Frame -\n" + jointFrame.toString()));
                    }
                    Transform anchorFrame = new Transform();
                    anchorFrame.set(new Matrix4f(jointFrame));
                    if (this.debugText) {
                        Library.println((Object)("Join to parent " + parentMassObject.getName()));
                    }
                    this.joinToBodyFrame(flexNode, anchorFrame, body, parentBody);
                }
            } else {
                Matrix4d parentTransform;
                FlexNode parentFlexNode = (FlexNode)((Object)parentObj);
                if (this.debugText) {
                    Library.println((Object)("Store transform from " + parentMassObject.getName() + " to " + massObject.getName()));
                }
                if ((parentTransform = massObject.getParentFrameTransform()) == null) {
                    parentTransform = this.calcParentTransform((Node)flexNode, (Node)parentFlexNode);
                    massObject.setParentFrameTransform(parentTransform);
                    if (this.debugText) {
                        Library.println((Object)("Set parent transform to " + parentTransform));
                    }
                } else if (this.debugText) {
                    Library.println((Object)("  parent transform is " + parentTransform));
                }
                if (this.debugText) {
                    Library.println((Object)("Join to parent " + parentMassObject.getName()));
                }
                RigidBody parentBody = (RigidBody)parentMassObject.getBody();
                this.joinToParent(flexNode, parentFlexNode, body, parentBody);
            }
        }
    }

    Matrix4d calcParentOffsetFrame(FlexNode node, FlexNode parent) {
        Matrix4d pm4 = Library.transformation((Node)parent).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Parent Transformation -\n" + pm4.toString()));
        }
        Vector3d offset = parent.getLengthVector();
        Matrix4d jointFrame = this.utils.offsetMatrix(pm4, offset);
        if (this.debugText) {
            Library.println((Object)("Parent End -\n" + jointFrame.toString()));
        }
        Matrix4d tm4 = Library.transformation((Node)node).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Object Transformation -\n" + tm4.toString()));
        }
        Matrix4d dm = this.utils.getDifference(tm4, jointFrame);
        if (this.debugText) {
            Library.println((Object)(" calcParentOffsetFrame -\n" + dm.toString()));
        }
        return dm;
    }

    protected void joinToBodyFrame(FlexNode flexNode, Transform jointFrame, RigidBody body, RigidBody parentBody) {
        Transform bottomJointFrame = flexNode.getBottomJointFrame();
        Matrix4f tm4f = new Matrix4f();
        bottomJointFrame.getMatrix(tm4f);
        if (this.debugText) {
            Library.println((Object)("Bottom Joint Frame -\n" + tm4f.toString()));
        }
        Generic6DofConstraint joint = new Generic6DofConstraint(parentBody, body, jointFrame, bottomJointFrame, false);
        flexNode.setJoint(joint);
        this.dynamicWorld.addConstraint((TypedConstraint)joint, true);
        this.initMotors(joint, flexNode);
    }

    protected void joinToParent(FlexNode flexNode, FlexNode parentFlexNode, RigidBody body, RigidBody parentBody) {
        if (this.debugText) {
            Library.println((Object)("Join to parent " + parentFlexNode.getName()));
        }
        Transform topJointFrame = parentFlexNode.getTopJointFrame();
        Matrix4d parentOffset = this.calcParentOffsetFrame(flexNode, parentFlexNode);
        Transform parentTransform = new Transform(new Matrix4f(parentOffset));
        topJointFrame.mul(parentTransform);
        Transform bottomJointFrame = flexNode.getBottomJointFrame();
        if (this.debugText) {
            Matrix4f jmf = new Matrix4f();
            topJointFrame.getMatrix(jmf);
            Library.println((Object)("PhysicsModel.joinToParent(): Top Joint Frame  -\n" + jmf));
            bottomJointFrame.getMatrix(jmf);
            Library.println((Object)("PhysicsModel.joinToParent(): Bottom Joint Frame  -\n" + jmf));
        }
        Generic6DofConstraint joint = new Generic6DofConstraint(parentBody, body, topJointFrame, bottomJointFrame, false);
        flexNode.setJoint(joint);
        this.dynamicWorld.addConstraint((TypedConstraint)joint, true);
        this.initMotors(joint, flexNode);
    }

    private void initMotors(Generic6DofConstraint joint, FlexNode flexNode) {
        if (this.debugText) {
            Library.println((Object)"initMotors() ");
        }
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor motor = joint.getRotationalLimitMotor(i);
            motor.loLimit = -1.0E-5f;
            motor.hiLimit = 1.0E-5f;
            motor.ERP = 0.7f;
            motor.damping = flexNode.getRotDamping();
            motor.bounce = flexNode.getRotBounce();
            motor.limitSoftness = flexNode.getStiffness(i);
            if (this.debugText) {
                Library.println((Object)(" stiffness(" + i + ")=" + flexNode.getStiffness(i)));
            }
            motor.enableMotor = true;
        }
        if (this.debugText) {
            Library.println((Object)(" Rotational Damping=" + flexNode.getRotDamping()));
        }
        if (this.debugText) {
            Library.println((Object)(" Rotational bounce =" + flexNode.getRotBounce()));
        }
        if (this.debugText) {
            Library.println((Object)(" Linear Damping    =" + flexNode.getLinDamping()));
        }
        if (this.debugText) {
            Library.println((Object)(" Linear Bounce     =" + flexNode.getLinBounce()));
        }
        TranslationalLimitMotor tMotor = joint.getTranslationalLimitMotor();
        tMotor.limitSoftness = flexNode.getStiffness(3);
        tMotor.damping = flexNode.getLinDamping();
        tMotor.restitution = flexNode.getLinBounce();
        if (this.debugText) {
            Library.println((Object)(" stiffness(3)=" + flexNode.getStiffness(3)));
        }
    }

    private RigidBody createAndAddBody(MassObject m, CollisionShape shape) {
        RigidBody body = this.createRigidBody(shape, m.getMass());
        m.setShape(shape);
        m.setBody(body);
        this.initPosition(m);
        body.setRestitution(0.7f);
        body.setDamping(0.3f, 0.9f);
        this.dynamicWorld.addRigidBody(body);
        m.setInitialised(true);
        return body;
    }

    private RigidBody createRigidBody(CollisionShape shape, float mass) {
        Vector3f localInertia = new Vector3f(0.0f, 0.0f, 0.0f);
        if (mass != 0.0f) {
            shape.calculateLocalInertia(mass, localInertia);
        }
        Transform startTransform = new Transform();
        startTransform.setIdentity();
        DefaultMotionState ms = new DefaultMotionState(startTransform);
        RigidBodyConstructionInfo rbInfo = new RigidBodyConstructionInfo(mass, (MotionState)ms, shape, localInertia);
        RigidBody body = new RigidBody(rbInfo);
        return body;
    }

    private void initPosition(MassObject m) {
        CollisionObject co = m.getBody();
        Object nodeObject = m.getObject();
        if (nodeObject == null) {
            Library.println((Object)"WARNING: MassObject reference object is NULL");
        } else if (nodeObject instanceof Node) {
            Node n = (Node)nodeObject;
            String typeName = this.getNodeName(n);
            Matrix4d imd = Library.transformation((Node)n).toMatrix4d();
            if (this.debugText) {
                Library.println((Object)("Placing " + typeName + " at transform " + imd));
            }
            m.setCurrentGlobalTransform(imd);
            Matrix4d initialTransform = m.getInitialTransform();
            if (initialTransform == null) {
                initialTransform = new Matrix4d(imd);
                m.setInitialTransform(initialTransform);
            }
            Point3d offset = m.getOffsetCoG();
            if (this.debugText) {
                Library.println((Object)("Centre of mass offset " + offset));
            }
            Matrix4d tmd = this.utils.offsetMatrix(imd, offset);
            if (this.debugText) {
                Library.println((Object)("Physics world transform =" + tmd));
            }
            Transform worldTransform = new Transform();
            worldTransform.set(new Matrix4f(tmd));
            co.setWorldTransform(worldTransform);
        }
    }

    Matrix4d calcParentTransform(Node node, Node parent) {
        Matrix4d pm4 = Library.transformation((Node)parent).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Parent Transformation -\n" + pm4.toString()));
        }
        Matrix4d tm4 = Library.transformation((Node)node).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Object Transformation -\n" + tm4.toString()));
        }
        Matrix4d dm = this.utils.getDifference(tm4, pm4);
        if (this.debugText) {
            Library.println((Object)(" calcParentTransform -\n" + dm.toString()));
        }
        return dm;
    }

    Matrix4d calcUpdatedParentTransform(Node node, MassObject parent) {
        Matrix4d pm4 = parent.getCurrentGlobalTransform();
        if (this.debugText) {
            Library.println((Object)("Parent Transformation -\n" + pm4.toString()));
        }
        Matrix4d tm4 = Library.transformation((Node)node).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Object Transformation -\n" + tm4.toString()));
        }
        Matrix4d dm = this.utils.getDifference(tm4, pm4);
        if (this.debugText) {
            Library.println((Object)(" calcParentTransform -\n" + dm.toString()));
        }
        return dm;
    }

    public String getNodeName(Node n) {
        Object result = "Null";
        if (n != null) {
            result = n.getClass().getSimpleName();
            if (n instanceof Sphere) {
                result = "Sphere";
            } else if (n instanceof FlexNode) {
                result = "FlexNode";
            } else if (n instanceof Cylinder) {
                result = "Cylinder";
            }
            if (n.getName() != null) {
                result = (String)result + " " + n.getName();
            }
        }
        return result;
    }

    public void step() {
        this.step(0.1f);
    }

    public void step(float stepTime) {
        this.visitor.setDebug(this.debugText);
        GraphManager graph = Library.graph();
        graph.accept(null, (Visitor)this.visitor, null);
        this.dynamicWorld.stepSimulation(stepTime);
    }

    public boolean isActive() {
        boolean result = false;
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject mo = this.massObjects.get(i);
            CollisionObject body = mo.getBody();
            if (body != null && !mo.getBody().isActive()) continue;
            result = true;
            break;
        }
        return result;
    }

    public int activeCount() {
        int result = 0;
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject mo = this.massObjects.get(i);
            CollisionObject body = mo.getBody();
            if (body != null && !mo.getBody().isActive()) continue;
            ++result;
        }
        return result;
    }

    public void clear() {
        if (this.debugText) {
            Library.println((Object)"\nPhysicsModel: clearing all objects");
        }
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject mo = this.massObjects.get(i);
            mo.setInitialised(false);
        }
        this.dynamicWorld.destroy();
        this.init();
    }

    public FlexNode getPreviousFlexNode(Node node) {
        FlexNode previous = null;
        for (Node pred = node.getPredecessor(); pred != null; pred = pred.getPredecessor()) {
            if (!(pred instanceof FlexNode)) continue;
            previous = (FlexNode)pred;
            break;
        }
        return previous;
    }

    public FlexNode getParentFlexNode(Node node) {
        FlexNode parentFlexNode = this.getPreviousFlexNode(node);
        if (parentFlexNode == null) {
            block0: for (Node parent = node.getAxisParent(); parent != null; parent = parent.getAxisParent()) {
                if (parent instanceof FlexNode) {
                    parentFlexNode = (FlexNode)parent;
                    break;
                }
                for (Node pred = parent.getPredecessor(); pred != null; pred = pred.getPredecessor()) {
                    if (!(pred instanceof FlexNode)) continue;
                    parentFlexNode = (FlexNode)pred;
                    break block0;
                }
            }
        }
        return parentFlexNode;
    }

    MassObject getMassObject(Node node) {
        MassObject result = null;
        for (int i = 0; i < this.massObjects.size(); ++i) {
            Node n;
            MassObject m = this.massObjects.get(i);
            Object o = m.getObject();
            if (!(o instanceof Node) || !(n = (Node)o).equals(node)) continue;
            result = m;
            break;
        }
        return result;
    }

    MassObject getMassObject(Object obj) {
        MassObject result = null;
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject m = this.massObjects.get(i);
            Object o = m.getObject();
            if (!o.equals(obj)) continue;
            result = m;
            break;
        }
        return result;
    }

    public MassObject getPreviousMassObject(Node node) {
        MassObject previous = null;
        for (Node pred = node.getPredecessor(); pred != null && (previous = this.getMassObject(pred)) == null; pred = pred.getPredecessor()) {
        }
        return previous;
    }

    public MassObject getParentMassObject(Node node) {
        MassObject parentMassObject = this.getPreviousMassObject(node);
        if (parentMassObject == null) {
            block0: for (Node parent = node.getAxisParent(); parent != null && (parentMassObject = this.getMassObject(parent)) == null; parent = parent.getAxisParent()) {
                for (Node pred = parent.getPredecessor(); pred != null; pred = pred.getPredecessor()) {
                    parentMassObject = this.getMassObject(pred);
                    if (parentMassObject != null) break block0;
                }
            }
        }
        return parentMassObject;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new PhysicsModel();
    }

    public boolean isDebugText() {
        return this.debugText;
    }

    public void setDebugText(boolean value) {
        this.debugText = value;
    }

    public ArrayList<MassObject> getMassObjects() {
        return this.massObjects;
    }

    public void setMassObjects(ArrayList<MassObject> value) {
        massObjects$FIELD.setObject((Object)this, value);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)debugText$FIELD);
        massObjects$FIELD = new _Field("massObjects", 0x200002, (Type)ClassAdapter.wrap(ArrayList.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)massObjects$FIELD);
        $TYPE.declareFieldAttribute(massObjects$FIELD, (Attribute)Attributes.MASSOBJECTS);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String name, int modifiers, Type type, Type componentType, int id) {
            super($TYPE, name, modifiers, type, componentType);
            this.id = id;
        }

        public void setBoolean(Object o, boolean value) {
            switch (this.id) {
                case 0: {
                    ((PhysicsModel)((Object)o)).debugText = value;
                    return;
                }
            }
            super.setBoolean(o, value);
        }

        public boolean getBoolean(Object o) {
            switch (this.id) {
                case 0: {
                    return ((PhysicsModel)((Object)o)).isDebugText();
                }
            }
            return super.getBoolean(o);
        }

        protected void setObjectImpl(Object o, Object value) {
            switch (this.id) {
                case 1: {
                    ((PhysicsModel)((Object)o)).massObjects = (ArrayList)value;
                    return;
                }
            }
            super.setObjectImpl(o, value);
        }

        public Object getObject(Object o) {
            switch (this.id) {
                case 1: {
                    return ((PhysicsModel)((Object)o)).getMassObjects();
                }
            }
            return super.getObject(o);
        }
    }
}

