/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.grophysics;

import com.bulletphysics.dynamics.constraintsolver.Generic6DofConstraint;
import com.bulletphysics.linearmath.Transform;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class FlexNode
extends Cylinder {
    private static final long serialVersionUID = -7688781891937691880L;
    static float DEFAULT_MASS = 0.001f;
    static float DEFAULT_STIFFNESS = 0.5f;
    public float mass;
    public float stiffnessT;
    public float stiffnessX;
    public float stiffnessY;
    public float stiffnessZ;
    public float rotDamping;
    public float linDamping;
    public float linBounce;
    public float rotBounce;
    Generic6DofConstraint joint;
    Matrix4d jointFrameOffset;
    public static final Node.NType $TYPE = new Node.NType((Node)new FlexNode());
    public static final Node.NType.Field mass$FIELD = new _Field("mass", 0x200001, Type.FLOAT, null, 0);
    public static final Node.NType.Field stiffnessT$FIELD;
    public static final Node.NType.Field stiffnessX$FIELD;
    public static final Node.NType.Field stiffnessY$FIELD;
    public static final Node.NType.Field stiffnessZ$FIELD;
    public static final Node.NType.Field rotDamping$FIELD;
    public static final Node.NType.Field linDamping$FIELD;
    public static final Node.NType.Field linBounce$FIELD;
    public static final Node.NType.Field rotBounce$FIELD;

    public FlexNode() {
        this(1.0f, 0.05f, DEFAULT_MASS);
    }

    public FlexNode(float length, float radius) {
        this(length, radius, DEFAULT_MASS);
    }

    public FlexNode(float length, float radius, float mass) {
        super(length, radius);
        this.mass = mass;
        this.stiffnessT = DEFAULT_STIFFNESS;
        this.stiffnessX = DEFAULT_STIFFNESS;
        this.stiffnessY = DEFAULT_STIFFNESS;
        this.stiffnessZ = DEFAULT_STIFFNESS;
        this.linDamping = 1.0f;
        this.rotDamping = 1.0f;
        this.linBounce = 0.5f;
        this.rotBounce = 0.0f;
        this.jointFrameOffset = new Matrix4d();
        this.jointFrameOffset.setIdentity();
    }

    public float getStiffness(int i) {
        float s = 0.0f;
        switch (i) {
            case 0: {
                s = this.stiffnessX;
                break;
            }
            case 1: {
                s = this.stiffnessY;
                break;
            }
            case 2: {
                s = this.stiffnessZ;
                break;
            }
            case 3: {
                s = this.stiffnessT;
            }
        }
        return s;
    }

    public Generic6DofConstraint getJoint() {
        return this.joint;
    }

    public void setJoint(Generic6DofConstraint joint) {
        this.joint = joint;
    }

    public void ageJoint(double rate) {
        if (this.joint == null) {
            Library.println((Object)"WARNING: FlexNode.ageJoint(): joint is NULL");
        } else {
            Matrix3d mat = new Matrix3d();
            Matrix3d relative_frame = new Matrix3d();
            relative_frame.setIdentity();
            double angleX = this.joint.getAngle(0);
            double angleY = this.joint.getAngle(1);
            double angleZ = this.joint.getAngle(2);
            mat.rotX(angleX *= rate);
            relative_frame.mul(mat);
            mat.rotY(angleY *= rate);
            relative_frame.mul(mat);
            mat.rotZ(angleZ *= rate);
            relative_frame.mul(mat);
            Matrix4d rotate = new Matrix4d();
            rotate.setIdentity();
            rotate.set(relative_frame);
            this.jointFrameOffset.mul(rotate);
        }
    }

    public Transform initBottomJointFrame() {
        Transform jointFrame = new Transform();
        jointFrame.setIdentity();
        Vector3f anchor = new Vector3f(0.0f, 0.0f, -this.length / 2.0f);
        jointFrame.origin.set((Tuple3f)anchor);
        return jointFrame;
    }

    public Transform getBottomJointFrame() {
        Transform jointFrame = this.initBottomJointFrame();
        Matrix4f jf = new Matrix4f();
        jointFrame.getMatrix(jf);
        Matrix4d jfd = new Matrix4d(jf);
        jfd.mul(this.jointFrameOffset);
        jf.set(jfd);
        jointFrame.set(jf);
        return jointFrame;
    }

    Vector3d getLengthVector() {
        return new Vector3d(0.0, 0.0, (double)this.length);
    }

    public Transform getTopJointFrame() {
        Transform jointFrame = new Transform();
        jointFrame.setIdentity();
        Vector3f anchor = new Vector3f(0.0f, 0.0f, this.length / 2.0f);
        jointFrame.origin.set((Tuple3f)anchor);
        return jointFrame;
    }

    public FlexNode getPreviousFlexNode() {
        FlexNode previous = null;
        for (Node pred = this.getPredecessor(); pred != null; pred = pred.getPredecessor()) {
            if (!(pred instanceof FlexNode)) continue;
            previous = (FlexNode)pred;
            break;
        }
        return previous;
    }

    public FlexNode getParentFlexNode() {
        FlexNode parentFlexNode = this.getPreviousFlexNode();
        if (parentFlexNode == null) {
            block0: for (Node parent = this.getAxisParent(); parent != null; parent = parent.getAxisParent()) {
                if (parent instanceof FlexNode) {
                    parentFlexNode = (FlexNode)parent;
                    break;
                }
                for (Node pred = parent.getPredecessor(); pred != null; pred = pred.getPredecessor()) {
                    if (!(pred instanceof FlexNode)) continue;
                    parentFlexNode = (FlexNode)pred;
                    break block0;
                }
            }
        }
        return parentFlexNode;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new FlexNode();
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float value) {
        this.mass = value;
    }

    public float getStiffnessT() {
        return this.stiffnessT;
    }

    public void setStiffnessT(float value) {
        this.stiffnessT = value;
    }

    public float getStiffnessX() {
        return this.stiffnessX;
    }

    public void setStiffnessX(float value) {
        this.stiffnessX = value;
    }

    public float getStiffnessY() {
        return this.stiffnessY;
    }

    public void setStiffnessY(float value) {
        this.stiffnessY = value;
    }

    public float getStiffnessZ() {
        return this.stiffnessZ;
    }

    public void setStiffnessZ(float value) {
        this.stiffnessZ = value;
    }

    public float getRotDamping() {
        return this.rotDamping;
    }

    public void setRotDamping(float value) {
        this.rotDamping = value;
    }

    public float getLinDamping() {
        return this.linDamping;
    }

    public void setLinDamping(float value) {
        this.linDamping = value;
    }

    public float getLinBounce() {
        return this.linBounce;
    }

    public void setLinBounce(float value) {
        this.linBounce = value;
    }

    public float getRotBounce() {
        return this.rotBounce;
    }

    public void setRotBounce(float value) {
        this.rotBounce = value;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)mass$FIELD);
        stiffnessT$FIELD = new _Field("stiffnessT", 0x200001, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)stiffnessT$FIELD);
        stiffnessX$FIELD = new _Field("stiffnessX", 0x200001, Type.FLOAT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)stiffnessX$FIELD);
        stiffnessY$FIELD = new _Field("stiffnessY", 0x200001, Type.FLOAT, null, 3);
        $TYPE.addManagedField((ManageableType.Field)stiffnessY$FIELD);
        stiffnessZ$FIELD = new _Field("stiffnessZ", 0x200001, Type.FLOAT, null, 4);
        $TYPE.addManagedField((ManageableType.Field)stiffnessZ$FIELD);
        rotDamping$FIELD = new _Field("rotDamping", 0x200001, Type.FLOAT, null, 5);
        $TYPE.addManagedField((ManageableType.Field)rotDamping$FIELD);
        linDamping$FIELD = new _Field("linDamping", 0x200001, Type.FLOAT, null, 6);
        $TYPE.addManagedField((ManageableType.Field)linDamping$FIELD);
        linBounce$FIELD = new _Field("linBounce", 0x200001, Type.FLOAT, null, 7);
        $TYPE.addManagedField((ManageableType.Field)linBounce$FIELD);
        rotBounce$FIELD = new _Field("rotBounce", 0x200001, Type.FLOAT, null, 8);
        $TYPE.addManagedField((ManageableType.Field)rotBounce$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String name, int modifiers, Type type, Type componentType, int id) {
            super($TYPE, name, modifiers, type, componentType);
            this.id = id;
        }

        public void setFloat(Object o, float value) {
            switch (this.id) {
                case 0: {
                    ((FlexNode)((Object)o)).mass = value;
                    return;
                }
                case 1: {
                    ((FlexNode)((Object)o)).stiffnessT = value;
                    return;
                }
                case 2: {
                    ((FlexNode)((Object)o)).stiffnessX = value;
                    return;
                }
                case 3: {
                    ((FlexNode)((Object)o)).stiffnessY = value;
                    return;
                }
                case 4: {
                    ((FlexNode)((Object)o)).stiffnessZ = value;
                    return;
                }
                case 5: {
                    ((FlexNode)((Object)o)).rotDamping = value;
                    return;
                }
                case 6: {
                    ((FlexNode)((Object)o)).linDamping = value;
                    return;
                }
                case 7: {
                    ((FlexNode)((Object)o)).linBounce = value;
                    return;
                }
                case 8: {
                    ((FlexNode)((Object)o)).rotBounce = value;
                    return;
                }
            }
            super.setFloat(o, value);
        }

        public float getFloat(Object o) {
            switch (this.id) {
                case 0: {
                    return ((FlexNode)((Object)o)).getMass();
                }
                case 1: {
                    return ((FlexNode)((Object)o)).getStiffnessT();
                }
                case 2: {
                    return ((FlexNode)((Object)o)).getStiffnessX();
                }
                case 3: {
                    return ((FlexNode)((Object)o)).getStiffnessY();
                }
                case 4: {
                    return ((FlexNode)((Object)o)).getStiffnessZ();
                }
                case 5: {
                    return ((FlexNode)((Object)o)).getRotDamping();
                }
                case 6: {
                    return ((FlexNode)((Object)o)).getLinDamping();
                }
                case 7: {
                    return ((FlexNode)((Object)o)).getLinBounce();
                }
                case 8: {
                    return ((FlexNode)((Object)o)).getRotBounce();
                }
            }
            return super.getFloat(o);
        }
    }
}

