/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.object.sg.impl.utils;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.rgg.model.RGGProducer;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.util.ObjectList;
import java.util.HashMap;

public class ProductionGenerator {
    HashMap<Long, Node> nodeMap;
    RGGProducer rgp;

    private boolean isRegisterd(Node n) {
        return this.nodeMap.keySet().contains(n.getId());
    }

    public ProductionGenerator(RGGProducer rgp) {
        this.rgp = rgp;
        this.nodeMap = new HashMap();
    }

    public void generate(Node root) throws CloneNotSupportedException {
        if (root != null) {
            this.registerNode(root);
            this.load(root);
        }
    }

    private void load(Node node) throws CloneNotSupportedException {
        ObjectList successors = new ObjectList();
        this.rgp.producer$push();
        for (Edge e = node.getFirstEdge(); e != null; e = e.getNext(node)) {
            if (!e.isSource(node)) continue;
            Node kid = e.getTarget();
            if (this.isRegisterd(kid)) {
                this.registerEdge(e.getEdgeBits(), this.nodeMap.get(node.getId()), this.nodeMap.get(kid.getId()));
                continue;
            }
            if (e.getEdgeBits() == 256) {
                successors.add((Object)e.getTarget());
                continue;
            }
            this.registerNode(kid);
            this.registerEdge(e.getEdgeBits(), this.nodeMap.get(node.getId()), this.nodeMap.get(kid.getId()));
            this.load(kid);
        }
        this.rgp.producer$pop(null);
        for (Node n : successors) {
            this.registerNode(n);
            this.registerEdge(256, this.nodeMap.get(node.getId()), this.nodeMap.get(n.getId()));
            this.load(n);
        }
    }

    private void registerEdge(int edgeBits, Node in, Node out) {
        this.rgp.addEdgeImpl((Object)in, (Object)out, edgeBits, (EdgeDirection)EdgeDirection.FORWARD);
    }

    private void registerNode(Node kid) throws CloneNotSupportedException {
        Node copy = kid.clone(true);
        this.nodeMap.put(kid.getId(), copy);
        this.rgp.addNodeImpl((Object)copy, false);
    }
}

