/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.object.sg.impl.io;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.graph.object.sg.impl.io.PlaceholderNode;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.XMLPersistenceReader;
import de.grogra.util.SAXElement;
import de.grogra.xl.util.ObjectList;
import java.util.HashMap;
import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLRootlessGraphReader
extends XMLPersistenceReader
implements ContentHandler {
    private Node[] oldRoots;
    private final GraphManager manager;
    private final ObjectList<Node> dummies = new ObjectList();
    private final ObjectList<Object> stack = new ObjectList(20);
    private final ObjectList<SAXElement> saxElements = new ObjectList();
    private final HashSet<String> notFoundTypes = new HashSet();
    private final HashMap<String, Node> roots = new HashMap();
    private SAXElement parent;
    private SAXElement previous;
    private int fieldDepth = 0;

    public XMLRootlessGraphReader(PersistenceBindings bindings, GraphManager manager, Node[] oldRoots) {
        super(bindings);
        this.manager = manager;
        this.oldRoots = oldRoots;
    }

    public HashMap<String, Node> getRoots() {
        return this.roots;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.resolve();
        while (!this.dummies.isEmpty()) {
            ((Node)this.dummies.pop()).removeAll(null);
        }
    }

    private void readFields() throws SAXException {
        if (this.parent != null) {
            if (this.parent.children != null && !(this.stack.peek(1) instanceof PlaceholderNode)) {
                this.readElements((PersistenceCapable)((Node)this.stack.peek(1)), this.parent);
            }
            XMLRootlessGraphReader.recycle(this.parent, this.saxElements);
            this.parent = null;
        }
    }

    private static void recycle(SAXElement e, ObjectList<SAXElement> s) {
        SAXElement t = e.children;
        e.children = null;
        e.next = null;
        s.add((Object)e);
        e = t;
        while (e != null) {
            t = e.next;
            XMLRootlessGraphReader.recycle(e, s);
            e = t;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.fieldDepth == 0 && "http://grogra.de/xmlpersistence".equals(uri)) {
            if (this.stack.isEmpty()) {
                if (!"graph".equals(localName)) {
                    throw new SAXException("graph");
                }
                this.stack.push(null);
                return;
            }
            if ("node".equals(localName)) {
                Node n;
                this.readFields();
                String v = atts.getValue("", "id");
                if (v != null) {
                    long id = Long.parseLong(v);
                    v = this.replaceType(atts.getValue("", "type"));
                    try {
                        n = (Node)this.getBindings().typeForName(v, true).newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        if (this.notFoundTypes.add(v)) {
                            System.err.println("Type " + v + " not found");
                        }
                        n = new PlaceholderNode();
                        this.dummies.add((Object)n);
                    }
                    catch (Exception e) {
                        throw new SAXException(e);
                    }
                    boolean isRoot = false;
                    for (Node oldRoot : this.oldRoots) {
                        if (id != oldRoot.getId()) continue;
                        this.registerObject(id, (PersistenceCapable)oldRoot);
                        n = oldRoot;
                        this.roots.put(v, n);
                        isRoot = true;
                    }
                    if (!isRoot) {
                        this.registerObject(id, (PersistenceCapable)n);
                        if (this.manager != null) {
                            this.manager.makePersistentImpl((PersistenceCapable)n, id, null);
                        }
                        if ((v = atts.getValue("", "root")) != null) {
                            this.roots.put(v, n);
                        }
                    }
                    this.parent = this.saxElements.isEmpty() ? new SAXElement() : (SAXElement)this.saxElements.pop();
                    this.previous = null;
                    this.parent.set(uri, localName, qName, atts);
                    this.fieldDepth = 0;
                } else {
                    v = atts.getValue("", "ref");
                    n = (Node)this.getObject(Long.parseLong(v));
                }
                v = atts.getValue("", "edges");
                if (v != null) {
                    Node p = (Node)this.stack.peek(1);
                    if (p == null) {
                        throw new SAXException("error");
                    }
                    p.getOrCreateEdgeTo(n).addEdgeBits(Edge.parseEdgeKeys((String)v, (Node)p, (Node)n), null);
                }
                this.stack.push((Object)n);
                return;
            }
        }
        if (this.parent != null) {
            SAXElement e = this.saxElements.isEmpty() ? new SAXElement() : (SAXElement)this.saxElements.pop();
            e.set(uri, localName, qName, atts);
            if (this.previous != null) {
                this.previous.next = e;
            } else {
                this.parent.children = e;
            }
            this.stack.push((Object)this.parent);
            this.parent = e;
            this.previous = null;
            ++this.fieldDepth;
        } else {
            throw new SAXException(uri + ":" + localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.fieldDepth > 0) {
            this.previous = this.parent;
            this.parent = (SAXElement)this.stack.pop();
            --this.fieldDepth;
        } else {
            this.readFields();
            this.stack.pop();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    protected ManageableType.Field getManagedField(ManageableType t, String name) {
        ManageableType.Field f = super.getManagedField(t, name);
        if (f == null && "extentTail".equals(name)) {
            f = Node.extentTail$FIELD;
        }
        return f;
    }
}

