/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.object.sg.impl.io;

import de.grogra.graph.impl.Node;
import de.grogra.graph.object.sg.impl.SecGraphImpl;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.GraphXMLSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.StreamAdapter;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.ProjectFileObjectItem;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.vfs.FileSystem;
import de.grogra.xl.util.ObjectList;
import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;

public class SecGraphImporter {
    public static Object importFromFile(Context ctx) {
        Workbench wb = ctx.getWorkbench();
        FileChooserResult fr = wb.getToolkit().chooseFile(null, (FileFilter[])IO.getReadableFileTypes((IOFlavor[])new IOFlavor[]{IOFlavor.NODE}), 1, false, null, ctx, null);
        if (fr == null) {
            return null;
        }
        MimeType mt = fr.getMimeType();
        if (fr.files != null && fr.files.length > 1) {
            ObjectList l = new ObjectList(fr.files.length);
            for (File f : fr.files) {
                FileSource src = new FileSource(f, mt, ctx.getWorkbench().getRegistry(), (ModifiableMap)new StringMap());
                Object o = ctx.getWorkbench().readObject((FilterSource)src, IOFlavor.NODE);
                l.add(SecGraphImporter.toGraphItem(o, ctx, src));
            }
            return l;
        }
        FileSource src = fr.createFileSource(ctx.getWorkbench().getRegistry(), (ModifiableMap)new StringMap());
        Object o = ctx.getWorkbench().readObject((FilterSource)src, IOFlavor.NODE);
        if (o == null) {
            return null;
        }
        return SecGraphImporter.toGraphItem(o, ctx, src);
    }

    public static Object toGraphItem(Object node, Context ctx, FileSource src) {
        if (node instanceof Node) {
            Object dest;
            MimeType mime = GraphXMLSource.MIME_TYPE;
            SecGraphImpl sg = new SecGraphImpl((Node)node, (Context)Workbench.current());
            FileSystem pfs = ctx.getWorkbench().getRegistry().getFileSystem();
            String directory = "secgraphs";
            Object dir = pfs.getRoot();
            Object f = src.getFile();
            String url = src.toURL().getFile();
            String fileName = url.substring(url.lastIndexOf(47) + 1);
            fileName = fileName.split("\\.")[0];
            sg.getRootNode();
            GraphXMLSource gxs = new GraphXMLSource(sg.getGraph(), ctx.getWorkbench().getRegistry(), null, sg.getRootNode());
            StreamAdapter sad = new StreamAdapter((FilterSource)gxs, new IOFlavor(GraphXMLSource.MIME_TYPE, 2, null));
            try {
                dir = pfs.create(dir, directory, true);
            }
            catch (IOException e) {
                ctx.getWorkbench().logGUIInfo(IO.I18N.msg("mkdir.failed", (Object)directory), (Throwable)e);
                return null;
            }
            try {
                if (pfs.isIn(fileName)) {
                    dest = pfs.createIfDoesntExist(dir, fileName, false, false);
                } else {
                    dest = pfs.createIfDoesntExist(dir, fileName, false, false);
                    pfs.addLocalFile(f, dir, pfs.getName(dest), false, false);
                }
                sad.write(pfs, dest);
            }
            catch (IOException e) {
                ctx.getWorkbench().logGUIInfo(IO.I18N.msg("addfile.failed", (Object)directory), (Throwable)e);
                return null;
            }
            ProjectFileObjectItem item = new ProjectFileObjectItem(IO.toSystemId((FileSystem)pfs, (Object)dest), mime, (Object)sg, SecGraphImpl.class.getName(), SecGraphImpl.MIME_TYPE);
            return item;
        }
        return null;
    }
}

