/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.object.sg.impl;

import de.grogra.graph.impl.Node;
import de.grogra.graph.object.sg.SecGraph;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;

public class SecGraphInitialProducer {
    SecGraph sg;
    Node start;
    private int nextEdgeByte = 256;
    private ObjectList nStack = new ObjectList();
    private IntList eStack = new IntList();
    private Node last;
    private boolean nextNew = false;

    public SecGraphInitialProducer(Node start) {
        this.start = start;
    }

    public SecGraphInitialProducer producer$begin() {
        return this;
    }

    public SecGraphInitialProducer producer$end() {
        return this;
    }

    public SecGraphInitialProducer operator$space(Node node) {
        this.addNode(node);
        return this;
    }

    public SecGraphInitialProducer producer$push() {
        this.push();
        return this;
    }

    public SecGraphInitialProducer producer$pop(Object oldProducer) {
        this.pop();
        return this;
    }

    public SecGraphInitialProducer operator$slashArrow(Node n) {
        this.addNodeRight(n, 4096);
        return this;
    }

    public SecGraphInitialProducer operator$slashLeftArrow(Node n) {
        this.addNodeLeft(n, 4096);
        return this;
    }

    public SecGraphInitialProducer operator$slashLeftRightArrow(Node n) {
        this.addNodeRightLeft(n, 4096);
        return this;
    }

    public SecGraphInitialProducer operator$plusArrow(Node n) {
        this.addNodeRight(n, 512);
        return this;
    }

    public SecGraphInitialProducer operator$plusLeftArrow(Node n) {
        this.addNodeLeft(n, 512);
        return this;
    }

    public SecGraphInitialProducer operator$plusLeftRightArrow(Node n) {
        this.addNodeRightLeft(n, 512);
        return this;
    }

    public SecGraphInitialProducer operator$arrow(Node n, int edge) {
        this.addNodeRight(n, edge);
        return this;
    }

    public SecGraphInitialProducer operator$leftArrow(Node n, int edge) {
        this.addNodeLeft(n, edge);
        return this;
    }

    public SecGraphInitialProducer operator$xLeftRightArrow(Node n, int edge) {
        this.addNodeRightLeft(n, edge);
        return this;
    }

    public SecGraphInitialProducer operator$gt(Node n) {
        this.addNodeRight(n, 256);
        return this;
    }

    public SecGraphInitialProducer operator$lt(Node n) {
        this.addNodeLeft(n, 256);
        return this;
    }

    public SecGraphInitialProducer operator$leftRightArrow(Node n) {
        this.addNodeRightLeft(n, 256);
        return this;
    }

    public SecGraphInitialProducer producer$separate() {
        this.nextNew = true;
        return this;
    }

    public Node producer$getRoot() {
        return this.start;
    }

    public void addNode(Node n) {
        if (this.nextNew) {
            this.last = n;
            this.nextNew = false;
        } else {
            if (this.last == null) {
                this.last = this.start;
            }
            this.last.addEdgeBitsTo(n, this.nextEdgeByte, null);
            this.last = n;
            this.nextEdgeByte = 256;
        }
    }

    public void addNodeRight(Node n, int edgeBit) {
        if (this.last == null) {
            this.last = this.start;
        }
        this.last.addEdgeBitsTo(n, edgeBit, null);
        this.last = n;
    }

    public void addNodeLeft(Node n, int edgeBit) {
        if (this.last == null) {
            this.last = this.start;
        }
        n.addEdgeBitsTo(this.last, edgeBit, null);
        this.last = n;
    }

    public void addNodeRightLeft(Node n, int edgeBit) {
        if (this.last == null) {
            this.last = this.start;
        }
        this.last.addEdgeBitsTo(n, edgeBit, null);
        n.addEdgeBitsTo(this.last, edgeBit, null);
        this.last = n;
    }

    public void setNextEdgeByte(int edge) {
        this.nextEdgeByte = edge;
    }

    public void push() {
        this.nStack.push((Object)this.last);
        this.eStack.push(this.nextEdgeByte);
        this.nextEdgeByte = 512;
    }

    public void pop() {
        this.last = (Node)this.nStack.pop();
        this.nextEdgeByte = this.eStack.pop();
    }
}

