/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.object.impl;

import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.Graph;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.VisitorImpl;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.graph.object.GraphObject;
import de.grogra.graph.object.impl.GraphInstance;
import de.grogra.graph.object.impl.GraphObjectDescriptor;
import de.grogra.graph.object.impl.GraphObjectSelection;
import de.grogra.imp.GraphDescriptor;
import de.grogra.imp.View;
import de.grogra.imp2d.graphs.TopologyGraph;
import de.grogra.imp2d.graphs.TopologyGraphDescriptor;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.View3D;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceConnection;
import de.grogra.persistence.ServerConnection;
import de.grogra.persistence.ShareableBase;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.io.VirtualFileWriterSource;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.registry.ProjectFileObjectItem;
import de.grogra.reflect.TypeLoader;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.Executor;

public class GraphObjectImpl
extends ShareableBase
implements Serializable,
Selectable,
GraphObject {
    public static final MimeType MIME_TYPE = MimeType.valueOf((String)"application/x-graphobject");
    private GraphManager gm;
    protected Registry registry;

    public GraphObjectImpl() {
    }

    public GraphObjectImpl(Node n, Context ctx) {
        this.initGraph(ctx);
        this.setRootNode(n);
    }

    public GraphObjectImpl(Context ctx) {
        this.initGraph(ctx);
    }

    private void initGraph(Context ctx) {
        this.registry = ctx.getWorkbench().getRegistry();
        ServerConnection conn = new ServerConnection(new PersistenceBindings((TypeLoader)this.registry, (SharedObjectProvider.Binding)this.registry));
        this.gm = new GraphManager((PersistenceConnection)conn, "Project", true, false);
        this.getGraph().initMainState((Executor)ctx.getWorkbench().getJobManager());
    }

    @Override
    public Node getRootNode() {
        return this.getGraph().getRoot();
    }

    @Override
    public void setRootNode(Node root) {
        this.getGraph().setRoot("MainGraph", root);
    }

    @Override
    public Node cloneGraph() throws CloneNotSupportedException {
        return this.getRootNode().cloneGraph((EdgePattern)EdgePatternImpl.FORWARD, true);
    }

    @Override
    public void write() {
        ProjectFileObjectItem sop = (ProjectFileObjectItem)this.getProvider();
        Registry r = sop.getRegistry();
        Object file = r.getProjectFile(sop.getSystemId());
        ObjectSourceImpl src = new ObjectSourceImpl((Object)this.getRootNode(), sop.getSystemId(), IOFlavor.NODE, r.getRootRegistry(), null);
        FilterSource fs = IO.createPipeline((FilterSource)src, (IOFlavor)new IOFlavor(sop.getFileMimeType(), 1024, null));
        try {
            ((VirtualFileWriterSource)fs).write(r.getFileSystem(), (Object)src);
        }
        catch (IOException e) {
            Workbench.current().logGUIInfo(IO.I18N.msg("openfile.failed", (Object)sop.getSystemId()));
        }
    }

    @Override
    public void reload() {
    }

    @Override
    public void view2d(Context ctx) {
        if (this.getGraph().getMainState().getContext() != Workbench.current().getJobManager().getThreadContext()) {
            this.getGraph().initMainState((Executor)Workbench.current().getJobManager());
        }
        TopologyGraphDescriptor tgd = new TopologyGraphDescriptor(){

            public Graph getGraph(View view) {
                return new TopologyGraph((Graph)GraphObjectImpl.this.getGraph(), "MainGraph");
            }
        };
        StringMap params = new StringMap();
        params.put("graph", (Object)tgd);
        View v = (View)PanelFactory.getAndShowPanel((Context)ctx, (String)"/ui/panels/2d/view", (Map)params);
        v.setGraph((GraphDescriptor)tgd);
    }

    @Override
    public void view3d(Context ctx) {
        if (this.getGraph().getMainState().getContext() != Workbench.current().getJobManager().getThreadContext()) {
            this.getGraph().initMainState((Executor)Workbench.current().getJobManager());
        }
        GraphObjectDescriptor sgd = new GraphObjectDescriptor(this);
        View v3 = (View)PanelFactory.getAndShowPanel((Context)ctx, (String)"/ui/panels/3d/view", null);
        v3.setGraph((GraphDescriptor)sgd);
        ((View3D)v3).setCamera(Camera.createPerspective());
    }

    @Override
    public String getName() {
        SharedObjectProvider sop = this.getProvider();
        if (sop instanceof ProjectFileObjectItem) {
            return ((ProjectFileObjectItem)sop).getName();
        }
        return "unNamed";
    }

    @Override
    public Object describes() {
        final StringMap nodeType = new StringMap();
        VisitorImpl v = new VisitorImpl(){

            public Object visitEnter(Path path, boolean node) {
                if (node) {
                    Node n = (Node)path.getObject(-1);
                    nodeType.put(n.getNType().getName(), (Object)n.getNType());
                }
                return null;
            }

            public Object visitInstanceEnter() {
                return STOP;
            }
        };
        v.init(this.getRootNode().getCurrentGraphState(), (EdgePattern)EdgePatternImpl.TREE);
        this.getGraph().accept((Object)this.getRootNode(), (Visitor)v, null);
        return nodeType;
    }

    @Override
    public GraphManager getGraph() {
        return this.gm;
    }

    @Override
    public Node getNode(String key) {
        return this.getGraph().getNodeForName(this.getGraph().getRoot(), key);
    }

    public ManageableType getManageableType() {
        return null;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Node produceNode() {
        return new GraphInstance(this);
    }

    @Override
    public GraphObject resolve() {
        return this;
    }

    public Selection toSelection(Context ctx) {
        return new GraphObjectSelection(this, ctx);
    }
}

