/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.CLIApplication;
import de.grogra.cli.ui.CLIPanelSupport;
import de.grogra.cli.ui.CLIRootPane;
import de.grogra.cli.ui.CLITextComponent;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.Layout;
import de.grogra.util.Disposable;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.xl.lang.ObjectToBoolean;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class CLIWindowSupport
extends CLIPanelSupport
implements Window {
    CLIRootPane frame;
    UIToolkit manager;
    Workbench workbench;
    boolean visible;
    private volatile Panel[] windowsToDispose;
    private volatile List<Panel> panels = new ArrayList<Panel>();
    private final Command close;

    public CLIWindowSupport(UIToolkit manager, Command close, Map params) {
        super(new CLITextComponent());
        this.close = close;
        this.frame = (CLITextComponent)this.getComponent();
        this.manager = manager;
        this.initialize(this, params);
    }

    public void addPanel(Panel p) {
        this.panels.add(p);
    }

    public void removePanel(int panelId) {
        Panel p = this.panels.get(panelId);
        p.dispose();
        this.panels.remove(panelId);
    }

    public void removePanel(String panelId) {
        this.removePanel(this.getPanelNb(panelId));
    }

    public int getPanelNb(String panelId) {
        return this.panels.indexOf(this.getPanel(panelId));
    }

    public void consoleWrite(ComponentWrapper c) {
        ((CLITextComponent)this.frame).read(c.getComponent().toString());
    }

    public void consoleWrite(String s) {
        ((CLITextComponent)this.frame).read(s);
    }

    @Override
    public ComponentWrapper getContent() {
        return this.frame;
    }

    @Override
    public void setCursor(int cursor) {
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public Workbench getWorkbench() {
        return this.workbench;
    }

    public void initializeWorkbench(Workbench workbench) {
        assert (this.workbench == null);
        this.workbench = workbench;
        this.panelId = workbench.getName() + ".mainConsole";
    }

    public boolean isVisible() {
        return this.getWorkbench().isSelected() || this.getWorkbench().getMainWorkbench() == this.getWorkbench();
    }

    public Panel[] getPanels(ObjectToBoolean<Panel> filter) {
        return this.panels.toArray(new Panel[0]);
    }

    public Panel getPanel(String panelId) {
        for (Panel p : this.panels) {
            if (p.resolve().getPanelId() == null || !p.resolve().getPanelId().equals(panelId)) continue;
            return ((CLIPanelSupport)p).unresolve();
        }
        return null;
    }

    @Override
    void setVisibleSync(boolean visible, Panel keepInFront, boolean moveToFront) {
        if (visible) {
            if (this.frame != null) {
                this.frame.show();
            }
        } else if (this.frame != null) {
            // empty if block
        }
    }

    @Override
    protected void disposeImpl() {
        this.windowsToDispose = this.panels.toArray(new Panel[0]);
        for (int i = this.windowsToDispose.length - 1; i >= 0; --i) {
            this.windowsToDispose[i].dispose();
        }
        this.windowsToDispose = null;
        this.panels = null;
        this.workbench = null;
    }

    public void setLayout(Layout layout, Map params) {
    }

    public Layout getLayout() {
        return null;
    }

    public void setMenuVisibility(boolean value) {
    }

    public FileChooserResult chooseFile(String title, File directory, FileFilter[] filters, int type, boolean mustExist, FileFilter selectedFilter) {
        CLIApplication app = (CLIApplication)this.getWorkbench().getApplication();
        if (app.canReadValue()) {
            File file;
            FileChooserResult r = new FileChooserResult();
            String prompt = "[" + (directory != null ? directory.toString() : "/") + "]>";
            Object msg = title;
            for (FileFilter f : filters) {
                msg = (String)msg + "; " + f.getDescription();
            }
            this.consoleWrite(((String)msg).toString());
            app.setPROMPT(prompt);
            String t = (String)app.getTerminalInput();
            r.file = t.isBlank() ? null : (Path.of(t, new String[0]).isAbsolute() ? (file = new File(t)) : Paths.get(directory.toString(), t).toFile());
            r.filter = filters[0];
            return r.validate(mustExist, type);
        }
        this.consoleWrite(CLIApplication.I18N.msg("error.fs.notlocked"));
        return null;
    }

    public int showChoiceDialog(String title, I18NBundle bundle, String keyBase, String[] options) {
        CLIApplication app = (CLIApplication)this.getWorkbench().getApplication();
        if (app.canReadValue()) {
            int i = 0;
            String msg = bundle.msg(keyBase) + System.lineSeparator();
            for (String s : options) {
                msg = msg + String.valueOf(i) + " :" + s;
                ++i;
            }
            String prompt = "[pick an index]>";
            this.consoleWrite(msg.toString());
            app.setPROMPT(prompt);
            String t = (String)app.getTerminalInput();
            if (Integer.valueOf(t) != null && Integer.valueOf(t) >= 0 && Integer.valueOf(t) <= options.length) {
                return Integer.valueOf(t);
            }
            return 2;
        }
        this.consoleWrite(CLIApplication.I18N.msg("error.fs.notlocked"));
        return 2;
    }

    public int showDialog(String title, Object message, int type) {
        CLIApplication app = (CLIApplication)this.getWorkbench().getApplication();
        if (app.canReadValue()) {
            this.consoleWrite(message.toString() + System.lineSeparator());
            app.setPROMPT("> ");
            String t = (String)app.getTerminalInput();
            if (t == null) {
                return 2;
            }
            if (t.toLowerCase().equals("yes") || t.toLowerCase().equals("y")) {
                return 0;
            }
            if (t.toLowerCase().equals("no") || t.toLowerCase().equals("n")) {
                return 1;
            }
            try {
                if (Integer.valueOf(t) == 0) {
                    return 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }

    public String showInputDialog(String title, Object message, String initial) {
        CLIApplication app = (CLIApplication)this.getWorkbench().getApplication();
        if (app.canReadValue()) {
            this.consoleWrite(message.toString() + System.lineSeparator());
            app.setPROMPT("> ");
            String t = (String)app.getTerminalInput();
            return t;
        }
        return null;
    }

    public Disposable showWaitMessage(String toComplete) {
        CLIApplication app = (CLIApplication)this.getWorkbench().getApplication();
        String msg = toComplete != null ? UI.I18N.msg("waitingmessage.text", (Object)toComplete) : UI.I18N.msg("waitingmessage.text0");
        this.consoleWrite(msg.toString() + System.lineSeparator());
        return null;
    }
}

