/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.ExecutableComponent;
import de.grogra.cli.Utils;
import de.grogra.cli.ui.CLIComponent;
import de.grogra.cli.ui.CLIWindowSupport;
import de.grogra.graph.impl.Node;
import de.grogra.imp.ObjectInspector;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Showable;
import de.grogra.pf.ui.Synchronizer;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.awt.AWTSynchronizer;
import de.grogra.pf.ui.tree.SyncMappedTree;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.ComponentWrapperImpl;
import javax.swing.tree.TreeModel;

public class CLIUITree
extends CLIComponent {
    int iterable = 0;

    @Override
    public void dispose() {
        ((SyncMappedTree)this.getContent()).dispose();
    }

    @Override
    public CLIComponent getComponent() {
        return this;
    }

    public CLIUITree(UITree tree) {
        this.setName("uitree");
        this.setShowable(true);
        this.setContent(new SyncMappedTree((TreeModel)tree, tree.getRoot(), (Synchronizer)new AWTSynchronizer(null)));
    }

    @Override
    public void show() {
        TreeModel model = this.getSourceTree();
        this.iterable = 0;
        ComponentWrapperImpl c = new ComponentWrapperImpl((Object)this.getTreeText(model, model.getRoot(), ""), null);
        try {
            ((CLIWindowSupport)this.getSupport().getWindow()).consoleWrite((ComponentWrapper)c);
        }
        catch (NullPointerException e) {
            System.out.println("Cannot display the panel because it doesn't have a support");
        }
    }

    private String getTreeText(TreeModel model, Object object, String indent) {
        String myRow = indent + "[" + this.iterable + "] : " + this.getNodeText(model, object) + System.lineSeparator();
        ++this.iterable;
        for (int i = 0; i < model.getChildCount(object); ++i) {
            myRow = myRow + this.getTreeText(model, model.getChild(object, i), indent + "  ");
        }
        return myRow;
    }

    public String getTreeText() {
        TreeModel model = this.getSourceTree();
        return this.getTreeText(model, model.getRoot(), "");
    }

    public TreeModel getSourceTree() {
        return ((SyncMappedTree)this.getContent()).getSourceTree();
    }

    private String getNodeText(TreeModel model, Object item) {
        return String.valueOf(((UITree)model).getDescription(item, "Name"));
    }

    private Object getNode(String id) {
        TreeModel model = this.getSourceTree();
        Object node = this.getNodeFromName(model, model.getRoot(), id);
        if (node != null) {
            return node;
        }
        try {
            int index = Integer.valueOf(id);
            this.iterable = 0;
            return this.getNodeFromId(model, model.getRoot(), index);
        }
        catch (NumberFormatException e) {
            this.getSupport().getWorkbench().logInfo("Cannot select object: either name not fit or id out of bound");
            return null;
        }
    }

    private Object getNodeFromName(TreeModel model, Object node, String name) {
        Object n = null;
        if (name.equals(this.getNodeText(model, node))) {
            n = node;
            return n;
        }
        for (int i = 0; i < model.getChildCount(node) && (n = this.getNodeFromName(model, model.getChild(node, i), name)) == null; ++i) {
        }
        return n;
    }

    private Object getNodeFromId(TreeModel model, Object node, int index) {
        Object n = null;
        if (this.iterable == index) {
            n = node;
            return n;
        }
        ++this.iterable;
        for (int i = 0; i < model.getChildCount(node) && (n = this.getNodeFromId(model, model.getChild(node, i), index)) == null; ++i) {
        }
        return n;
    }

    private boolean selectNode(Object treeNode) {
        Object n;
        if (treeNode != null && treeNode instanceof ObjectInspector.TreeNode && (n = ((ObjectInspector.TreeNode)treeNode).getObject()) != null && n instanceof Node) {
            Node[] nodes = new Node[]{(Node)n};
            this.getSupport().getWorkbench().select(nodes);
            return true;
        }
        return false;
    }

    @Override
    public void run(String s, Object info) {
        super.run(s, info);
        switch (s) {
            case "show": {
                try {
                    String param = Utils.getStringParameter(info, false);
                    Object node = this.getNode(param);
                    if (node instanceof Showable) {
                        ((Showable)node).show((Context)Workbench.current());
                        break;
                    }
                    if (this.selectNode(node)) {
                        ((Command)Item.resolveItem((RegistryContext)this.getSupport(), (String)"/ui/panels/attributeeditor")).run(null, (Context)this.getSupport());
                        Panel p = this.getSupport().getWindow().getPanel("/ui/panels/attributeeditor");
                        ((ExecutableComponent)p).run("repaint", null);
                        break;
                    }
                    this.getSupport().getWorkbench().logInfo("Node not showable.");
                }
                catch (NullPointerException e) {
                    this.getSupport().getWorkbench().logInfo("No value given.");
                }
                break;
            }
            case "select": {
                try {
                    String p2 = Utils.getStringParameter(info, false);
                    Object n2 = this.getNode(p2);
                    this.selectNode(n2);
                    break;
                }
                catch (NullPointerException e) {
                    this.getSupport().getWorkbench().logInfo("No value given.");
                }
            }
        }
    }
}

