/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.CLIApplication;
import de.grogra.cli.Utils;
import de.grogra.cli.ui.CLIAttributeEditorPanel;
import de.grogra.cli.ui.CLIPanelSupport;
import de.grogra.cli.ui.CLITextComponent;
import de.grogra.pf.ui.TextEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CLITextEditor
extends CLIPanelSupport
implements TextEditor {
    public CLITextEditor() {
        super(new CLITextComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDocument(String systemId, String reference) {
        Object f = this.getWorkbench().getRegistry().getProjectFile(systemId);
        OutputStream outStream = null;
        OutputStream out = null;
        InputStream backIn = null;
        try {
            InputStream ins = this.getWorkbench().getRegistry().getFileSystem().getInputStream(f);
            File tf = File.createTempFile("groimpclitemp", "." + Utils.getExtension(systemId));
            BasicFileAttributes attributes_before = Files.readAttributes(tf.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            outStream = new FileOutputStream(tf);
            outStream.write(ins.readAllBytes());
            outStream.close();
            CLIApplication app = (CLIApplication)this.getWorkbench().getApplication();
            if (app.canReadValue()) {
                app.setFileToEdit(tf, systemId);
                app.startConsoleFileEditor();
                if (tf.exists()) {
                    BasicFileAttributes attributes_after = Files.readAttributes(tf.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (!attributes_before.lastModifiedTime().equals(attributes_after.lastModifiedTime())) {
                        backIn = new FileInputStream(tf);
                        out = this.getWorkbench().getRegistry().getFileSystem().getOutputStream(f, false);
                        out.write(backIn.readAllBytes());
                        out.close();
                        backIn.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outStream.close();
                out.close();
                backIn.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> openAttributeEditor(Map<String, CLIAttributeEditorPanel.EditableAttribute> widgetList) {
        ArrayList<String> outputLines = new ArrayList<String>();
        CLIApplication app = (CLIApplication)this.getWorkbench().getApplication();
        if (app.canReadValue()) {
            BufferedWriter bf = null;
            try {
                File tf = File.createTempFile("groclimptemp-", "-attributeeditor");
                bf = new BufferedWriter(new FileWriter(tf));
                for (Map.Entry<String, CLIAttributeEditorPanel.EditableAttribute> entry : widgetList.entrySet()) {
                    bf.write(entry.getKey() + ":" + entry.getValue());
                    bf.newLine();
                }
                bf.close();
                app.setFileToEdit(tf, "");
                app.startConsoleFileEditor();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(tf)));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        outputLines.add(line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    bf.close();
                }
                catch (Exception exception) {}
            }
        }
        return outputLines;
    }

    public String[] getDocuments() {
        return null;
    }

    public void closeDocument(String systemId) {
    }
}

