/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.CLIApplication;
import de.grogra.cli.ui.CLIRootPane;
import de.grogra.cli.ui.CLIWindowSupport;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class CLITextComponent
extends CLIRootPane {
    private final Object LOCK = new Object();
    private boolean repaint;
    private TextQueue<String> history;
    private TextQueue<String> toDisplay;

    public String write() {
        String el = this.toDisplay.poll();
        if (el != null) {
            this.history.add(el + System.lineSeparator());
            return el;
        }
        return null;
    }

    public Object[] writeAll() {
        ArrayList<String> content = new ArrayList<String>();
        while (!this.toDisplay.isEmpty()) {
            content.add(this.write());
        }
        return content.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(String e) {
        Object object = this.LOCK;
        synchronized (object) {
            if (e != null && !(e = this.removeBreakLine(e)).equals("> ") && !e.equals("")) {
                this.toDisplay.add(e);
                this.getSupport().show(true, null);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakLine() {
        Object object = this.LOCK;
        synchronized (object) {
            this.toDisplay.add(System.lineSeparator());
            this.show();
        }
    }

    private String removeBreakLine(String e) {
        if (e.endsWith(System.lineSeparator())) {
            e = e.substring(0, e.length() - System.lineSeparator().length());
        }
        return e;
    }

    public CLITextComponent() {
        this.setName("text component");
        this.setShowable(true);
        this.setVisible(true);
        this.toDisplay = new TextQueue();
        this.history = new TextQueue();
        this.setContent(this.toDisplay);
    }

    private CLIWindowSupport getWindow() {
        return (CLIWindowSupport)this.getSupport().getWindow();
    }

    @Override
    public void show() {
        if (this.getVisible() && this.getWindow().isVisible()) {
            this.repaint = false;
            while (!this.toDisplay.isEmpty()) {
                this.repaint = true;
                ((CLIApplication)this.getWindow().getWorkbench().getApplication()).print(this.write());
            }
            if (this.repaint) {
                ((CLIApplication)this.getWindow().getWorkbench().getApplication()).flush();
            }
        }
    }

    @Override
    public void run(String cmd, Object info) {
        super.run(cmd, info);
        switch (cmd) {
            case "history": {
                if (!this.getWindow().isVisible()) break;
                this.repaint = false;
                for (String s : this.history) {
                    this.repaint = true;
                    ((CLIApplication)this.getWindow().getWorkbench().getApplication()).print(s.toString());
                }
                if (!this.repaint) break;
                ((CLIApplication)this.getWindow().getWorkbench().getApplication()).flush();
            }
        }
    }

    class TextQueue<T>
    extends AbstractQueue<T> {
        private LinkedList<T> elements = new LinkedList();

        @Override
        public boolean offer(T e) {
            if (e == null) {
                return false;
            }
            this.elements.add(e);
            return true;
        }

        @Override
        public T poll() {
            Iterator iter = this.elements.iterator();
            Object e = iter.next();
            if (e != null) {
                iter.remove();
                return (T)e;
            }
            return null;
        }

        @Override
        public T peek() {
            return this.elements.getFirst();
        }

        @Override
        public Iterator<T> iterator() {
            return this.elements.iterator();
        }

        @Override
        public int size() {
            return this.elements.size();
        }
    }
}

