/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.CLIApplication;
import de.grogra.cli.ui.CLIPanelSupport;
import de.grogra.cli.ui.CLIRootPane;
import de.grogra.util.Map;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class CLIStatusBar
extends CLIRootPane
implements PropertyChangeListener {
    String label;
    int avgTime;
    private long lastTime;
    private float lastProgressBarValue = 2.0f;
    private long startTime;

    @Override
    public void initialize(CLIPanelSupport support, Map p) {
        super.initialize(support, p);
        support.getWorkbench().addStatusChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void dispose() {
        this.getSupport().getWorkbench().removeStatusChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent event) {
        Float f;
        if ("progress".equals(event.getPropertyName()) && (f = (Float)event.getNewValue()) != null && f.floatValue() >= 0.0f) {
            long t = System.currentTimeMillis();
            if (t - this.lastTime < (long)(8 * this.avgTime)) {
                return;
            }
            this.lastTime = t;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if ("status".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    CLIStatusBar.this.label = s == null || s.equals("") ? " " : s;
                } else if ("progress".equals(event.getPropertyName())) {
                    Float f = (Float)event.getNewValue();
                    if (f != null) {
                        if (!(f.floatValue() < 0.0f)) {
                            if (CLIStatusBar.this.lastProgressBarValue > f.floatValue()) {
                                CLIStatusBar.this.startTime = CLIStatusBar.this.lastTime;
                                CLIStatusBar.this.lastProgressBarValue = f.floatValue();
                            } else {
                                long remaining = (long)((float)(CLIStatusBar.this.lastTime - CLIStatusBar.this.startTime) / f.floatValue() - (float)(CLIStatusBar.this.lastTime - CLIStatusBar.this.startTime)) / 1000L;
                                if (remaining < 60L) {
                                    CLIStatusBar.this.updateProgress("Remaining: " + remaining + " sec");
                                } else if (remaining < 3600L) {
                                    CLIStatusBar.this.updateProgress("Remaining: " + remaining / 60L + " min");
                                } else {
                                    CLIStatusBar.this.updateProgress("Remaining: " + remaining / 3600L + " h");
                                }
                                CLIStatusBar.this.lastProgressBarValue = f.floatValue();
                            }
                        }
                    } else {
                        ((CLIApplication)CLIStatusBar.this.getSupport().getWorkbench().getApplication()).updateLoadingPrompt("");
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void updateProgress(String text) {
        if (this.getSupport().getWindow().isVisible()) {
            ((CLIApplication)this.getSupport().getWorkbench().getApplication()).updateLoadingPrompt(text);
        }
    }
}

