/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.CLISynchronizer;
import de.grogra.cli.ExecutableComponent;
import de.grogra.cli.ui.CLIComponent;
import de.grogra.cli.ui.CLIContainer;
import de.grogra.cli.ui.CLIPanel;
import de.grogra.cli.ui.CLIRootPane;
import de.grogra.cli.ui.CLIWindowSupport;
import de.grogra.cli.ui.ICLIPanel;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Synchronizer;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.awt.AWTSynchronizer;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.UIPropertyUpdater;
import de.grogra.util.Disposable;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.concurrent.Executor;

public class CLIPanelSupport
implements Panel,
RegistryContext,
ExecutableComponent,
Synchronizer.Callback {
    protected CLIWindowSupport ws;
    protected ModifiableMap.Producer mapProducer;
    Panel textViewer;
    protected final CLISynchronizer sync = new CLISynchronizer(this);
    protected String panelId;
    private final ICLIPanel panel;
    protected UITree menu = null;
    private ComponentWrapper content = null;
    private boolean disposed = false;
    private Panel decorator;
    private final HashMap propertyMap = new HashMap();
    private final Object LOCK = new Object();
    private static final int SET_MENU = 1;
    private static final int SET_CONTENT = 2;
    private static final int SET_VISIBLE = 3;
    protected static final int MIN_UNUSED_ACTION = 4;
    static final int MIN_PANEL_ACTION = 100;
    private final Command CHECK_CLOSE = new CloseHelper(null);

    public CLIPanelSupport(CLIRootPane p) {
        this.panel = p;
    }

    public CLIPanelSupport(Disposable p) {
        this.panel = new CLIPanel(p);
    }

    static CLIPanelSupport get(CLIComponent c) {
        while (c != null) {
            if (c instanceof ICLIPanel) {
                return ((ICLIPanel)((Object)c)).getSupport();
            }
            c = c.getParent();
        }
        return null;
    }

    public final Panel initialize(Panel ws, Map params) {
        ((CLIWindowSupport)ws).addPanel(this);
        this.ws = (CLIWindowSupport)ws;
        this.panelId = (String)params.get((Object)"panelId", (Object)this.panelId);
        this.panel.initialize(this, params);
        this.configure(params);
        return this;
    }

    public void initDecorator(Panel decorator) {
        this.decorator = decorator;
    }

    public Panel getDecorator() {
        return this.decorator;
    }

    Panel unresolve() {
        CLIPanelSupport p = this;
        while (p.getDecorator() != null) {
            p = p.getDecorator();
        }
        return p;
    }

    public java.util.Map getUIPropertyMap() {
        return this.propertyMap;
    }

    void addParameters(ModifiableMap map) {
        if (this.mapProducer != null) {
            this.mapProducer.addMappings(map);
        }
        CLIPanelSupport p = this;
        while ((p = p.getDecorator()) != null) {
            if (!(p instanceof ModifiableMap.Producer)) continue;
            ((ModifiableMap.Producer)p).addMappings(map);
        }
    }

    protected void configure(Map params) {
    }

    public String getPanelId() {
        return this.panelId;
    }

    public Workbench getWorkbench() {
        return this.ws.getWorkbench();
    }

    public Window getWindow() {
        return this.ws;
    }

    public Panel getPanel() {
        return this;
    }

    public Object getComponent() {
        return this.panel;
    }

    public Registry getRegistry() {
        return this.getWorkbench().getRegistry();
    }

    public Panel resolve() {
        return this;
    }

    public Object run(int action, int iarg, Object arg, Object arg2) {
        switch (action) {
            case 1: {
                break;
            }
            case 2: {
                if (arg instanceof CLIComponent) {
                    ((CLIContainer)((Object)this.panel)).add((CLIComponent)arg);
                } else if (arg instanceof ComponentWrapper) {
                    ((CLIContainer)((Object)this.panel)).add((ComponentWrapper)arg);
                }
                this.panel.initialize(this, null);
                break;
            }
            case 3: {
                this.setVisibleSync(iarg != 0, (Panel)arg, Boolean.TRUE.equals(arg2));
                break;
            }
            default: {
                if (action < 100 || !(this.panel instanceof Synchronizer.Callback)) {
                    throw new AssertionError((Object)("Illegal action code: " + action));
                }
                return ((Synchronizer.Callback)this.panel).run(action, iarg, arg, arg2);
            }
        }
        return null;
    }

    void setVisibleSync(boolean visible, Panel keepInFront, boolean moveToFront) {
        if (visible && moveToFront && this.getContent() != null) {
            ((CLIComponent)this.getContent().getComponent()).show();
        }
    }

    public void setMenu(UITree t) {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (t != null) {
            this.menu = t;
        }
        this.sync.invokeAndWait(1);
    }

    public UITree getMenu() {
        return this.menu;
    }

    public void setContent(ComponentWrapper content) {
        if (this.content != null) {
            this.content.dispose();
        }
        this.content = content;
        this.sync.invokeAndWait(2, 0, content != null ? content.getComponent() : null, null);
    }

    public ComponentWrapper getContent() {
        return this.content;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.setMenu(null);
        this.setContent(null);
        this.disposeImpl();
    }

    public final void show(boolean moveToFront, Panel keepInFront) {
        this.sync.invokeAndWait(3, 1, keepInFront, moveToFront);
    }

    public final void hide() {
        this.sync.invokeAndWait(3, 0, null, null);
    }

    protected void disposeImpl() {
        this.panel.dispose();
    }

    void installUpdater(UIProperty property, boolean forComponent, String method, Map params) {
        UIPropertyUpdater.install((UIProperty)property, (Context)this, (boolean)forComponent, (String)method, (Executor)AWTSynchronizer.QUEUE, (Map)params);
    }

    public void checkClose(Runnable ok) {
        ok.run();
    }

    protected void executeCheckClose(Runnable ok) {
        this.getWorkbench().getJobManager().execute(this.CHECK_CLOSE, (Object)new CloseHelper(ok), (Context)this, 10000);
    }

    public void checkClose(Command ok) {
        ok.run(null, (Context)this);
    }

    public String toString() {
        return super.toString() + "[panelId=" + this.getPanelId() + "]";
    }

    public void setCursor(int cursor) {
    }

    @Override
    public void run(String cmd, Object info) {
        switch (cmd) {
            case "close": {
                ((CLIWindowSupport)this.getWindow()).removePanel(this.getPanelId());
                this.dispose();
                break;
            }
            default: {
                if (this.getContent() instanceof ExecutableComponent) {
                    ((ExecutableComponent)this.getContent()).run(cmd, info);
                    break;
                }
                if (!(this.getContent().getComponent() instanceof ExecutableComponent)) break;
                ((ExecutableComponent)this.getContent().getComponent()).run(cmd, info);
            }
        }
    }

    private final class CloseHelper
    implements Command {
        private final Runnable ok;

        CloseHelper(Runnable ok) {
            this.ok = ok;
        }

        public void run(Object info, Context context) {
            if (this.ok == null) {
                CLIPanelSupport.this.checkClose((Command)info);
            } else {
                try {
                    EventQueue.invokeAndWait(this.ok);
                }
                catch (Exception e) {
                    context.getWorkbench().logInfo("Exception", (Throwable)e);
                }
            }
        }

        public String getCommandName() {
            return null;
        }
    }
}

