/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.util.DetailedException;
import de.grogra.util.I18NBundle;
import de.grogra.util.UserException;
import de.grogra.util.Utils;
import java.awt.Dimension;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CLILoggingFormatter
extends Formatter {
    protected final Dimension iconSize;
    protected final I18NBundle i18n;

    public CLILoggingFormatter(I18NBundle i18n, Dimension iconSize) {
        this.i18n = i18n;
        this.iconSize = iconSize;
    }

    @Override
    public String format(LogRecord log) {
        Throwable t;
        StringBuffer buffer = new StringBuffer(System.lineSeparator());
        int p = buffer.length();
        Utils.formatDateAndName((LogRecord)log, (StringBuffer)buffer);
        Utils.escapeForXML((StringBuffer)buffer, (int)p);
        Level l = log.getLevel();
        int lv = l.intValue();
        buffer.append(System.lineSeparator());
        if (lv < Level.WARNING.intValue()) {
            key = "log.info";
            buffer.append("#Info");
        } else if (lv < Level.SEVERE.intValue()) {
            key = "log.warning";
            buffer.append("#Warning");
        } else {
            key = "log.severe";
            buffer.append("#Severe");
        }
        buffer.append(System.lineSeparator() + "-------------------------------" + System.lineSeparator());
        if (log.getMessage().length() > 0) {
            p = buffer.length();
            buffer.append(log.getMessage());
            if (log.getMessage().startsWith("<html>")) {
                buffer.delete(p, p + 6);
                p = buffer.lastIndexOf("</html>");
                if (p >= 0) {
                    buffer.delete(p, p + 7);
                }
            } else {
                Utils.escapeForXML((StringBuffer)buffer, (int)p);
                for (int i = buffer.length() - 1; i >= p; --i) {
                    if (buffer.charAt(i) != '\n') continue;
                    buffer.replace(i, i + 1, System.lineSeparator());
                }
            }
            buffer.append(System.lineSeparator());
        }
        if ((t = Utils.getMainException((Throwable)log.getThrown())) instanceof DetailedException) {
            buffer.append(((DetailedException)t).getDetailedMessage(false));
        } else if (t instanceof UserException) {
            p = buffer.length();
            buffer.append(t.getLocalizedMessage());
            Utils.escapeForXML((StringBuffer)buffer, (int)p);
        } else if (t != null) {
            Throwable u = t;
            while (u != null) {
                p = buffer.length();
                String s = u.getClass().getName();
                buffer.append(s.substring(s.lastIndexOf(46) + 1));
                s = u.getLocalizedMessage();
                if (s != null) {
                    buffer.append(": ").append(s);
                }
                Utils.escapeForXML((StringBuffer)buffer, (int)p);
                buffer.append(System.lineSeparator());
                if ((u = u.getCause()) == null) continue;
                buffer.append("Caused by ");
            }
            buffer.append(System.lineSeparator() + "Stack Trace:" + System.lineSeparator());
            p = buffer.length();
            String XLerrorsInp = Utils.getStackTrace((Throwable)t);
            XLerrorsInp = XLerrorsInp.replaceAll("<br>", System.lineSeparator());
            XLerrorsInp = XLerrorsInp.replaceAll("<pre>", "");
            XLerrorsInp = XLerrorsInp.replaceAll("</pre>", "");
            Object XLerrors = "";
            for (String line : XLerrorsInp.split("\n")) {
                if (line.startsWith("<a")) {
                    line = line.substring(line.indexOf(62));
                    line = line.substring(line.indexOf(60));
                }
                XLerrors = (String)XLerrors + line + System.lineSeparator();
            }
            buffer.append((String)XLerrors);
        }
        return buffer.append(System.lineSeparator()).toString();
    }

    @Override
    public String getHead(Handler h) {
        return "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<";
    }

    @Override
    public String getTail(Handler h) {
        return ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>";
    }
}

