/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.ui.CLIComponent;
import de.grogra.pf.ui.ComponentWrapper;
import java.util.ArrayList;
import java.util.List;

public class CLIContainer
extends CLIComponent {
    List<CLIComponent> component = new ArrayList<CLIComponent>();
    transient int descendantsCount;

    public CLIContainer() {
    }

    public CLIContainer(ComponentWrapper comp) {
        this.add((CLIComponent)comp);
    }

    @Override
    public void dispose() {
        for (CLIComponent c : this.component) {
            c.dispose();
        }
    }

    @Override
    public CLIComponent getComponent() {
        return this;
    }

    public CLIComponent getComponent(int n) {
        try {
            return this.component.get(n);
        }
        catch (IndexOutOfBoundsException z) {
            throw new ArrayIndexOutOfBoundsException("No such child: " + n);
        }
    }

    private void checkAddToSelf(CLIComponent comp) {
        if (comp instanceof CLIContainer) {
            CLIContainer cn = this;
            while (cn != null) {
                if (cn == comp) {
                    throw new IllegalArgumentException("adding container's parent to itself");
                }
                cn = cn.parent;
            }
        }
    }

    public int countComponents() {
        return this.component.size();
    }

    public CLIComponent add(ComponentWrapper comp) {
        CLIComponent c = new CLIComponent();
        c.setContent(comp);
        this.addImpl(c, null, -1);
        return c;
    }

    public CLIComponent add(CLIComponent comp) {
        this.addImpl(comp, null, -1);
        return comp;
    }

    public void add(CLIComponent comp, Object constraints) {
        this.addImpl(comp, constraints, -1);
    }

    public void add(CLIComponent comp, Object constraints, int index) {
        this.addImpl(comp, constraints, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(CLIComponent comp, Object constraints, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (index > this.component.size() || index < 0 && index != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            this.checkAddToSelf(comp);
            if (comp.parent != null) {
                comp.parent.remove(comp);
                if (index > this.component.size()) {
                    throw new IllegalArgumentException("illegal component position");
                }
            }
            if (index == -1) {
                this.component.add(comp);
            } else {
                this.component.add(index, comp);
            }
            comp.parent = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CLIComponent comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int index;
            if (comp.parent == this && (index = this.component.indexOf(comp)) >= 0) {
                this.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (index < 0 || index >= this.component.size()) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            CLIComponent comp = this.component.get(index);
            this.adjustDescendants(-comp.countHierarchyMembers());
            comp.parent = null;
            this.component.remove(index);
        }
    }

    void adjustDescendants(int num) {
        if (num == 0) {
            return;
        }
        this.descendantsCount += num;
        this.adjustDescendantsOnParent(num);
    }

    void adjustDescendantsOnParent(int num) {
        if (this.parent != null) {
            this.parent.adjustDescendants(num);
        }
    }

    @Override
    public void show() {
        for (CLIComponent c : this.component) {
            c.show();
        }
    }

    @Override
    public void run(String cmd, Object info) {
        super.run(cmd, info);
        for (CLIComponent c : this.component) {
            c.run(cmd, info);
        }
    }
}

