/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.ui.CLIPanelSupport;
import de.grogra.cli.ui.CLITextComponent;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Console;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.NameCompletion;
import de.grogra.util.Map;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import java.util.prefs.Preferences;

public class CLIConsolePanel
extends CLIPanelSupport
implements Console {
    private static final String LAST_COMMAND = "last-command-";
    private static final String LAST_COMMAND_COUNT = "last-command-count";
    private final Vector<String> history = new Vector();
    private final ConsoleWriterCLI out;
    private final ConsoleWriterCLI err;
    private PipedWriter inWriter;
    private final Reader in;
    private final Object lock = new Object();
    CLITextComponent console;
    Context ctx;
    Map params;

    public CLIConsolePanel(Context context, Map params) {
        super(new CLITextComponent());
        this.ctx = context;
        this.params = params;
        this.console = (CLITextComponent)this.getComponent();
        this.setContent(this.console);
        this.out = new ConsoleWriterCLI();
        this.err = new ConsoleWriterCLI();
        try {
            this.inWriter = new PipedWriter();
            this.in = new PipedReader(this.inWriter);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ComponentWrapper getContent() {
        return this.console;
    }

    @Override
    public void setContent(ComponentWrapper content) {
        if (content instanceof CLITextComponent) {
            if (this.console != null) {
                content.dispose();
            }
            this.console = (CLITextComponent)content;
            this.console.initialize(this, this.params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeImpl() {
        super.disposeImpl();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.inWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.inWriter = null;
            this.console = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(String text) {
        Object object = this.lock;
        synchronized (object) {
            if (this.inWriter != null) {
                try {
                    this.inWriter.write(text);
                    this.inWriter.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void clear() {
    }

    public Reader getIn() {
        return this.in;
    }

    public ConsoleWriterCLI getOut() {
        return this.out;
    }

    public ConsoleWriterCLI getErr() {
        return this.err;
    }

    public void setNameCompletion(NameCompletion nc) {
    }

    private void initHistory() {
        Preferences p = Preferences.userRoot().node("/de/grogra/workbench");
        String value = p.get(LAST_COMMAND_COUNT, null);
        if (value == null) {
            return;
        }
        int n = Integer.parseInt(value);
        for (int i = 1; i <= n; ++i) {
            this.history.add(p.get(LAST_COMMAND + i, ""));
        }
    }

    private class ConsoleWriterCLI
    extends Console.ConsoleWriter {
        ConsoleWriterCLI() {
            super((Writer)new WriterCLI(), false);
        }

        public void print(Object text, int color) {
            this.flush();
            this.print(text);
            this.flush();
        }

        public void println(Object text, int color) {
            this.flush();
            this.println(text);
            this.flush();
        }
    }

    private class WriterCLI
    extends Writer {
        private final StringBuffer buffer = new StringBuffer();

        WriterCLI() {
        }

        @Override
        public synchronized void write(char[] buf, int ofs, int len) {
            this.buffer.append(buf, ofs, len);
        }

        @Override
        public synchronized void flush() {
            String s = this.buffer.toString();
            this.buffer.setLength(0);
            CLIConsolePanel.this.console.read(s);
        }

        @Override
        public void close() {
        }
    }
}

