/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.ExecutableComponent;
import de.grogra.cli.ui.CLIContainer;
import de.grogra.cli.ui.CLIPanelSupport;
import de.grogra.pf.ui.ComponentWrapper;

public class CLIComponent
implements ComponentWrapper,
ExecutableComponent {
    private String name;
    private Object content;
    transient CLIContainer parent;
    private boolean showable = false;
    private boolean visible = false;
    static final Object LOCK = new TreeLock();

    public CLIComponent() {
        this.name = "default_name";
    }

    public CLIComponent(String name) {
        this.name = name;
    }

    public void dispose() {
        System.out.println("dispose");
    }

    public Object getComponent() {
        return this;
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    final void checkTreeLock() {
        if (!Thread.holdsLock(this.getTreeLock())) {
            throw new IllegalStateException("This function should be called while holding treeLock");
        }
    }

    int countHierarchyMembers() {
        return 1;
    }

    public CLIContainer getParent() {
        return this.parent;
    }

    public void show() {
        if (this.isShowable()) {
            System.out.println("Component: " + this.name);
            System.out.println(this.content);
        }
    }

    public boolean isShowable() {
        return this.showable;
    }

    public void setShowable(boolean s) {
        this.showable = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public CLIPanelSupport getSupport() {
        return this.getRootParent().getSupport();
    }

    public CLIComponent getRootParent() {
        CLIComponent c = this;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return c;
    }

    @Override
    public void run(String s, Object info) {
        switch (s) {
            case "display": {
                this.setVisible(true);
                break;
            }
            case "hide": {
                this.setVisible(false);
                break;
            }
            case "repaint": {
                this.show();
            }
        }
    }

    static class TreeLock {
        TreeLock() {
        }
    }
}

