/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.ui;

import de.grogra.cli.ui.CLIComponent;
import de.grogra.cli.ui.CLITextEditor;
import de.grogra.cli.ui.CLIWidget;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.Widget;
import de.grogra.pf.ui.edit.Property;
import de.grogra.pf.ui.edit.PropertyEditor;
import de.grogra.pf.ui.edit.PropertyEditorTree;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.WidgetAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;

public class CLIAttributeEditorPanel
extends CLIComponent {
    int iterable = 0;
    Map<String, EditableAttribute> editableAttribute = new HashMap<String, EditableAttribute>();

    @Override
    public void show() {
        TreeModel model = this.getSourceTree();
        this.unwrapUITree((UITree)model);
        if (!this.editableAttribute.isEmpty()) {
            Panel p = this.getSupport().getWindow().getPanel("/ui/panels/texteditor");
            TextEditor t = p != null ? (TextEditor)p : (TextEditor)PanelFactory.createPanel((Context)this.getSupport(), (String)"/ui/panels/texteditor", null);
            List<String> attributesLines = ((CLITextEditor)t).openAttributeEditor(this.editableAttribute);
            if (attributesLines.isEmpty()) {
                return;
            }
            for (String line : attributesLines) {
                try {
                    this.updateAttribute(line);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void dispose() {
        ((UITree)this.getContent()).dispose();
    }

    public TreeModel getSourceTree() {
        return (UITree)this.getContent();
    }

    private void unwrapUITree(UITree tree) {
        this.editableAttribute.clear();
        this.editableAttribute = new HashMap<String, EditableAttribute>();
        this.visitTree((TreeModel)tree, tree.getRoot());
    }

    private void visitTree(TreeModel model, Object object) {
        EditableAttribute eWidget = this.getEditableAttribute(model, object);
        if (eWidget != null) {
            this.editableAttribute.put(this.getNodeText(model, object), eWidget);
        }
        for (int i = 0; i < model.getChildCount(object); ++i) {
            this.visitTree(model, model.getChild(object, i));
        }
    }

    private EditableAttribute getEditableAttribute(TreeModel model, Object item) {
        if (item instanceof PropertyEditorTree.PropertyNode) {
            WidgetAdapter widget = null;
            Widget o = ((PropertyEditorTree.PropertyNode)item).getWidget();
            if (o != null && o instanceof WidgetAdapter && (widget = (WidgetAdapter)o).getComponent() instanceof CLIWidget && ((CLIWidget)((Object)widget.getComponent())).getEditable()) {
                return new EditableAttribute(((PropertyEditorTree.PropertyNode)item).getProperty(), ((PropertyEditorTree.PropertyNode)item).getProperty().getEditor(), ((PropertyEditorTree.PropertyNode)item).getProperty().getValue());
            }
        }
        return null;
    }

    private String getNodeText(TreeModel model, Object item) {
        return String.valueOf(((UITree)model).getDescription(item, "Name"));
    }

    private String getAttributeName(String line) {
        int p = line.indexOf(58);
        if (p >= 0) {
            return line.substring(0, p);
        }
        return null;
    }

    private String getAttributeValue(String line) {
        int p = line.indexOf(61);
        if (p >= 0) {
            return line.substring(p + 1, line.length());
        }
        return null;
    }

    public void updateAttribute(String line) throws InterruptedException {
        String value;
        EditableAttribute a = this.editableAttribute.get(this.getAttributeName(line));
        if (a != null && (value = this.getAttributeValue(line)) != null) {
            try {
                Object newValue = a.property.getType().valueOf(value);
                if (!a.oldValue.equals(newValue)) {
                    a.property.setValue(newValue);
                }
            }
            catch (ClassCastException e) {
                this.getSupport().getWorkbench().logInfo("Cannot cast value for attribute :" + this.getAttributeName(line));
            }
        }
    }

    public class EditableAttribute {
        Property property;
        PropertyEditor editor;
        Object oldValue;

        EditableAttribute(Property property, PropertyEditor editor, Object value) {
            this.oldValue = value;
            this.property = property;
            this.editor = editor;
        }

        public String toString() {
            return "[" + this.property.getType().getSimpleName() + "]=" + (this.property.getValue() != null ? this.property.getValue().toString() : "");
        }
    }
}

