/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.completer;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class RegistryItemCompleter
implements Completer {
    private Collection<String> commands;

    public RegistryItemCompleter(String ... strings) {
        this(Arrays.asList(strings));
    }

    public RegistryItemCompleter(Iterable<String> strings) {
        assert (strings != null);
        this.commands = new ArrayList<String>();
        for (String string : strings) {
            this.commands.add(string);
        }
    }

    public void setCommands(Iterable<String> strings) {
        assert (strings != null);
        this.commands = new ArrayList<String>();
        for (String string : strings) {
            this.commands.add(string);
        }
    }

    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
        assert (commandLine != null);
        assert (candidates != null);
        HashSet<String> toAdd = new HashSet<String>();
        String buffer = commandLine.word().substring(0, commandLine.wordCursor());
        String[] seps = new String[]{"/", ":"};
        Separator separator = new Separator();
        separator.getLastIndexOf(buffer, seps);
        int lastSep = separator.getPos();
        String sep = separator.getSep();
        try {
            String curBuf = lastSep >= 0 ? buffer.substring(0, lastSep + 1) : "";
            for (String cmd : this.commands) {
                if (!this.accept(cmd, curBuf)) continue;
                String futureCandidate = cmd.substring(curBuf.toString().length());
                separator.getIndexOf(futureCandidate, seps);
                int cmdLastSep = separator.getPos();
                sep = separator.getSep();
                if (cmdLastSep >= 0) {
                    futureCandidate = futureCandidate.substring(0, cmdLastSep + 1);
                }
                toAdd.add(futureCandidate);
            }
            for (String c : toAdd) {
                if (c.endsWith(sep)) {
                    candidates.add(new Candidate(curBuf + c, c, null, null, sep, null, false));
                    continue;
                }
                candidates.add(new Candidate(curBuf + c, c, null, null, null, null, true));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Path getRootDir() {
        return Paths.get("", new String[0]);
    }

    protected boolean accept(String isIn, String path) {
        return isIn.startsWith(path);
    }

    class Separator {
        int pos;
        String sep;

        Separator() {
            this(-1, "/");
        }

        Separator(int i, String c) {
            this.pos = i;
            this.sep = c;
        }

        public int getPos() {
            return this.pos;
        }

        public String getSep() {
            return this.sep;
        }

        public void getLastIndexOf(String path, String[] seps) {
            this.pos = -1;
            int tmp = -1;
            for (String sep : seps) {
                tmp = path.lastIndexOf(sep);
                if (tmp <= this.pos) continue;
                this.pos = tmp;
                this.sep = sep;
            }
        }

        public void getIndexOf(String path, String[] seps) {
            this.pos = -1;
            int tmp = -1;
            for (String sep : seps) {
                tmp = path.indexOf(sep);
                if (tmp <= this.pos) continue;
                this.pos = tmp;
                this.sep = sep;
            }
        }
    }
}

