/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli.completer;

import de.grogra.cli.CLIApplication;
import de.grogra.cli.Utils;
import de.grogra.cli.completer.RegistryItemCompleter;
import de.grogra.pf.ui.ProjectWorkbench;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.WorkbenchManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.utils.AttributedString;

public class ApplicationOnWorkbenchCompleter
extends ArgumentCompleter {
    ListWorbenchesCompleter listWorkbenches;

    public ApplicationOnWorkbenchCompleter(CLIApplication app) {
        super(new Completer[0]);
        ListWorbenchesCompleter arguments = this.listWorkbenches = new ListWorbenchesCompleter();
        ArrayList<String> cmdAppWithWorkbenchArgs = new ArrayList<String>();
        List<String> cmdApp = Utils.getAppCommands(app);
        for (String s : cmdApp) {
            if (!s.endsWith("selectWB") && !s.endsWith("closeWB")) continue;
            cmdAppWithWorkbenchArgs.add(s);
        }
        cmdApp.removeAll(cmdAppWithWorkbenchArgs);
        RegistryItemCompleter commandsWithWorkbenchArgs = new RegistryItemCompleter(cmdAppWithWorkbenchArgs);
        this.getCompleters().addAll(Arrays.asList(new Completer[]{commandsWithWorkbenchArgs, arguments, NullCompleter.INSTANCE}));
    }

    public void setWorkbenches(Iterable<String> strings) {
        if (this.listWorkbenches != null) {
            this.listWorkbenches.setCandidate(strings);
        }
    }

    public void setWorkbenches(String ... strings) {
        this.setWorkbenches(Arrays.asList(strings));
    }

    public void setWorkbenches(ArrayList<Workbench> workbenches) {
        ArrayList<String> names = new ArrayList<String>();
        if (workbenches.size() > 0) {
            WorkbenchManager wbm = workbenches.get(0).getApplication().getWorkbenchManager();
            workbenches.forEach(wb -> names.add(String.valueOf(wbm.getWorkbenchId((ProjectWorkbench)wb))));
        }
        this.setWorkbenches((Iterable<String>)names);
    }

    public Completer getWorkbenchCompleter() {
        return this.listWorkbenches;
    }

    public class ListWorbenchesCompleter
    extends StringsCompleter {
        public void setCandidate(String ... strings) {
            this.setCandidate(Arrays.asList(strings));
        }

        public void setCandidate(Iterable<String> strings) {
            assert (strings != null);
            this.candidates = null;
            this.candidates = new ArrayList();
            for (String string : strings) {
                this.candidates.add(new Candidate(AttributedString.stripAnsi((String)string), string, null, null, null, null, true));
            }
        }
    }
}

