/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli;

import de.grogra.cli.CLIApplication;
import de.grogra.cli.ui.CLIWindowSupport;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.StringConst;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.util.ComponentWrapperImpl;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.jline.utils.InfoCmp;

public class Utils {
    static ItemCriterion INSTANCE_OF_ANY = new ItemCriterion(){

        public boolean isFulfilled(Item item, Object info) {
            for (Class c : (Class[])info) {
                if (!c.isInstance(item)) continue;
                return true;
            }
            return false;
        }

        public String getRootDirectory() {
            return null;
        }
    };
    static HelpSet[] windowCommands = new HelpSet[]{new HelpSet("%inspector:select", "tree-id", "select the node"), new HelpSet("%inspector:show", "tree-id", "opens the properties of the node"), new HelpSet("%log", null, "show the log"), new HelpSet("%fileexplorer", null, "list all files"), new HelpSet("%fileexpolorer:show", "file name or id", "opens a file in nano")};

    public static Object getParameter(Object info, boolean nullable) throws NullPointerException {
        Object o = null;
        if (info instanceof Queue) {
            o = ((Queue)info).poll();
        }
        if (o == null && !nullable) {
            throw new NullPointerException();
        }
        return o;
    }

    public static String getStringParameter(Object info, boolean nullable) throws NullPointerException {
        Object o = Utils.getParameter(info, nullable);
        String s = null;
        if (o instanceof String) {
            s = (String)o;
        }
        return s;
    }

    public static Boolean getBooleanParameter(Object info) throws NullPointerException {
        return Boolean.parseBoolean(Utils.getStringParameter(info, false));
    }

    public static int getintParameter(Object info) throws NullPointerException {
        return Integer.parseInt(Utils.getStringParameter(info, false));
    }

    public static float getFloatParameter(Object info) throws NullPointerException {
        return Float.parseFloat(Utils.getStringParameter(info, false));
    }

    public static Path getAbsolutePath(Context ctx, String path) {
        if (path == null) {
            return null;
        }
        CLIApplication app = (CLIApplication)ctx.getWorkbench().getApplication();
        Path n = new File(path).toPath();
        Path dest = app.getWorkingDirectory().toPath().resolve(n);
        dest = dest.normalize();
        return dest;
    }

    public static void changeDirectory(Item item, Object info, Context ctx) {
        try {
            String link = Utils.getStringParameter(info, false);
            CLIApplication app = (CLIApplication)ctx.getWorkbench().getApplication();
            Path dest = Utils.getAbsolutePath(ctx, link);
            File f = dest.toFile();
            if (f.exists()) {
                app.setWorkingDirectory(f);
                Utils.consoleWrite(ctx, dest.toString());
            } else {
                Utils.consoleWrite(ctx, CLIApplication.I18N.msg("error.fs.directorynotfound"));
            }
        }
        catch (NullPointerException e) {
            Utils.consoleWrite(ctx, CLIApplication.I18N.msg("error.fs.missingargument"));
        }
    }

    public static void listDirectoryContent(Item item, Object info, Context ctx) {
        Object result = "";
        for (File f : ((CLIApplication)ctx.getWorkbench().getApplication()).getWorkingDirectory().listFiles()) {
            result = (String)result + f.getName() + "\n";
        }
        Utils.consoleWrite(ctx, result);
    }

    public static void printDirectoryPath(Item item, Object info, Context ctx) {
        String result = ((CLIApplication)ctx.getWorkbench().getApplication()).getWorkingDirectory().getAbsolutePath();
        Utils.consoleWrite(ctx, result);
    }

    public static void editFile(Item item, Object info, Context ctx) {
        try {
            String link = Utils.getStringParameter(info, false);
            CLIApplication app = (CLIApplication)ctx.getWorkbench().getApplication();
            Path dest = Utils.getAbsolutePath(ctx, link);
            File f = dest.toFile();
            if (f.exists()) {
                try {
                    Desktop.getDesktop().open(f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Utils.consoleWrite(ctx, "file not found");
            }
        }
        catch (NullPointerException e) {
            Utils.consoleWrite(ctx, "please enter a relative path to a file");
        }
    }

    public static void consoleWrite(Context ctx, Object o) {
        ((CLIWindowSupport)ctx.getWindow()).consoleWrite((ComponentWrapper)new ComponentWrapperImpl(o, null));
    }

    public static void clearConsole(Item item, Object info, Context ctx) {
        ((CLIApplication)ctx.getWorkbench().getApplication()).terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
        ((CLIApplication)ctx.getWorkbench().getApplication()).terminal.flush();
    }

    public static void consoleWriteList(Context ctx, Object[] list, boolean numerated) {
        Object text = "";
        int i = 0;
        for (Object item : list) {
            text = (String)text + (String)(numerated ? i++ + " : " : "");
            text = (String)text + item + System.lineSeparator();
        }
        Utils.consoleWrite(ctx, (String)text + System.lineSeparator());
    }

    public static void printHeader() {
        System.out.println("  _____            _____ _      _____ __  __ _____  " + System.lineSeparator() + " / ____|          / ____| |    |_   _|  \\/  |  __ \\ " + System.lineSeparator() + "| |  __ _ __ ___ | |    | |      | | | \\  / | |__) |" + System.lineSeparator() + "| | |_ | '__/ _ \\| |    | |      | | | |\\/| |  ___/ " + System.lineSeparator() + "| |__| | | | (_) | |____| |____ _| |_| |  | | |     " + System.lineSeparator() + " \\_____|_|  \\___/ \\_____|______|_____|_|  |_|_|     " + System.lineSeparator());
    }

    public static void printStartHelp() {
        System.out.println(" ~ HELP: You can open your GroIMP project with the command: " + System.lineSeparator() + " ~ \"$open path/to/your/project.gsz\"" + System.lineSeparator() + " ~ Then, you can run any method from the project (e.g. run)" + System.lineSeparator() + " ~ Get the complete list of command with \"$help \" " + System.lineSeparator());
    }

    public static String getExtension(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }

    public static String setExtension(String path, String ext) {
        if (Utils.getExtension(path).endsWith(ext) || ext.length() <= 0) {
            return path;
        }
        if (ext.charAt(0) != '.' && ext.length() >= 1) {
            return path.concat("." + ext);
        }
        if (ext.charAt(0) == '.' && ext.length() > 1) {
            return path.concat(ext);
        }
        return path;
    }

    private static String item2helpString(Item f, String dir, String pre) {
        Object name = f.getAbsoluteName().substring(dir.length() + 1);
        if (((String)name).contains("/")) {
            return "";
        }
        String param = (String)f.getDescription("Parameter");
        if (param != null) {
            name = (String)name + " (" + param + ")";
        }
        Object space = "";
        for (int i = 0; i < 41 - ((String)name).length(); ++i) {
            space = (String)space + " ";
        }
        space = pre.length() == 0 ? (String)space + " " : space;
        String description = (String)f.getDescription("ShortDescription");
        String descName = (String)f.getDescription("Name");
        if (descName.equals(description)) {
            return "";
        }
        return pre + (String)name + (String)space + description + System.lineSeparator();
    }

    public static void showHelp(Item item, Object info, Context ctx) {
        Item[] files;
        Item fileDir;
        CLIApplication app = (CLIApplication)ctx.getWorkbench().getApplication();
        Object help = "";
        help = "Help:" + System.lineSeparator() + "The CLI is designed to execute commands on the " + System.lineSeparator() + "individual workbench as well as on the whole app." + System.lineSeparator() + System.lineSeparator();
        app.print((String)help);
        String result = "App commands ($)" + System.lineSeparator();
        for (String string : CLIApplication.APPCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.getRegistry(), (String)string);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result = result + Utils.item2helpString(f, string, "$");
            }
        }
        for (String string : CLIApplication.APPCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.getMainWorkbench(), (String)string);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result = result + Utils.item2helpString(f, string, "$");
            }
        }
        result = result + System.lineSeparator() + "Window command (%)" + System.lineSeparator() + " only a small selection of the most used panels..." + System.lineSeparator();
        for (String string : CLIApplication.WINDOWCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.selected.getRegistry(), (String)string);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result = result + Utils.item2helpString(f, string, "%");
            }
        }
        for (HelpSet helpSet : windowCommands) {
            result = result + (HelpSet)helpSet;
        }
        result = result + System.lineSeparator() + "Workbench command " + System.lineSeparator();
        for (String string : CLIApplication.WORKBENCHCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.selected.getRegistry(), (String)string);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result = result + Utils.item2helpString(f, string, "");
            }
        }
        for (String string : CLIApplication.WORKBENCHCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.getRegistry(), (String)string);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result = result + Utils.item2helpString(f, string, "");
            }
        }
        Utils.consoleWrite(ctx, result);
    }

    public static List<String> getAllCommands(CLIApplication app) {
        Item[] files;
        Item fileDir;
        ArrayList<String> result = new ArrayList<String>();
        for (String dir : CLIApplication.APPCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.getRegistry(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add("$" + f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        for (String dir : CLIApplication.APPCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.getMainWorkbench(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add("$" + f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        for (String dir : CLIApplication.WINDOWCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.selected.getRegistry(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add("%" + f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        for (String dir : CLIApplication.WORKBENCHCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.selected.getRegistry(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add(f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        for (String dir : CLIApplication.WORKBENCHCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.getRegistry(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add(f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        return result;
    }

    public static List<String> getWindowCommands(CLIApplication app) {
        ArrayList<String> result = new ArrayList<String>();
        for (String dir : CLIApplication.WINDOWCOMMANDDIRS) {
            Item[] files;
            Item fileDir = Item.resolveItem((RegistryContext)app.selected.getRegistry(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add("%" + f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        return result;
    }

    public static List<String> getWorkbenchCommands(CLIApplication app) {
        ArrayList<String> result = new ArrayList<String>();
        for (String dir : CLIApplication.WORKBENCHCOMMANDDIRS) {
            Item[] files;
            Item fileDir = Item.resolveItem((RegistryContext)app.selected.getRegistry(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add(f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        return result;
    }

    public static List<String> getAppCommands(CLIApplication app) {
        Item[] files;
        Item fileDir;
        ArrayList<String> result = new ArrayList<String>();
        for (String dir : CLIApplication.APPCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.getRegistry(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add("$" + f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        for (String dir : CLIApplication.APPCOMMANDDIRS) {
            fileDir = Item.resolveItem((RegistryContext)app.getMainWorkbench(), (String)dir);
            for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)INSTANCE_OF_ANY, (Object)new Class[]{Command.class, StringConst.class}, (boolean)true)) {
                result.add("$" + f.getAbsoluteName().substring(dir.length() + 1));
            }
        }
        return result;
    }

    static class HelpSet {
        String name;
        String parameter;
        String description;

        public HelpSet(String name, String parameter, String description) {
            this.name = name;
            this.description = description;
            this.parameter = parameter;
        }

        public String toString() {
            if (this.parameter != null) {
                this.name = this.name + " (" + this.parameter + ")";
            }
            Object space = "";
            for (int i = 0; i < 40 - this.name.length(); ++i) {
                space = (String)space + " ";
            }
            return this.name + (String)space + this.description + System.lineSeparator();
        }
    }
}

