/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli;

import de.grogra.cli.CLIWorkbench;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.RegistryLoader;
import de.grogra.pf.registry.Directory;
import de.grogra.pf.registry.Executable;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.Project;
import de.grogra.pf.ui.ProjectWorkbench;
import de.grogra.pf.ui.UIApplication;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.WorkbenchManager;
import de.grogra.pf.ui.registry.ProjectFactory;
import de.grogra.projectmanager.JobManagerImpl;
import de.grogra.util.Map;
import de.grogra.util.StringMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;

public class CLIWorkbenchManager
implements WorkbenchManager {
    private Registry registry;
    private HashMap<Integer, Workbench> workbenches;
    protected UIApplication app;
    private static int wbID;

    public CLIWorkbenchManager(Registry r, UIApplication app) {
        try {
            CLIWorkbenchManager.loadRegistry(r, null, false);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        r.setEmptyGraph();
        this.registry = r;
        this.workbenches = new HashMap();
        this.app = app;
        wbID = 0;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Object getWorkbenchId(ProjectWorkbench wb) {
        for (int key : this.workbenches.keySet()) {
            if (!this.workbenches.get(key).equals(wb)) continue;
            return key;
        }
        return null;
    }

    public void registerWorkbench(ProjectWorkbench wb) {
        this.workbenches.put(wbID, (Workbench)wb);
        wb.setToken((Object)(wb.getApplicationName() + "-" + wbID++));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterWorkbench(ProjectWorkbench wb) {
        HashMap<Integer, Workbench> hashMap = this.workbenches;
        synchronized (hashMap) {
            if (this.isManager(wb)) {
                this.workbenches.remove((int)((Integer)this.getWorkbenchId(wb)));
                if (this.app.getMainWorkbench() == wb) {
                    this.app.exit();
                } else if (this.app.selected == wb) {
                    this.app.selected = this.app.getMainWorkbench();
                }
            }
        }
    }

    public ProjectWorkbench getWorkbench(Object id) throws IndexOutOfBoundsException {
        return (ProjectWorkbench)this.workbenches.get((int)((Integer)id));
    }

    public HashMap<Integer, Workbench> listWorkbenches() {
        return this.workbenches;
    }

    public String[] listWorkbenchesName() {
        int l = this.workbenches.size();
        if (l == 0) {
            return new String[0];
        }
        int i = 0;
        String[] list = new String[l];
        for (int key : this.workbenches.keySet()) {
            list[i] = key + " : " + this.workbenches.get(key).getName();
            ++i;
        }
        return list;
    }

    public void closeWorkbench(ProjectWorkbench w) {
        this.closeWorkbench(w, null);
    }

    public void closeWorkbench(ProjectWorkbench w, final Command afterDispose) {
        this.deregisterWorkbench(w);
        Command kill = new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object info, Context context) {
                context.getWorkbench().getJobManager().stop(afterDispose);
            }
        };
        w.getJobManager().execute(kill, (Object)w, (Context)w, 10000);
    }

    public boolean isManager(ProjectWorkbench wb) {
        return this.workbenches.values().contains(wb);
    }

    public ProjectWorkbench createWorkbench(ProjectFactory pf, FilterSource fs, Map initParams) {
        try {
            Project p = this.app.getProjectManager().openProject(pf, fs, initParams);
            return this.createWorkbench(p);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProjectWorkbench createWorkbench(ProjectFactory pf) throws IOException {
        Project p = this.app.getProjectManager().createProject(pf);
        return this.createWorkbench(p);
    }

    public ProjectWorkbench createWorkbench(Object projectId) {
        Project p = this.app.getProjectManager().getProject(projectId);
        return this.createWorkbench(p);
    }

    protected ProjectWorkbench createWorkbench(Project p) {
        CountDownLatch doneSignal = new CountDownLatch(1);
        JobManagerImpl jm = new JobManagerImpl(doneSignal);
        CLIWorkbench wb = new CLIWorkbench(Registry.create((Registry)p.getRegistry()), (JobManager)jm, this.app, Map.EMPTY_MAP);
        wb.setProject(p);
        wb.init();
        wb.getJobManager().initialize((Workbench)wb);
        this.registerWorkbench(wb);
        this.app.getProjectManager().linkWorkbenchToProject(p.getId(), (ProjectWorkbench)wb);
        new Thread((Runnable)((JobManagerImpl)wb.getJobManager()), "Workbench@Id" + this.getWorkbenchId(wb)).start();
        try {
            doneSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return wb;
    }

    private static void loadRegistry(Registry reg, RegistryLoader loader, boolean project) throws IOException {
        StringMap m = new StringMap().putObject("registry", (Object)reg);
        if (project) {
            ((Item)reg.getRoot()).add((Item)new Directory("project"));
        }
        Executable.runExecutables((Registry)reg.getRootRegistry(), (String)"/hooks/configure", (RegistryContext)reg, (StringMap)m);
        if (loader != null) {
            loader.loadRegistry(reg);
        }
        Executable.runExecutables((Registry)reg.getRootRegistry(), (String)"/hooks/complete", (RegistryContext)reg, (StringMap)m);
        reg.activateItems();
    }

    public ArrayList<Workbench> getWorkbenches() {
        return new ArrayList<Workbench>(this.workbenches.values());
    }
}

