/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli;

import de.grogra.cli.CLIApplication;
import de.grogra.cli.Utils;
import de.grogra.cli.ui.CLIWindowSupport;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.View3D;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.registry.Executable;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.ObjectExpr;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.ProjectWorkbench;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIApplication;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.FileFactory;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.vfs.FileSystem;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileFilter;

public class CLIWorkbench
extends ProjectWorkbench
implements TreeModelListener {
    private Window window;
    boolean compiling = false;
    Object COMPILE_LOCK = new Object();
    Command WAIT_COMPILATION = new Command(){

        public String getCommandName() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Object info, Context context) {
            Object object = CLIWorkbench.this.COMPILE_LOCK;
            synchronized (object) {
                CLIWorkbench.this.compiling = false;
                CLIWorkbench.this.COMPILE_LOCK.notifyAll();
            }
        }
    };

    public CLIWorkbench(Registry registry, JobManager jm, UIApplication app, Map initParams) {
        super(jm, app.getToolkit(), initParams);
        this.app = app;
    }

    public void init() {
        Executable.runExecutables((Registry)this.getRegistry().getRootRegistry(), (String)"/hooks/cliLaunch", (RegistryContext)this.getRegistry(), (StringMap)new StringMap());
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    public void open(Object info) {
        try {
            this.app.open(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Workbench open(FilterSource fs, Map initParams) {
        return this.getApplication().open(fs, initParams);
    }

    public boolean saveAs(Object info) {
        String path = Utils.getStringParameter(info, true);
        path = path == null ? null : Utils.getAbsolutePath((Context)this, path).toString();
        FileChooserResult fr = this.app.getToolkit().chooseFile("save project", (FileFilter[])IO.getWritableFileTypes((IOFlavor)IOFlavor.REGISTRY), 2, false, null, (Context)this, path);
        if (fr != null) {
            return this.saveAs(fr.file, fr.getMimeType());
        }
        return false;
    }

    public void listFunctions(Object info) {
        Object erg = "";
        for (Command c : this.getFunctions()) {
            erg = (String)erg + System.lineSeparator() + " - " + c.getCommandName();
        }
        ((CLIWindowSupport)this.window).consoleWrite((String)erg);
    }

    public String getFileContent(Object info) {
        String name = Utils.getStringParameter(info, false);
        return name;
    }

    public void getProjectInfo(Object info) {
        ((CLIWindowSupport)this.window).consoleWrite(this.getProject().toString());
    }

    public String getApplicationName() {
        return "GroCLIMP";
    }

    public Window getWindow() {
        return this.window;
    }

    public Workbench getMainWorkbench() {
        return this.app.getMainWorkbench();
    }

    public void stopLocalFileSynchronization() {
    }

    public void startLocalFileSynchronization() {
    }

    void disposeWhenNotInitialized() {
        this.getRegistry().dispose();
    }

    public void dispose(Command afterDispose) {
        if (this.window != null) {
            this.window.dispose();
        }
        this.getRegistry().removeFileSystemListener((TreeModelListener)this);
        this.disposeWhenNotInitialized();
        if (afterDispose != null) {
            afterDispose.run(null, (Context)this);
        }
        CLIWorkbench.setCurrent(null);
        this.window = null;
    }

    public void initialize() {
        super.initialize();
        CLIWorkbench.setCurrent((Workbench)this);
        this.getRegistry().addFileSystemListener((TreeModelListener)this);
        this.updateName();
        Map propMap = Map.EMPTY_MAP;
        Object o = this.getRegistry().getRootRegistry().getUserProperty(Main.SCREEN_PROPERTY_ID.intValue());
        if (o != null) {
            propMap = new StringMap().putInt("screen", ((Integer)o).intValue());
        }
        this.window = this.getToolkit().createWindow(CLOSE, propMap);
        if (this.window != null) {
            this.initializeWindow();
            this.window.show(true, null);
        }
        StringMap m = new StringMap().putObject("registry", (Object)this.getRegistry());
        m.putObject("workbench", (Object)this);
        m.putObject("filesystem", (Object)this.getRegistry().getFileSystem());
        Executable.runExecutables((Registry)this.getRegistry().getRootRegistry(), (String)"/hooks/projectloaded", (RegistryContext)this.getRegistry(), (StringMap)m);
    }

    void initializeWindow() {
        this.initializeWindow(this.window);
    }

    public boolean isSelected() {
        return this == this.app.getCurrentWorkbench();
    }

    protected void close(final Command afterDispose) {
        if (this.getWindow() != null) {
            final Panel[] panels = this.getWindow().getPanels(null);
            new Command(){

                public void run(Object info, Context ctx) {
                    for (int i = 0; i < panels.length; ++i) {
                        Panel p = panels[i];
                        if (p == null) continue;
                        panels[i] = null;
                        p.checkClose((Command)this);
                        return;
                    }
                    CLIWorkbench.this.close0(afterDispose);
                }

                public String getCommandName() {
                    return null;
                }
            }.run(null, (Context)this);
        } else {
            this.close0(afterDispose);
        }
    }

    void close0(Command afterDispose) {
        if (this.isModified() && this.getWindow() != null) {
            int res = this.getWindow().showDialog(UI.I18N.msg("project.savequestion.title"), (Object)UI.I18N.msg("project.savequestion.msg", (Object)this.getName()), 100);
            if (res == 2) {
                return;
            }
            if (res == 0 && !this.save(true)) {
                return;
            }
        }
        Registry r = this.getRegistry().getRootRegistry();
        Executable.runExecutables((Registry)r, (String)"/hooks/close", (RegistryContext)r, (StringMap)UI.getArgs((Context)this, null));
        this.getApplication().getWorkbenchManager().closeWorkbench((ProjectWorkbench)this);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.treeStructureChanged(e);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.treeStructureChanged(e);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.treeStructureChanged(e);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        if (!((FileSystem)e.getSource()).isPersistent()) {
            this.setModified();
        }
    }

    public void addNode(Object info) {
        URL u = null;
        try {
            String link = Utils.getStringParameter(info, false);
            if (link.equals("-o")) {
                this.addGeometricalObject(info);
                return;
            }
            Path src = Utils.getAbsolutePath((Context)this, link);
            if (src.toFile().exists()) {
                u = de.grogra.util.Utils.fileToURL((File)src.toFile());
            } else {
                ((CLIWindowSupport)this.window).consoleWrite(CLIApplication.I18N.msg("error.addnode.filenotfound"));
            }
        }
        catch (NullPointerException link) {
            // empty catch block
        }
        FileFactory ex = (FileFactory)Item.resolveItem((RegistryContext)this.getProject(), (String)"/objects/objects/file");
        StringMap x = new StringMap();
        this.addNode((Node)ex.addFromURL(this.getRegistry(), u, (ModifiableMap)x, (Workbench)this));
    }

    private void addGeometricalObject(Object info) {
        try {
            String type = Utils.getStringParameter(info, false);
            Item i = Item.resolveItem((RegistryContext)this.getProject(), (String)("/objects/3d/geometry/" + type));
            if (i != null) {
                ObjectExpr ob = (ObjectExpr)i;
                this.addNode((Node)ob.evaluate((RegistryContext)this.getRegistry(), new StringMap()));
            }
        }
        catch (NullPointerException e) {
            ((CLIWindowSupport)this.window).consoleWrite(CLIApplication.I18N.msg("error.object.add.missingargument"));
        }
    }

    public void addSourceFile(Object info) {
        String path = Utils.getStringParameter(info, true);
        path = path == null ? null : Utils.getAbsolutePath((Context)this, path).toString();
        FileChooserResult fr = this.app.getToolkit().chooseFile(null, (FileFilter[])IO.getReadableFileTypes((IOFlavor[])new IOFlavor[]{IOFlavor.RESOURCE_LOADER}), 1, false, null, (Context)this, path);
        if (fr != null) {
            String dest = Utils.getStringParameter(info, true);
            this.addSourceFile(fr.file, fr.getMimeType(), dest);
        }
    }

    public void export(Object info) {
        ((Command)Item.resolveItem((RegistryContext)this, (String)"/ui/panels/3d/defaultview")).run(null, (Context)this);
        View3D view = (View3D)this.getWindow().getPanel("/ui/panels/3d/defaultview");
        if (view != null) {
            ObjectSourceImpl src = new ObjectSourceImpl((Object)view, "view", view.getFlavor(), this.getRegistry().getRootRegistry(), null);
            String path = Utils.getStringParameter(info, true);
            path = path == null ? null : Utils.getAbsolutePath((Context)this, path).toString();
            final FileChooserResult fr = this.app.getToolkit().chooseFile(UI.I18N.getString("filedialog.exportfile", "Export Scene in file"), (FileFilter[])IO.getWritableFileTypes((IOFlavor)src.getFlavor()), 0, false, null, (Context)this, path);
            if (fr != null) {
                UI.executeLockedly((Lockable)this.getRegistry().getProjectGraph(), (boolean)true, (Command)new Command(){
                    final /* synthetic */ FilterSource val$src;
                    {
                        this.val$src = filterSource;
                    }

                    public String getCommandName() {
                        return null;
                    }

                    public void run(Object info, Context c) {
                        CLIWorkbench.this.exportImpl(fr, this.val$src);
                    }
                }, null, (Context)this, (int)10000);
            }
        }
    }

    private void exportImpl(FileChooserResult fr, FilterSource src) {
        File file = fr.file;
        this.setProperty("export-visible-layer", false);
        this.export(src, fr.getMimeType(), file);
    }

    public void renameSourceFile(Object info) {
        try {
            String file = Utils.getStringParameter(info, false);
            String name = Utils.getStringParameter(info, false);
            this.renameSourceFile(file, name);
        }
        catch (NullPointerException e) {
            ((CLIWindowSupport)this.window).consoleWrite(CLIApplication.I18N.msg("error.file.rename.missingargument"));
        }
    }

    public void removeSourceFile(Object info) {
        try {
            String file = Utils.getStringParameter(info, false);
            this.removeSourceFile(file);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void logTest(Item item, Object info, Context ctx) {
        ctx.getWorkbench().logInfo("whats up");
    }

    public void execute(Object info) {
        if (info instanceof Command) {
            this.project.execute((Command)info, (Context)this);
        } else {
            try {
                String command = Utils.getStringParameter(info, false);
                this.execute(command);
            }
            catch (NullPointerException e) {
                ((CLIWindowSupport)this.window).consoleWrite(CLIApplication.I18N.msg("error.rgg.run.missingargument"));
                this.listFunctions(info);
            }
        }
    }

    public void compile() {
        this.compiling = true;
        UI.executeLockedly((Lockable)this.getRegistry().getProjectGraph(), (boolean)true, (Command)new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object info, Context context) {
                CLIWorkbench.this.project.compile(context, CLIWorkbench.this.WAIT_COMPILATION);
            }
        }, null, (Context)this, (int)5000);
    }

    public boolean isCompiling() {
        return this.compiling;
    }

    public Object getCompilationLock() {
        return this.COMPILE_LOCK;
    }

    public void exportFromNode(Object info) throws Exception {
    }

    public void exportFromNode(Object info, Node root) throws Exception {
    }
}

