/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli;

import de.grogra.cli.CLIApplication;
import de.grogra.cli.ui.CLIAttributeEditorPanel;
import de.grogra.cli.ui.CLIChartPanelSupport;
import de.grogra.cli.ui.CLIComponent;
import de.grogra.cli.ui.CLIConsolePanel;
import de.grogra.cli.ui.CLIContainer;
import de.grogra.cli.ui.CLILoggingFormatter;
import de.grogra.cli.ui.CLIMenuComponent;
import de.grogra.cli.ui.CLIPanel;
import de.grogra.cli.ui.CLIPanelSupport;
import de.grogra.cli.ui.CLIStatusBar;
import de.grogra.cli.ui.CLITextComponent;
import de.grogra.cli.ui.CLITextEditor;
import de.grogra.cli.ui.CLIUITree;
import de.grogra.cli.ui.CLIWidget;
import de.grogra.cli.ui.CLIWindowSupport;
import de.grogra.icon.IconSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.ui.ChartPanel;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Console;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.LoggingHandler;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Widget;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.ComponentWrapperImpl;
import de.grogra.reflect.Type;
import de.grogra.util.Disposable;
import de.grogra.util.Map;
import de.grogra.util.Quantity;
import de.grogra.util.Utils;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.net.URL;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.table.TableModel;

public class CLIToolkit
extends UIToolkit {
    public Panel createPanel(Context ctx, Disposable toDispose, Map params) {
        return new CLIPanelSupport(toDispose).initialize((CLIWindowSupport)ctx.getWindow(), params);
    }

    public Console createConsole(Context context, Map params) {
        return (Console)new CLIConsolePanel(context, params).initialize((Panel)context.getWindow(), params);
    }

    public Panel createStatusBar(Context context, Map params) {
        CLIStatusBar bar = new CLIStatusBar();
        bar.initialize((CLIWindowSupport)context.getWindow(), params);
        Panel p = this.createPanel(context, bar, params);
        p.setContent((ComponentWrapper)bar);
        return p;
    }

    public Window createWindow(Command close, Map params) {
        return new CLIWindowSupport(this, close, params);
    }

    public Panel createViewerPanel(Context ctx, URL url, Map params) {
        return new CLIPanel(null).getSupport();
    }

    public TextEditor createTextEditor(Context context, Map params) {
        CLITextEditor ed = new CLITextEditor();
        ed.initialize((CLIPanelSupport)context.getWindow(), params);
        return ed;
    }

    public Panel createToolBar(Context context, Map params) {
        return new CLIPanel(null).getSupport();
    }

    public Object createTextViewer(URL url, String mimeType, String content, Command hyperlink, boolean asBrowser) {
        CLITextComponent c = new CLITextComponent();
        c.initialize((CLIPanelSupport)Workbench.current().getWindow(), Map.EMPTY_MAP);
        return c;
    }

    public void setContent(Object textViewer, String mimeType, String content) {
        ((CLITextComponent)textViewer).read(content);
    }

    public void setContent(Object textViewer, URL content) {
        Workbench.current().logInfo(CLIApplication.I18N.msg("error.url"));
    }

    public Object createLabel(String text, IconSource icon, Dimension size, int flags) {
        CLIComponent c = new CLIComponent();
        c.setName(text);
        return c;
    }

    public Object createButton(String text, IconSource source, Dimension size, int flags, Command cmd, Context ctx) {
        CLIComponent c = new CLIComponent();
        c.setName(text);
        return c;
    }

    public Object createLabeledComponent(Object component, Object label) {
        CLIComponent c = new CLIComponent();
        c.setName(label.toString());
        return c;
    }

    public Widget createNumericWidget(Type type, Quantity quantity, Map params) {
        return new CLIWidget(type, quantity, params);
    }

    public Widget createStringWidget(Map params) {
        return new CLIWidget("String");
    }

    public Widget createTreeChoiceWidget(UITree tree) {
        return new CLIWidget(tree);
    }

    public Widget createChoiceWidget(ListModel list, boolean forMenu) {
        return new CLIWidget(list, forMenu);
    }

    public Widget createBooleanWidget(boolean forMenu, Map params) {
        return new CLIWidget(forMenu, params);
    }

    public Widget createColorWidget(Map params) {
        return new CLIWidget("Color");
    }

    public ChartPanel createChartPanel(Context ctx, Map params) {
        return (ChartPanel)new CLIChartPanelSupport(new CLIPanel(null)).initialize((CLIPanelSupport)ctx.getWindow(), params);
    }

    public Object createScrollPane(Object view) {
        return new CLIContainer((ComponentWrapper)view);
    }

    public Object createTabbedPane(String[] titles, Object[] components) {
        CLIComponent c = new CLIComponent();
        c.setName(titles.toString());
        c.setContent(components);
        return c;
    }

    public Object createContainer(int gap) {
        return new CLIContainer();
    }

    public Object createSplitContainer(int orientation) {
        return new CLIContainer();
    }

    public Object createContainer(int rows, int cols, int gap) {
        return new CLIContainer();
    }

    public Object createContainer(float[] weights, int gap) {
        return new CLIContainer();
    }

    public Object setBorder(Object component, int gap) {
        return null;
    }

    public void addComponent(Object container, Object component, Object constraints, int index) {
        if (!(component instanceof CLIComponent)) {
            CLIComponent c = new CLIComponent();
            c.setContent(component);
            ((CLIContainer)container).add(c, constraints, index);
        } else {
            ((CLIContainer)container).add((CLIComponent)component, constraints, index);
        }
    }

    public void removeComponent(Object component) {
        if (component != null) {
            CLIComponent c = (CLIComponent)component;
            c.getParent().remove(c);
        }
    }

    public Object getParent(Object component) {
        return ((CLIComponent)component).getParent();
    }

    public int indexOf(Object component) {
        return 0;
    }

    public int getComponentCount(Object container) {
        return ((CLIContainer)container).countComponents();
    }

    public Object getComponent(Object container, int index) {
        return ((CLIContainer)container).getComponent(index);
    }

    public Point getLocationOnScreen(Object component) {
        throw new HeadlessException();
    }

    public int getWidth(Object component) {
        throw new HeadlessException();
    }

    public int getHeight(Object component) {
        throw new HeadlessException();
    }

    public void revalidate(Object component) {
    }

    public void repaint(Object component) {
    }

    public Object getTextViewerComponent(Panel viewerPanel) {
        return new CLITextComponent();
    }

    public ComponentWrapper createComponentTree(UITree componentTree) {
        CLIAttributeEditorPanel c = new CLIAttributeEditorPanel();
        c.setContent(componentTree);
        return new ComponentWrapperImpl((Object)c, (Disposable)componentTree);
    }

    public ComponentWrapper createComponentMenu(UITree componentTree) {
        return new CLIMenuComponent(componentTree);
    }

    public ComponentWrapper createTable(TableModel table, Context ctx) {
        throw new HeadlessException();
    }

    public int getSelectedRow(ComponentWrapper table) {
        throw new HeadlessException();
    }

    public TableModel getTable(ComponentWrapper table) {
        throw new HeadlessException();
    }

    public void showPopupMenu(UITree menu, Object component, int x, int y) {
        throw new HeadlessException();
    }

    public ComponentWrapper createTreeInSplit(UITree tree, Object split) {
        CLIUITree st = (CLIUITree)this.createTree(tree);
        return st;
    }

    public ComponentWrapper createTree(UITree tree) {
        return new CLIUITree(tree);
    }

    public ComponentWrapper createUITreeComponent(Object componentTree) {
        return new CLIUITree((UITree)((JTree)componentTree).getModel());
    }

    public void setLayout(Object component, LayoutManager layout) {
    }

    public ComponentWrapper createDisplayForProject(Context context, Item item) {
        return null;
    }

    public Panel createLogViewer(final Context ctx, Map params) {
        final LoggingHandler handler = new LoggingHandler(ctx);
        handler.setFormatter((Formatter)new CLILoggingFormatter(UI.I18N, UIToolkit.MEDIUM_ICON_SIZE));
        handler.setMimeType("text/html");
        handler.setLevel(Level.ALL);
        Object o = Utils.get((Map)params, (Object)"logrecords", null);
        if (o instanceof LogRecord[][]) {
            LogRecord[][] a = (LogRecord[][])o;
            for (int i = 0; i < a.length; ++i) {
                LogRecord[] b = a[i];
                if (b == null || b.length <= 0) continue;
                handler.beginGrouping();
                for (int j = 0; j < b.length; ++j) {
                    handler.publish(b[j]);
                }
                handler.endGrouping();
            }
        }
        ctx.getWorkbench().getLogger().addHandler((Handler)handler);
        class Helper
        implements ComponentWrapper,
        JobManager.ExecutionListener {
            private boolean executing;

            Helper() {
            }

            public void dispose() {
                UI.getJobManager((Context)ctx).removeExecutionListener((JobManager.ExecutionListener)this);
                ctx.getWorkbench().getLogger().removeHandler((Handler)handler);
            }

            public Object getComponent() {
                return handler.getComponent();
            }

            public void executionStarted(JobManager jm) {
                this.executing = true;
                handler.beginGrouping();
            }

            public void executionFinished(JobManager jm) {
                if (this.executing) {
                    this.executing = false;
                    handler.endGrouping();
                }
            }
        }
        Helper h = new Helper();
        UI.getJobManager((Context)ctx).addExecutionListener((JobManager.ExecutionListener)h);
        Panel p = this.createPanel(ctx, null, params);
        p.setContent((ComponentWrapper)h);
        return p;
    }

    public void hightliteContent(Object textViewer, String text) {
    }
}

