/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli;

import de.grogra.pf.ui.Synchronizer;
import de.grogra.util.Utils;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;

public class CLISynchronizer
extends Synchronizer {
    public static final CLISynchronizer QUEUE = new CLISynchronizer(null);

    public CLISynchronizer(Synchronizer.Callback callback) {
        super(callback);
    }

    protected boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public void execute(Runnable r) {
        EventQueue.invokeLater(r);
    }

    protected void invokeAndWait(Runnable r) throws InvocationTargetException {
        Throwable t = Queue.get(Toolkit.getDefaultToolkit().getSystemEventQueue()).invokeAndWait(r);
        if (t != null) {
            throw new InvocationTargetException(t);
        }
    }

    public static void staticInvokeAndWait(Runnable r) {
        try {
            QUEUE.invokeAndWait(r);
        }
        catch (InvocationTargetException e) {
            Utils.rethrow((Throwable)e.getTargetException());
        }
    }

    public static void invokeInEventQueue(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            CLISynchronizer.staticInvokeAndWait(r);
        }
    }

    private static final class Queue
    implements Runnable {
        private static final WeakHashMap queues = new WeakHashMap();
        private boolean running = false;
        private final Object postLock = new Object();
        private final Object doneLock = new Object();
        private Runnable nextRunnable = null;
        private Throwable exception;

        private Queue() {
        }

        static synchronized Queue get(EventQueue eq) {
            Queue q = (Queue)queues.get(eq);
            if (q == null) {
                q = new Queue();
                queues.put(eq, q);
            }
            return q;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized Throwable invokeAndWait(Runnable r) {
            try {
                Object object = this.doneLock;
                synchronized (object) {
                    Object object2 = this.postLock;
                    synchronized (object2) {
                        this.nextRunnable = r;
                        if (this.running) {
                            this.postLock.notifyAll();
                        } else {
                            EventQueue.invokeLater(this);
                        }
                    }
                    while (this.nextRunnable != null) {
                        try {
                            this.doneLock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                    }
                }
                object = this.exception;
                return object;
            }
            finally {
                this.exception = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.postLock;
            synchronized (object) {
                this.running = true;
                try {
                    while (this.nextRunnable != null) {
                        try {
                            this.exception = null;
                            this.nextRunnable.run();
                        }
                        catch (Throwable t) {
                            this.exception = t;
                        }
                        Object t = this.doneLock;
                        synchronized (t) {
                            this.nextRunnable = null;
                            this.doneLock.notifyAll();
                        }
                        if (this.running) {
                            try {
                                this.postLock.wait(15L);
                            }
                            catch (InterruptedException e) {
                                this.running = false;
                            }
                            continue;
                        }
                        return;
                    }
                }
                finally {
                    this.running = false;
                }
            }
        }
    }
}

