/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.cli;

import de.grogra.cli.CLIStringWritter;
import de.grogra.cli.CLIToolkit;
import de.grogra.cli.CLIWorkbench;
import de.grogra.cli.CLIWorkbenchManager;
import de.grogra.cli.ExecutableComponent;
import de.grogra.cli.Utils;
import de.grogra.cli.completer.ApplicationCompleter;
import de.grogra.cli.completer.ApplicationOnFileCompleter;
import de.grogra.cli.completer.ApplicationOnWorkbenchCompleter;
import de.grogra.cli.completer.RGGCompleter;
import de.grogra.cli.completer.SystemFileCompleter;
import de.grogra.cli.completer.WindowCompleter;
import de.grogra.cli.completer.WorkbenchCompleter;
import de.grogra.cli.ui.CLIConsolePanel;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.registry.Application;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.StringConst;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.ProjectManager;
import de.grogra.pf.ui.ProjectWorkbench;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIApplication;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.registry.ProjectDirectory;
import de.grogra.pf.ui.registry.ProjectFactory;
import de.grogra.projectmanager.ProjectFactoryImpl;
import de.grogra.projectmanager.ProjectManagerImpl;
import de.grogra.util.I18NBundle;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.filechooser.FileFilter;
import org.jline.builtins.Nano;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class CLIApplication
extends UIApplication {
    private static CLIApplication PLUGIN;
    public static final I18NBundle I18N;
    private File workingDirectory;
    private boolean running;
    protected State state = State.READ_COMMAND;
    protected final ReentrantLock allowToWrite = new ReentrantLock();
    static String[] APPCOMMANDDIRS;
    static String[] WINDOWCOMMANDDIRS;
    static String[] WORKBENCHCOMMANDDIRS;
    Terminal terminal = null;
    TerminalBuilder builder = TerminalBuilder.builder();
    private Completer sysFileCompleter = null;
    Completer appCompleter = null;
    Completer appWbCompleter = null;
    Completer appFileCompleter = null;
    Completer workbenchCompleter = null;
    Completer windowCompleter = null;
    Completer xlConsoleCompleter = null;
    Completer rggCompleter = null;
    Completer cliCompleter = null;
    Completer readerCompleter = null;
    Parser parser = null;
    LineReader reader;
    CLIStringWritter printAbove;
    String PROMPT;
    String RIGHT_PROMPT = "DEFAULT_S";
    File fileToEdit;
    String fileToEdit_RealName;
    final String XLPROMPT = "XLCODE >";
    final String XLEXIT = "exit";
    final char APP_CHAR = (char)36;
    final char WINDOW_CHAR = (char)37;
    final char LOCK_CHAR = (char)38;
    final char PIPE_CHAR = (char)124;
    final char WINDOW_PIPE_CHAR = (char)58;
    Object BLOCKING = new Object();
    Command WAIT_BLOCK = new Command(){

        public String getCommandName() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Object info, Context context) {
            Object object = CLIApplication.this.BLOCKING;
            synchronized (object) {
                CLIApplication.this.BLOCKING.notifyAll();
            }
        }
    };
    boolean script = false;
    Command afterCommand = null;
    boolean executing = false;
    Object EXECUTING_LOCK = new Object();
    Command WAIT_EXECUTION = new Command(){

        public String getCommandName() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Object info, Context context) {
            Object object = CLIApplication.this.EXECUTING_LOCK;
            synchronized (object) {
                CLIApplication.this.executing = false;
                CLIApplication.this.EXECUTING_LOCK.notifyAll();
            }
        }
    };

    public CLIApplication() {
        assert (PLUGIN == null);
        PLUGIN = this;
    }

    public static CLIApplication getInstance() {
        return PLUGIN;
    }

    public Workbench getCurrentWorkbench() {
        return this.selected;
    }

    public String getCommandName() {
        return "GroCLIMP";
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        this.getMainWorkbench().setProperty("current-dir", (Object)workingDirectory.getAbsolutePath().toString());
    }

    public static void run(Application app) {
        ProjectManager pm = ProjectManagerImpl.getInstance();
        CLIToolkit ui = new CLIToolkit();
        CLIWorkbenchManager wbm = new CLIWorkbenchManager(Registry.create((Registry)app.getRegistry()), PLUGIN);
        PLUGIN.init(pm, ui, wbm);
        PLUGIN.startUIApp();
        PLUGIN.runUIApp();
        System.out.println(I18N.msg("exit.msg"));
    }

    public void run(Object arg, Context context) {
    }

    protected void startUIApp() {
        Main.closeSplashScreen();
        this.running = true;
        try {
            this.setMainWorkbench((CLIWorkbench)this.wbm.createWorkbench((ProjectFactory)new ProjectFactoryImpl()));
        }
        catch (IOException e1) {
            System.out.println(I18N.msg("error.start.mainworkbench"));
            Main.exit();
        }
        this.getMainWorkbench().getProject().setName("base");
        this.selected = this.getMainWorkbench();
        this.setWorkingDirectory(new File(System.getProperty("user.home")));
        System.out.println(I18N.msg("start.msg"));
        Utils.printHeader();
        Utils.printStartHelp();
        this.builder.system(true);
        this.xlConsoleCompleter = new StringsCompleter();
        this.cliCompleter = this.setupCompleters();
        this.setCLICompleter();
        DefaultParser p3 = new DefaultParser();
        p3.setEscapeChars(new char[0]);
        this.parser = p3;
        this.builder.name("GroIMP");
        try {
            this.terminal = this.builder.build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).completer(this.readerCompleter).parser(this.parser).variable("secondary-prompt-pattern", (Object)"%M%P > ").variable("indentation", (Object)2).option(LineReader.Option.INSERT_BRACKET, true).build();
        this.printAbove = new CLIStringWritter(this.reader);
    }

    private void setState(State newState) {
        this.state = newState;
    }

    public synchronized void println(String out) {
        if (out != null) {
            this.printAbove.write(out + System.lineSeparator());
        }
    }

    public synchronized void print(String out) {
        if (out != null) {
            this.printAbove.write(out);
        }
    }

    public synchronized void println(Object out) {
        if (out != null) {
            this.terminal.writer().println(out);
        }
    }

    public synchronized void print(Object out) {
        if (out != null) {
            this.terminal.writer().print(out);
        }
    }

    public synchronized void flush() {
        if (this.terminal != null) {
            this.terminal.flush();
        }
        this.printAbove.flush();
    }

    public void updateLoadingPrompt(String rightPrompt) {
        if (rightPrompt != null) {
            this.RIGHT_PROMPT = rightPrompt;
            ((LineReaderImpl)this.reader).setRightPrompt(this.RIGHT_PROMPT);
            ((LineReaderImpl)this.reader).redisplay();
        }
    }

    public void updatePrompt() {
        String busy = this.selected.getJobManager().isExecuting() ? "~R" : "";
        this.setPROMPT("[" + this.selected.getName() + busy + "]>>");
    }

    private void updateXlCompleter() {
    }

    private void setXlCompleter() {
        this.readerCompleter = this.xlConsoleCompleter;
        this.updateReader();
    }

    private void setCLICompleter() {
        this.readerCompleter = this.cliCompleter;
        this.updateReader();
    }

    private void updateLineCompleter(File newDir) {
        if (this.reader == null) {
            return;
        }
        ((SystemFileCompleter)this.getSysFileCompleter()).changeDir(newDir);
    }

    public void updateCLICompleters() {
        this.updateLineCompleter(this.workingDirectory);
        ((ApplicationOnWorkbenchCompleter)this.appWbCompleter).setWorkbenches(this.wbm.getWorkbenches());
        ((RGGCompleter)this.rggCompleter).setRGGCommands(this.selected.getFunctions());
    }

    public Completer setupCompleters() {
        this.sysFileCompleter = new SystemFileCompleter(this.workingDirectory);
        this.appCompleter = new ApplicationCompleter(this);
        this.appWbCompleter = new ApplicationOnWorkbenchCompleter(this);
        this.appFileCompleter = new ApplicationOnFileCompleter(this);
        this.workbenchCompleter = new WorkbenchCompleter(this);
        this.windowCompleter = new WindowCompleter(this);
        this.rggCompleter = new RGGCompleter(this);
        return new AggregateCompleter(new Completer[]{this.appCompleter, this.appWbCompleter, this.appFileCompleter, this.windowCompleter, this.workbenchCompleter, this.rggCompleter});
    }

    public void updateReader() {
        if (this.reader == null) {
            return;
        }
        ((LineReaderImpl)this.reader).setCompleter(this.readerCompleter);
    }

    public void setPROMPT(String s) {
        this.PROMPT = s;
    }

    public void setFileToEdit(File f, String n) {
        this.fileToEdit = f;
        this.fileToEdit_RealName = n;
    }

    public boolean canReadValue() {
        if (this.allowToWrite.tryLock()) {
            try {
                boolean bl = this.state == State.READ_VALUE;
                return bl;
            }
            finally {
                this.allowToWrite.unlock();
            }
        }
        return false;
    }

    private void runUIApp() {
        while (this.running) {
            try {
                this.getTerminalInput();
            }
            catch (UserInterruptException e) {
                this.exit();
            }
            catch (EndOfFileException e) {
                this.exit();
            }
            catch (Exception e) {
                System.out.println(e);
                this.println(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        CLIWorkbench w;
        if (!this.running) {
            return;
        }
        ArrayList arrayList = this.wbm.getWorkbenches();
        synchronized (arrayList) {
            if (this.wbm.listWorkbenches().size() == 0) {
                this.running = false;
                return;
            }
            w = (CLIWorkbench)this.getMainWorkbench();
        }
        w.getJobManager().execute(Workbench.CLOSE, (Object)new Command(){

            public void run(Object i, Context c) {
                CLIApplication.this.exit();
            }

            public String getCommandName() {
                return null;
            }
        }, (Context)w, 10000);
        this.running = false;
    }

    public Object getTerminalInput() throws UserInterruptException, EndOfFileException {
        return switch (this.state) {
            case State.READ_COMMAND -> this.consoleReadCommand();
            case State.READ_VALUE -> this.consoleReadValue();
            case State.READ_TEXTEDITOR -> this.consoleEditNano();
            case State.READ_XLCONSOLE -> this.consoleReadXLConsole();
            default -> null;
        };
    }

    private Object consoleReadValue() throws UserInterruptException, EndOfFileException {
        String line = null;
        line = this.reader.readLine(this.PROMPT);
        line = line.trim();
        return line;
    }

    private Object consoleReadCommand() throws UserInterruptException, EndOfFileException {
        String line = null;
        this.updatePrompt();
        line = this.reader.readLine(this.PROMPT);
        line = line.trim();
        Request r = this.parseRequest(line);
        this.handleRequest(r);
        return line;
    }

    private Object consoleEditNano() throws UserInterruptException, EndOfFileException {
        try {
            if (this.terminal.getType() == "dumb") {
                this.print(I18N.msg("error.nano.dumbterminal"));
                this.flush();
                return null;
            }
            Nano edit = new Nano(this.terminal, this.workingDirectory.toPath());
            System.out.println(this.fileToEdit.getAbsolutePath());
            edit.open(new String[]{this.fileToEdit.getAbsolutePath()});
            edit.run();
        }
        catch (IOException e) {
            this.print(I18N.msg("error.nano.filenotfound"));
        }
        return null;
    }

    private Object consoleReadXLConsole() {
        String line = "";
        this.setXlCompleter();
        CLIConsolePanel c = (CLIConsolePanel)PanelFactory.getAndShowPanel((Context)this.selected, (String)"/ui/panels/rgg/console", (Map)Map.EMPTY_MAP);
        while (!line.equals("exit")) {
            line = this.reader.readLine("XLCODE >");
            if ((line = line.trim()).equals("exit")) continue;
            c.enter(line + "\n");
        }
        this.setCLICompleter();
        return line;
    }

    public void startConsoleFileEditor() throws UserInterruptException, EndOfFileException {
        this.setState(State.READ_TEXTEDITOR);
        this.getTerminalInput();
    }

    private Request parseRequest(String query) {
        StringBuilder sb;
        Command c;
        int index_dot;
        ProjectWorkbench usedWB;
        String[] commandDirs;
        if (query.length() < 1) {
            return new Request();
        }
        boolean doLocklely = true;
        if (query.endsWith(String.valueOf('&'))) {
            doLocklely = false;
            query = query.substring(0, query.length() - 1);
            query.trim();
        }
        if (this.getPrefiexes((Workbench)this.getMainWorkbench()).contains(Character.valueOf(query.charAt(0)))) {
            commandDirs = this.getCommandDirs(query.charAt(0));
            usedWB = this.getUsedWB(query.charAt(0));
            query = query.substring(1);
        } else {
            commandDirs = WORKBENCHCOMMANDDIRS;
            usedWB = this.selected;
        }
        query = query.trim();
        if (query.length() == 0) {
            return new Request();
        }
        String[] splitted = query.split(" ");
        String command = splitted[0];
        String execution = "";
        LinkedList<Object> parameterqueue = new LinkedList();
        if (splitted.length > 1) {
            String[] parameters = Arrays.copyOfRange(splitted, 1, splitted.length);
            parameterqueue = new LinkedList<String>(Arrays.asList(parameters));
        }
        if ((index_dot = command.indexOf(58)) != -1) {
            execution = command.substring(index_dot + 1);
            command = command.substring(0, index_dot);
        }
        if ((c = this.getCommand(command, commandDirs, (Workbench)usedWB, sb = new StringBuilder())) == null) {
            this.println(I18N.msg("error.command.notfound"));
            this.flush();
            return new Request();
        }
        if (sb.length() > 0) {
            execution = sb.toString();
        }
        return new Request(query, c, commandDirs, execution, usedWB, parameterqueue, doLocklely);
    }

    private ArrayList<Character> getPrefiexes(Workbench wb) {
        ArrayList<Character> prefixes = new ArrayList<Character>();
        prefixes.add(Character.valueOf('$'));
        prefixes.add(Character.valueOf('%'));
        return prefixes;
    }

    private ProjectWorkbench getUsedWB(char prefix) {
        switch (prefix) {
            case '$': {
                return this.getMainWorkbench();
            }
            case '%': {
                return this.selected;
            }
        }
        return null;
    }

    private String[] getCommandDirs(char prefix) {
        switch (prefix) {
            case '$': {
                return APPCOMMANDDIRS;
            }
            case '%': {
                return WINDOWCOMMANDDIRS;
            }
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRequest(Request r) {
        if (r.command == null || r.query.isBlank()) {
            return false;
        }
        if (r.doLocklely) {
            this.allowToWrite.lock();
            try {
                this.setState(State.READ_VALUE);
                Workbench.setCurrent((Workbench)r.wb);
                Registry.setCurrent((RegistryContext)r.wb.getRegistry());
                if (r.command instanceof PanelFactory & r.panelExec.length() > 0) {
                    Panel p = r.wb.getWindow().getPanel(((Item)r.command).getAbsoluteName());
                    if (p == null) {
                        r.command.run((Object)Map.EMPTY_MAP, (Context)r.wb);
                        p = r.wb.getWindow().getPanel(((Item)r.command).getAbsoluteName());
                        if (p == null) {
                            this.println(I18N.msg("error.panel.notfound"));
                            this.flush();
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (p instanceof ExecutableComponent) {
                        ((ExecutableComponent)p).run(r.panelExec, r.paramqueue);
                        boolean bl = true;
                        return bl;
                    }
                    this.println(I18N.msg("error.panel.notcli"));
                    this.flush();
                    boolean bl = false;
                    return bl;
                }
                r.command.run(r.paramqueue, (Context)r.wb);
            }
            finally {
                this.updateCLICompleters();
                this.setState(State.READ_COMMAND);
                this.allowToWrite.unlock();
            }
            return true;
        }
        UI.executeLockedly((Lockable)r.wb.getRegistry().getProjectGraph(), (boolean)true, (Command)r.command, r.paramqueue, (Context)r.wb, (int)10000);
        return true;
    }

    private Command getCommand(String name, String[] baseDirs, Workbench wb, StringBuilder executionSB) {
        String cname;
        Item c = null;
        if (name.charAt(0) == '/') {
            c = Item.resolveItem((RegistryContext)wb.getRegistry(), (String)name);
        } else {
            for (String base : baseDirs) {
                c = Item.resolveItem((RegistryContext)wb.getRegistry(), (String)(base + "/" + name));
                if (c != null) break;
            }
        }
        if (c instanceof Command) {
            return (Command)c;
        }
        if (c instanceof StringConst && (cname = (String)((StringConst)c).evaluate((RegistryContext)c, null)) != null) {
            int index_dot = cname.indexOf(58);
            if (index_dot != -1) {
                String execution = cname.substring(index_dot + 1);
                executionSB.append(execution);
                cname = cname.substring(0, index_dot);
            }
            return (Command)Item.resolveItem((RegistryContext)wb, (String)cname);
        }
        return null;
    }

    public ProjectWorkbench open(Object info, Command afterCommand) {
        String path = Utils.getStringParameter(info, true);
        path = path == null ? null : Utils.getAbsolutePath((Context)this.getCurrentWorkbench(), path).toString();
        FileChooserResult fr = this.getToolkit().chooseFile(UI.I18N.getString("filedialog.openproject", "Open Project"), (FileFilter[])IO.getReadableFileTypes((IOFlavor[])new IOFlavor[]{IOFlavor.PROJECT_LOADER}), 0, true, null, (Context)this.selected, path);
        if (fr != null) {
            FileSource fs = fr.createFileSource(this.getRegistry(), null);
            try {
                ProjectWorkbench wb = this.open((FilterSource)fs, (ProjectFactory)new ProjectFactoryImpl(), null);
                if (afterCommand != null) {
                    try {
                        wb.execute((Object)afterCommand);
                    }
                    catch (Exception e) {
                        this.println("After command failed");
                    }
                }
                return wb;
            }
            catch (IOException e) {
                this.print(I18N.msg("error.workbench.projectnotfound"));
            }
        }
        return null;
    }

    public ProjectWorkbench open(Object info) {
        if (this.script) {
            this.executing = true;
        }
        return this.open(info, this.script ? this.WAIT_EXECUTION : null);
    }

    public ProjectWorkbench open(FilterSource fs, Map initParams) {
        try {
            return this.open(fs, (ProjectFactory)new ProjectFactoryImpl(), initParams);
        }
        catch (IOException e) {
            this.print(I18N.msg("error.workbench.projectnotfound"));
            return null;
        }
    }

    protected void selectWorkbench(Object info) {
        if (info instanceof Integer) {
            int id = (Integer)info;
            this.selectWorkbench(this.wbm.getWorkbench((Object)id));
        } else {
            try {
                int id = Utils.getintParameter(info);
                this.selectWorkbench(this.wbm.getWorkbench((Object)id));
            }
            catch (NullPointerException e) {
                this.println(I18N.msg("error.workbench.notindex"));
                this.listWorkbenches(info);
            }
            catch (IndexOutOfBoundsException e) {
                this.println(I18N.msg("error.workbench.index"));
                this.listWorkbenches(info);
            }
            catch (NumberFormatException e) {
                this.println(I18N.msg("error.workbench.notanumber"));
                this.listWorkbenches(info);
            }
        }
    }

    public void listWorkbenches(Object info) {
        HashMap workbenches = this.wbm.listWorkbenches();
        Object desc = "";
        Utils.consoleWrite((Context)this.selected, "ID: \tWorkbench Name \tStatus");
        for (Map.Entry e : workbenches.entrySet()) {
            desc = String.valueOf(e.getKey()) + " :\t" + ((Workbench)e.getValue()).getName() + "\t\t" + (String)(((Workbench)e.getValue()).getStatus() == null ? "Waiting" : ((Workbench)e.getValue()).getStatus() + "\t\t" + (String)(((Workbench)e.getValue()).getProgress() == null ? "Done" : ((Workbench)e.getValue()).getProgress().floatValue() * 100.0f + "%"));
            Utils.consoleWrite((Context)this.selected, desc);
        }
    }

    public void listProjects(Object info) {
        Utils.consoleWriteList((Context)this.selected, this.pm.listOpenProjects(), false);
    }

    public static void runXLConsole(Item item, Object info, Context ctx) {
        ((CLIApplication)ctx.getWorkbench().getApplication()).runXLConsole();
    }

    private void runXLConsole() {
        this.setState(State.READ_XLCONSOLE);
        String line = "";
        CLIConsolePanel c = (CLIConsolePanel)PanelFactory.getAndShowPanel((Context)this.selected, (String)"/ui/panels/rgg/console", (Map)Map.EMPTY_MAP);
        if (c == null) {
            this.println(I18N.msg("error.xlconsole.panelnotfound"));
            this.flush();
            return;
        }
        this.println(I18N.msg("xlconsole.exit.msg", (Object)"exit"));
        this.flush();
        this.getTerminalInput();
    }

    public void close(Object info) {
        System.out.println("todo");
    }

    public static void closeWB(Item item, Object info, Context ctx) {
        ((CLIApplication)ctx.getWorkbench().getApplication()).closeWB(info);
    }

    private void closeWB(Object info) {
        try {
            int id = Utils.getintParameter(info);
            this.wbm.closeWorkbench(this.wbm.getWorkbench((Object)id));
        }
        catch (NullPointerException e) {
            this.println(I18N.msg("error.workbench.notindex"));
            this.listWorkbenches(info);
        }
        catch (IndexOutOfBoundsException e) {
            this.println(I18N.msg("error.workbench.index"));
            this.listWorkbenches(info);
        }
        catch (NumberFormatException e) {
            this.println(I18N.msg("error.workbench.notanumber"));
            this.listWorkbenches(info);
        }
    }

    public void create(Object info, Command afterCommand) throws IOException {
        String name;
        try {
            name = Utils.getStringParameter(info, false);
        }
        catch (NullPointerException e) {
            name = "newRGG";
        }
        String newName = Utils.getStringParameter(info, true);
        Object id = this.create(name, newName);
        if (id == null) {
            this.println("Template not found");
            this.flush();
            return;
        }
        if (afterCommand != null) {
            try {
                this.wbm.getWorkbench(id).execute((Object)afterCommand);
            }
            catch (Exception e) {
                this.println("After command failed");
            }
        }
    }

    public void create(Object info) throws IOException {
        if (this.script) {
            this.executing = true;
        }
        this.create(info, this.script ? this.WAIT_EXECUTION : null);
    }

    public void loadExample(Object info, Command afterCommand) {
        try {
            String name = Utils.getStringParameter(info, false);
            String newName = Utils.getStringParameter(info, true);
            Object id = this.loadExample(name, newName);
            if (id == null) {
                this.println("Example not found");
                this.flush();
            } else if (afterCommand != null) {
                try {
                    this.wbm.getWorkbench(id).execute((Object)afterCommand);
                }
                catch (Exception e) {
                    this.println("After command failed");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadExample(Object info) {
        if (this.script) {
            this.executing = true;
        }
        this.loadExample(info, this.script ? this.WAIT_EXECUTION : null);
    }

    public void listExamples(Object info) {
        this.listFilterSourceFactorys(info, "/examples");
    }

    public void listTemplates(Object info) {
        this.listFilterSourceFactorys(info, "/ui/templates");
    }

    private void listFilterSourceFactorys(Object info, String path) {
        Item[] files;
        String name = Utils.getStringParameter(info, true);
        Item fileDir = Item.resolveItem((RegistryContext)this.selected.getRegistry().getRootRegistry(), (String)path);
        for (Item f : files = Item.findAll((Item)fileDir, (ItemCriterion)ItemCriterion.INSTANCE_OF, ProjectDirectory.class, (boolean)true)) {
            if (name != null && !f.getName().toLowerCase().contains(name.toLowerCase()) && !f.getDescription("Name").toString().toLowerCase().contains(name.toLowerCase()) && !f.getDescription("ShortDescription").toString().toLowerCase().contains(name.toLowerCase())) continue;
            String part = "[" + f.getName() + "]: " + f.getDescription("Name") + "\n";
            part = part + f.getDescription("ShortDescription");
            part = part + "\n";
            this.println(part);
        }
        this.flush();
    }

    public void stop() {
        System.out.println("todo");
    }

    public Completer getSysFileCompleter() {
        return this.sysFileCompleter;
    }

    public static void runScript(Item item, Object info, Context ctx) {
        ((CLIApplication)ctx.getWorkbench().getApplication()).runScript(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runScript(Object info) {
        this.script = true;
        try {
            CLIWorkbench wb;
            String scriptPath = Utils.getStringParameter(info, false);
            String workbenchId = Utils.getStringParameter(info, true);
            if (workbenchId == null) {
                wb = (CLIWorkbench)this.selected;
            } else {
                try {
                    wb = (CLIWorkbench)this.wbm.getWorkbench((Object)Integer.valueOf(workbenchId));
                }
                catch (Exception e) {
                    this.print(I18N.msg("error.workbench.projectnotfound"));
                    return;
                }
            }
            CLIWorkbench compiledwb = wb;
            scriptPath = Utils.getAbsolutePath((Context)this.getCurrentWorkbench(), scriptPath).toString();
            FileSource fs = new FileSource(new File(scriptPath), MimeType.TEXT_PLAIN, this.getRegistry(), null);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(fs.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    Object object = this.getExecutionLock();
                    synchronized (object) {
                        if (this.isExecuting()) {
                            try {
                                this.getExecutionLock().wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        Object e = compiledwb.getCompilationLock();
                        synchronized (e) {
                            if (compiledwb.isCompiling()) {
                                Object object2 = compiledwb.getCompilationLock();
                                synchronized (object2) {
                                    try {
                                        compiledwb.getCompilationLock().wait();
                                    }
                                    catch (InterruptedException e2) {
                                        e2.printStackTrace();
                                    }
                                }
                            }
                        }
                        Request r = this.parseRequest(line);
                        this.println("dispatched : " + line + " on " + r.wb);
                        this.flush();
                        r.doLocklely = r.wb == this.getMainWorkbench();
                        if (r.query.trim().equals("compile")) {
                            r.doLocklely = true;
                            compiledwb = (CLIWorkbench)r.wb;
                        }
                        this.handleRequest(r);
                    }
                }
            }
            this.println("Script completely dispatched.");
        }
        catch (IOException e) {
            this.print("File cannot be read");
            this.flush();
        }
        catch (NullPointerException e) {
            this.print("Enter a file path");
            this.flush();
        }
        this.script = false;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public Object getExecutionLock() {
        return this.EXECUTING_LOCK;
    }

    static {
        I18N = I18NBundle.getInstance(CLIApplication.class);
        APPCOMMANDDIRS = new String[]{"/ui/commands/app"};
        WINDOWCOMMANDDIRS = new String[]{"/ui/commands/window", "/ui/panels"};
        WORKBENCHCOMMANDDIRS = new String[]{"/ui/commands", "/workbench/rgg/methods"};
    }

    public static enum State {
        READ_COMMAND,
        READ_VALUE,
        READ_TEXTEDITOR,
        READ_XLCONSOLE;

    }

    class Request {
        String query;
        Command command;
        String[] baseDirs;
        String panelExec;
        Queue<Object> paramqueue;
        ProjectWorkbench wb;
        boolean doLocklely;

        public Request(String query, Command cmd, String[] commandDirs, String panelExec, ProjectWorkbench usedWB, Queue<Object> paramqueue, boolean doLocklely) {
            this.query = query;
            this.command = cmd;
            this.baseDirs = commandDirs;
            this.panelExec = panelExec;
            this.wb = usedWB;
            this.paramqueue = paramqueue;
            this.doLocklely = doLocklely;
        }

        public Request() {
            this.query = "";
            this.command = null;
            this.panelExec = "";
            this.baseDirs = new String[0];
            this.wb = CLIApplication.this.getMainWorkbench();
            this.doLocklely = false;
        }
    }
}

