/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.spatialpartition;

import de.grogra.graph.VisitorImpl;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.advancedselection.aggregation.AggregationNode;
import de.grogra.imp3d.advancedselection.selection.Selection;
import de.grogra.imp3d.advancedselection.selection.impl.ParentNTypeSelection;
import de.grogra.util.I18NBundle;
import java.util.ArrayList;
import java.util.List;

public abstract class SpatialPartition
extends VisitorImpl {
    protected Selection selection = null;
    protected AggregationNode aggNode = null;
    public static final I18NBundle I18N = I18NBundle.getInstance(SpatialPartition.class);
    protected static final double epsilon = 1.0E-9;
    protected static List<SpatialPartition> partitionList = new ArrayList<SpatialPartition>();

    public abstract void createAllSpatialPartition();

    public void addSpatialPartition(SpatialPartition sp) {
        if (partitionList.contains((Object)sp)) {
            return;
        }
        partitionList.add(sp);
    }

    public List<Node> getAggregatedNodes(Object obj) {
        ParentNTypeSelection sel = new ParentNTypeSelection(AggregationNode.$TYPE);
        return sel.getSelectedNodes();
    }

    public abstract void selection();

    public void setSelection(Selection sel) {
        this.selection = sel;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public AggregationNode getAggregation() {
        return this.aggNode;
    }

    public void setAggregation(AggregationNode aggNode) {
        this.aggNode = aggNode;
    }

    public List<SpatialPartition> getPartitionList() {
        return partitionList;
    }

    public void aggregate() {
        for (SpatialPartition sp : partitionList) {
            List<Node> aggregationChildren = sp.getSelection().getSelectedNodes();
            if (aggregationChildren.isEmpty()) continue;
            sp.aggNode = new AggregationNode();
            for (Node node : aggregationChildren) {
                sp.getAggregation().addEdgeBitsTo(node, 4096, null);
            }
        }
    }

    public void dispose() {
        this.selection = null;
        this.aggNode = null;
        partitionList.clear();
    }
}

