/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.spatialpartition;

import de.grogra.imp3d.advancedselection.objects.Interval;
import de.grogra.imp3d.advancedselection.objects.SceneBoundaries;
import de.grogra.imp3d.advancedselection.selection.impl.RectangleIntervalSelection;
import de.grogra.imp3d.advancedselection.spatialpartition.SpatialPartition;
import java.util.ArrayList;
import java.util.List;

public class RectangleSpatialPartition
extends SpatialPartition {
    protected Interval x;
    protected Interval y;
    protected Interval z;
    protected double size;
    protected SceneBoundaries boundaries;
    List<Interval> IntervalsX = new ArrayList<Interval>();
    List<Interval> IntervalsY = new ArrayList<Interval>();
    List<Interval> IntervalsZ = new ArrayList<Interval>();

    public RectangleSpatialPartition() {
    }

    public RectangleSpatialPartition(SceneBoundaries boundaries, double size) {
        this.size = size;
        this.boundaries = boundaries;
    }

    public RectangleSpatialPartition(Interval x, Interval y, Interval z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void createAllSpatialPartition() {
        for (double width = this.boundaries.getMinX(); width <= this.boundaries.getMaxX(); width += this.size) {
            for (double length = this.boundaries.getMinY(); length <= this.boundaries.getMaxY(); length += this.size) {
                for (double height = this.boundaries.getMinZ(); height <= this.boundaries.getMaxZ(); height += this.size) {
                    Interval intvlX = new Interval(width, width + this.size, 1);
                    Interval intvlY = new Interval(length, length + this.size, 2);
                    Interval intvlZ = new Interval(height, height + this.size, 4);
                    RectangleSpatialPartition rsp = new RectangleSpatialPartition(intvlX, intvlY, intvlZ);
                    partitionList.add(rsp);
                }
            }
        }
    }

    @Override
    public void selection() {
        for (SpatialPartition sp : partitionList) {
            Interval a = ((RectangleSpatialPartition)sp).x;
            Interval b = ((RectangleSpatialPartition)sp).y;
            Interval c = ((RectangleSpatialPartition)sp).z;
            this.selection = new RectangleIntervalSelection(a, b, c);
            sp.setSelection(this.selection);
        }
    }

    public Interval getIntervalX() {
        return this.x;
    }

    public Interval getIntervalY() {
        return this.y;
    }

    public Interval getIntervalZ() {
        return this.z;
    }
}

