/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.spatialpartition;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.advancedselection.objects.Interval;
import de.grogra.imp3d.advancedselection.objects.SceneBoundaries;
import de.grogra.imp3d.advancedselection.selection.impl.AxisIntervalSelection;
import de.grogra.imp3d.advancedselection.spatialpartition.SpatialPartition;
import java.util.ArrayList;
import java.util.List;

public class PlaneSpatialPartition
extends SpatialPartition {
    protected double size;
    protected double translation = 0.0;
    protected SceneBoundaries boundaries;
    protected Interval interval = new Interval();
    protected List<Node> selected = new ArrayList<Node>();

    public PlaneSpatialPartition() {
    }

    public PlaneSpatialPartition(double size, int axisMask) {
        this.interval.setAxisMask(axisMask);
        this.size = size;
    }

    public PlaneSpatialPartition(double size, double translation, int axisMask) {
        this(size, axisMask);
        this.translation = translation;
    }

    public PlaneSpatialPartition(SceneBoundaries boundaries, double size, double translation, int axisMask) {
        this(size, translation, axisMask);
        this.boundaries = boundaries;
    }

    public PlaneSpatialPartition(Interval interval) {
        this.interval = interval;
    }

    @Override
    public void createAllSpatialPartition() {
        double distance;
        if (this.interval.getAxisMask() == 1) {
            for (distance = this.translation; distance <= this.boundaries.getMaxX(); distance += this.size) {
                this.createPlaneSpatialPartition(distance, this.size, this.interval.getAxisMask());
            }
            for (distance = this.translation - this.size; distance > this.boundaries.getMinX() - this.size; distance -= this.size) {
                this.createPlaneSpatialPartition(distance, this.size, this.interval.getAxisMask());
            }
        }
        if (this.interval.getAxisMask() == 2) {
            for (distance = this.translation; distance <= this.boundaries.getMaxY(); distance += this.size) {
                this.createPlaneSpatialPartition(distance, this.size, this.interval.getAxisMask());
            }
            for (distance = this.translation - this.size; distance > this.boundaries.getMinY() - this.size; distance -= this.size) {
                this.createPlaneSpatialPartition(distance, this.size, this.interval.getAxisMask());
            }
        }
        if (this.interval.getAxisMask() == 4) {
            for (distance = this.translation; distance <= this.boundaries.getMaxZ(); distance += this.size) {
                this.createPlaneSpatialPartition(distance, this.size, this.interval.getAxisMask());
            }
            for (distance = this.translation - this.size; distance > this.boundaries.getMinZ() - this.size; distance -= this.size) {
                this.createPlaneSpatialPartition(distance, this.size, this.interval.getAxisMask());
            }
        }
    }

    private void createPlaneSpatialPartition(double translation, double size, int axisMask) {
        double start = translation;
        double end = translation + size;
        Interval intvl = new Interval(start, end, this.interval.getAxisMask());
        PlaneSpatialPartition partition = new PlaneSpatialPartition(intvl);
        this.addSpatialPartition(partition);
    }

    @Override
    public void selection() {
        for (SpatialPartition sp : partitionList) {
            Interval a = ((PlaneSpatialPartition)sp).getInterval();
            this.selection = new AxisIntervalSelection(a);
            sp.setSelection(this.selection);
        }
    }

    public void setBoundaries(SceneBoundaries boundaries) {
        this.boundaries = boundaries;
    }

    protected void setInterval(double start, double end) {
        this.interval.setStart(start);
        this.interval.setEnd(end);
    }

    public Interval getInterval() {
        return this.interval;
    }
}

