/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.spatialpartition;

import de.grogra.imp3d.advancedselection.objects.Interval;
import de.grogra.imp3d.advancedselection.selection.impl.AngleSelection;
import de.grogra.imp3d.advancedselection.spatialpartition.SpatialPartition;

public class DegreeSpatialPartition
extends SpatialPartition {
    Interval angle;
    int nPartitions;

    public DegreeSpatialPartition() {
        this.angle = null;
    }

    public DegreeSpatialPartition(int nPartitions, int axisMask) {
        this.nPartitions = nPartitions;
        this.angle = new Interval(0.0, 0.0, axisMask);
        this.addSpatialPartition(this);
    }

    public DegreeSpatialPartition(double startAngle, double endAngle, int axisMask) {
        this.angle = new Interval(startAngle, endAngle, axisMask);
    }

    public DegreeSpatialPartition(Interval angle) {
        this.angle = angle;
    }

    public Interval getAngle() {
        return this.angle;
    }

    @Override
    public void createAllSpatialPartition() {
        double degreeSpan = 360 / this.nPartitions;
        for (int i = 0; i < this.nPartitions; ++i) {
            double startAngle = degreeSpan * (double)i;
            double endAngle = degreeSpan * (double)(i + 1) - 1.0E-9;
            DegreeSpatialPartition dsp = new DegreeSpatialPartition(startAngle, endAngle, this.getAngle().getAxisMask());
            this.addSpatialPartition(dsp);
        }
    }

    @Override
    public void selection() {
        for (SpatialPartition sp : partitionList) {
            Interval a = ((DegreeSpatialPartition)sp).getAngle();
            this.selection = new AngleSelection(a, false);
            sp.setSelection(this.selection);
        }
        DegreeSpatialPartition spZero = (DegreeSpatialPartition)((Object)partitionList.get(0));
        spZero.setSelection(new AngleSelection(spZero.getAngle(), true));
    }

    public Interval getInterval() {
        return this.angle;
    }
}

