/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.selection.impl;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.advancedselection.selection.Selection;
import de.grogra.imp3d.objects.Plane;
import de.grogra.rgg.Library;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PlaneSelection
extends Selection {
    private boolean over;

    public PlaneSelection(Object obj, boolean isOver) {
        if (!(obj instanceof Plane)) {
            return;
        }
        this.obj = obj;
        this.over = isOver;
    }

    @Override
    protected boolean acceptImpl(Node node) {
        return this.isEdgeOverOrUnderPlane((Plane)this.obj, node, this.over);
    }

    public boolean isEdgeOverOrUnderPlane(Plane plane, Node edge, boolean selectOver) {
        if (!(edge instanceof Node)) {
            return false;
        }
        Matrix4d matrix = plane.getLocalTransformation();
        Vector3d position = plane.getTranslation();
        Vector3d normal = new Vector3d(matrix.m02, matrix.m12, matrix.m22);
        Point3d point = Library.location((Node)edge);
        position.sub((Tuple3d)point);
        return selectOver ? position.dot(normal) < 0.0 : position.dot(normal) > 0.0;
    }
}

