/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.selection.impl;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.advancedselection.objects.Interval;
import de.grogra.imp3d.advancedselection.selection.Selection;
import de.grogra.imp3d.advancedselection.selection.Utils;
import de.grogra.rgg.Library;
import javax.vecmath.Point3d;

public class AngleSelection
extends Selection {
    private boolean includeNodeOnZero;

    public AngleSelection(Object obj, boolean includeNodeOnZero) {
        if (!(obj instanceof Interval)) {
            return;
        }
        this.obj = obj;
        this.includeNodeOnZero = includeNodeOnZero;
    }

    @Override
    protected boolean acceptImpl(Node node) {
        return this.isInAngle(node, (Interval)this.obj, this.includeNodeOnZero);
    }

    public boolean isInAngle(Node edge, Interval myAngle, boolean includeNodeOnZero) {
        if (!(edge instanceof Node)) {
            return false;
        }
        Point3d point = Library.location((Node)edge);
        double x = point.x;
        double y = point.y;
        double z = point.z;
        double start = myAngle.getStart();
        double end = myAngle.getEnd();
        boolean inOrigin = false;
        double angle = Utils.radToDeg(Math.atan2(point.y, point.x));
        int axisMask = myAngle.getAxisMask();
        if (axisMask == 1) {
            boolean bl = inOrigin = Utils.polarRadius(y, z) == 0.0;
            if (includeNodeOnZero && inOrigin) {
                return true;
            }
            if (!includeNodeOnZero && inOrigin) {
                return false;
            }
        } else if (axisMask == 2) {
            boolean bl = inOrigin = Utils.polarRadius(x, z) == 0.0;
            if (includeNodeOnZero && inOrigin) {
                return true;
            }
            if (!includeNodeOnZero && inOrigin) {
                return false;
            }
        } else if (axisMask == 4) {
            boolean bl = inOrigin = Utils.polarRadius(x, y) == 0.0;
            if (includeNodeOnZero && inOrigin) {
                return true;
            }
            if (!includeNodeOnZero && inOrigin) {
                return false;
            }
        }
        if (start == 0.0 && end == 0.0 && !inOrigin) {
            return false;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return start <= angle && angle <= end;
    }
}

