/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.selection;

import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.advancedselection.selection.Selection;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.edit.GraphSelection;
import java.util.ArrayList;
import java.util.List;

public class SelectionTools {
    public static Node getSelectedNode(Context c) {
        Object s = UIProperty.WORKBENCH_SELECTION.getValue((Context)c.getWorkbench());
        if (!(s instanceof GraphSelection) || ((GraphSelection)s).size() < 1) {
            return null;
        }
        Object n = ((GraphSelection)s).getObject(0);
        if (!(n instanceof Node)) {
            return null;
        }
        return (Node)n;
    }

    public static List<Node> getSelectedNodes(Context c) {
        Object s = UIProperty.WORKBENCH_SELECTION.getValue((Context)c.getWorkbench());
        if (!(s instanceof GraphSelection) || ((GraphSelection)s).size() < 1) {
            return null;
        }
        ArrayList<Node> l = new ArrayList<Node>();
        for (int i = 0; i < ((GraphSelection)s).size(); ++i) {
            Object n = ((GraphSelection)s).getObject(i);
            if (!(n instanceof Node)) continue;
            l.add((Node)n);
        }
        return l.isEmpty() ? null : l;
    }

    public static List<Node> innitializeSelection(Selection sel, Context c) {
        GraphManager g = c.getWorkbench().getRegistry().getProjectGraph();
        Node root = (Node)g.getRoot("MainGraph");
        sel.init(root.getCurrentGraphState(), (EdgePattern)EdgePatternImpl.TREE);
        g.accept((Object)root, (Visitor)sel, null);
        return sel.getSelectedNodes();
    }

    public static void select(List<Node> toSelect, Context c) {
        c.getWorkbench().select(toSelect.toArray(new Node[0]));
    }

    public static void deleteNodes(List<Node> nodesToDelete, Context context) {
        Node[] nodeArray = new Node[nodesToDelete.size()];
        nodesToDelete.toArray(nodeArray);
        context.getWorkbench().delete((Object)nodeArray);
    }
}

