/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.selection;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.advancedselection.aggregation.AggregationNode;
import de.grogra.imp3d.advancedselection.dialogs.DialogTool;
import de.grogra.imp3d.advancedselection.dialogs.InputDialogDegreeSelection;
import de.grogra.imp3d.advancedselection.dialogs.InputDialogNType;
import de.grogra.imp3d.advancedselection.objects.Interval;
import de.grogra.imp3d.advancedselection.selection.InputDialogAxisIntervalSelection;
import de.grogra.imp3d.advancedselection.selection.Selection;
import de.grogra.imp3d.advancedselection.selection.SelectionTools;
import de.grogra.imp3d.advancedselection.selection.impl.AncestorSelection;
import de.grogra.imp3d.advancedselection.selection.impl.AngleSelection;
import de.grogra.imp3d.advancedselection.selection.impl.AxisIntervalSelection;
import de.grogra.imp3d.advancedselection.selection.impl.NTypeSelection;
import de.grogra.imp3d.advancedselection.selection.impl.ParentNTypeSelection;
import de.grogra.imp3d.advancedselection.selection.impl.PlaneSelection;
import de.grogra.imp3d.advancedselection.selection.impl.VolumeSelection;
import de.grogra.imp3d.advancedselection.selection.impl.selectedNodesSelection;
import de.grogra.pf.registry.Item;
import de.grogra.pf.ui.Context;

public class Commands {
    public static void selectByAncestor(Item item, Object info, Context context) {
        Node n = SelectionTools.getSelectedNode(context);
        AncestorSelection sel = new AncestorSelection(n);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, context), context);
        context.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_ancestor_done"));
    }

    public static void selectByPrimitiveVolume(Item item, Object info, Context ctx) {
        Node n = SelectionTools.getSelectedNode(ctx);
        if (n == null) {
            boolean exeption = DialogTool.handleException("errorPrimitive", "labelErrorPrimitive");
            return;
        }
        VolumeSelection sel = new VolumeSelection(n);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, ctx), ctx);
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_volumetric_object_done"));
    }

    public static void selectByPlaneOver(Item item, Object info, Context ctx) {
        Node n = SelectionTools.getSelectedNode(ctx);
        PlaneSelection sel = new PlaneSelection(n, true);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, ctx), ctx);
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_plane_over_done"));
    }

    public static void selectByPlaneUnder(Item item, Object info, Context ctx) {
        Node n = SelectionTools.getSelectedNode(ctx);
        PlaneSelection sel = new PlaneSelection(n, false);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, ctx), ctx);
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_plane_under_done"));
    }

    public static void selectAggregationChildren(Item item, Object info, Context ctx) {
        ParentNTypeSelection sel = new ParentNTypeSelection(AggregationNode.$TYPE);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, ctx), ctx);
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_children_of_aggregation_done"));
    }

    public static void selectByAxisInterval(Item item, Object info, Context ctx) {
        InputDialogAxisIntervalSelection inputPanel = new InputDialogAxisIntervalSelection();
        if (!inputPanel.getInput()) {
            System.err.println("Input Panel for axial Interval Selection has failed");
            return;
        }
        int axisMask = inputPanel.getAxisMask();
        double start = inputPanel.getStart();
        double end = inputPanel.getEnd();
        Interval intvl = new Interval(start, end, axisMask);
        System.err.println("Interval: [" + intvl.getStart() + ", " + intvl.getEnd() + "] axisMask: " + intvl.getAxisMask());
        AxisIntervalSelection sel = new AxisIntervalSelection(intvl);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, ctx), ctx);
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_degree_done"));
    }

    public static void selectByDegreeInterval(Item item, Object info, Context context) {
        InputDialogDegreeSelection inputPanel = new InputDialogDegreeSelection();
        if (!inputPanel.getInput()) {
            System.err.println("Input Panel for Degree Selection has failed");
            return;
        }
        double startAngle = inputPanel.getStartAngle();
        double endAngle = inputPanel.getEndAngle();
        boolean includeZeroRadiusNode = inputPanel.isZeroRadiusNodeIncluded();
        int axisMask = inputPanel.getAxisMask();
        Interval angle = new Interval(startAngle, endAngle, axisMask);
        AngleSelection sel = new AngleSelection(angle, includeZeroRadiusNode);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, context), context);
        context.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_degree_done"));
    }

    public static void deleteSelectedNodes(Item item, Object info, Context context) {
        selectedNodesSelection sel = new selectedNodesSelection();
        SelectionTools.select(SelectionTools.innitializeSelection(sel, context), context);
        SelectionTools.deleteNodes(sel.getSelectedNodes(), context);
    }

    public static void selectByNType(Item item, Object info, Context context) {
        InputDialogNType inputPanel = new InputDialogNType();
        if (!inputPanel.getInput()) {
            System.err.println("Input Panel for NType has failed");
            return;
        }
        String ntype = inputPanel.getNType();
        NTypeSelection sel = new NTypeSelection(ntype);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, context), context);
        context.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_NType_done"));
    }

    public static void selectByParentNType(Item item, Object info, Context context) {
        InputDialogNType inputPanel = new InputDialogNType();
        if (!inputPanel.getInput()) {
            System.err.println("Input Panel for ParentNType has failed");
            return;
        }
        String ntype = inputPanel.getNType();
        ParentNTypeSelection sel = new ParentNTypeSelection(ntype);
        SelectionTools.select(SelectionTools.innitializeSelection(sel, context), context);
        context.getWorkbench().logGUIInfo(Selection.I18N.msg("selection_ParentNType_done"));
    }
}

