/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.objects;

import de.grogra.graph.Path;
import de.grogra.graph.VisitorImpl;
import de.grogra.graph.impl.Node;
import de.grogra.rgg.Library;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;

public class SceneBoundaries
extends VisitorImpl {
    List<Point3d> nodePositions = new ArrayList<Point3d>();
    List<Node> nodes = new ArrayList<Node>();
    double epsilon = 1.0E-12;
    protected double minX = 2.147483647E9;
    protected double maxX = -2.147483648E9;
    protected double minY = 2.147483647E9;
    protected double maxY = -2.147483648E9;
    protected double minZ = 2.147483647E9;
    protected double maxZ = -2.147483648E9;

    public Object visitEnter(Path path, boolean isNode) {
        if (!isNode) {
            return null;
        }
        Node node = (Node)path.getObject(-1);
        Point3d point = Library.location((Node)node);
        this.nodes.add(node);
        this.nodePositions.add(point);
        if (point.x < this.minX) {
            this.minX = point.x - this.epsilon;
        }
        if (point.x > this.maxX) {
            this.maxX = point.x + this.epsilon;
        }
        if (point.y < this.minY) {
            this.minY = point.y - this.epsilon;
        }
        if (point.y > this.maxY) {
            this.maxY = point.y + this.epsilon;
        }
        if (point.z < this.minZ) {
            this.minZ = point.z - this.epsilon;
        }
        if (point.z > this.maxZ) {
            this.maxZ = point.z + this.epsilon;
        }
        return null;
    }

    public Object visitInstanceEnter() {
        return STOP;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxZ() {
        return this.maxZ;
    }
}

