/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.navigation;

import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.impl.Node;
import de.grogra.imp.PickElement;
import de.grogra.imp.PickList;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp.viewhandler.HighlighterImpl;
import de.grogra.imp.viewhandler.ViewEventHandler;
import de.grogra.pf.ui.Context;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;

public class DepthNavigation {
    private List<PickElement> storedPicks;
    private PickElement currentPick = null;
    private ViewEventHandler vHandler;
    private ViewSelection vSelection;
    private PickList currentPickList = new PickList(10, true);
    private HighlighterImpl hlighter;

    public DepthNavigation(ViewEventHandler vHandler, MouseEvent me) {
        this.vHandler = vHandler;
        this.hlighter = (HighlighterImpl)this.vHandler.getViewEventFactory().getHighlighter();
        this.vSelection = ViewSelection.get((Context)this.vHandler.getView());
        this.storedPicks = new ArrayList<PickElement>();
        this.updatePicks(me);
    }

    protected void selectStoredPicks() {
        if (this.storedPicks == null) {
            return;
        }
        Node[] nodes = new Node[this.storedPicks.size()];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = (Node)this.storedPicks.get(i).getPath().getObject(-1);
        }
        this.vHandler.getView().getWorkbench().select(nodes);
        this.hlighter.highlight(this.currentPickList, this.getIndexOfCurrentPickInPickList(), null);
    }

    void selectCurrentPick() {
        if (this.currentPick == null) {
            return;
        }
        this.vSelection.add(4, this.currentPick.getPath());
    }

    void selectedPickToMouseOver() {
        if (this.currentPick == null) {
            return;
        }
        this.vSelection.removeAndAdd(4, 1, this.currentPick.getPath());
    }

    void resetPick() {
        if (this.currentPick == null) {
            return;
        }
    }

    void storeCurrentPick() {
        if (this.currentPick == null) {
            return;
        }
        if (!this.storedPicks.contains(this.currentPick)) {
            this.storedPicks.add(this.currentPick);
        }
        this.selectCurrentPick();
    }

    void discardCurrentPick() {
        if (this.currentPick == null) {
            return;
        }
        this.storedPicks.remove(this.currentPick);
        this.selectedPickToMouseOver();
    }

    void updatePicks(MouseEvent e) {
        this.hlighter.resetHighlight();
        if (!(e instanceof MouseEvent)) {
            return;
        }
        MouseEvent me = e;
        if (this.vHandler == null) {
            return;
        }
        this.vHandler.pick(me.getX(), me.getY(), this.currentPickList);
        this.hlighter.highlight(this.currentPickList, this.getIndexOfCurrentPickInPickList(), null);
    }

    void selectNextEntry(MouseWheelEvent wheelEvent) {
        this.updatePicks(wheelEvent);
        if (this.currentPickList.getSize() == 0) {
            this.resetPick();
            return;
        }
        this.selectedPickToMouseOver();
        if (!this.isPickInPickList()) {
            if (this.currentPick == null) {
                this.currentPick = new PickElement();
            }
            this.hlighter.resetHighlight();
            this.currentPickList.getItem(0, this.currentPick);
            this.selectCurrentPick();
            return;
        }
        if (this.isPickInPickList()) {
            int index = this.getIndexOfCurrentPickInPickList();
            if (index == -1) {
                return;
            }
            int moeLength = this.currentPickList.getSize();
            int next = (index - wheelEvent.getWheelRotation() + moeLength) % moeLength;
            this.currentPickList.getItem(next, this.currentPick);
        } else {
            this.currentPickList.getItem(0, this.currentPick);
        }
        this.selectCurrentPick();
    }

    private boolean isPickInPickList() {
        if (this.currentPick == null || this.currentPickList == null || this.currentPickList.getSize() == 0) {
            return false;
        }
        for (int i = 0; i < this.currentPickList.getSize(); ++i) {
            if (!GraphUtils.equal((Path)this.currentPick.getPath(), (Path)this.currentPickList.getPath(i))) continue;
            return true;
        }
        return false;
    }

    private int getIndexOfCurrentPickInPickList() {
        if (this.currentPickList == null || this.currentPickList.getSize() == 0) {
            return -1;
        }
        if (this.currentPick == null) {
            this.currentPick = new PickElement();
            this.currentPickList.getItem(0, this.currentPick);
        }
        for (int i = 0; i < this.currentPickList.getSize(); ++i) {
            if (!GraphUtils.equal((Path)this.currentPick.getPath(), (Path)this.currentPickList.getPath(i))) continue;
            return i;
        }
        return -1;
    }
}

