/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.dialogs;

import de.grogra.imp3d.advancedselection.dialogs.DialogTool;
import de.grogra.util.I18NBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputDialogVoxelSpatialPartition {
    public static final I18NBundle I18N = I18NBundle.getInstance(DialogTool.class);
    static double distance;
    JLabel label;
    JTextField distanceField;
    JPanel panel;
    ButtonGroup group;
    String title;

    public InputDialogVoxelSpatialPartition() {
        distance = -1.0;
        this.label = new JLabel(I18N.getString("voxelSectorLabel"));
        this.distanceField = new JTextField(5);
        this.panel = new JPanel();
        this.group = new ButtonGroup();
        this.title = I18N.getString("voxelSectorTitle");
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 5, 20);
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.panel.add((Component)this.label, gbc);
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.panel.add((Component)new JLabel(" "), gbc);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.panel.add((Component)new JLabel(I18N.getString("voxelSectorDistance")), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.panel.add((Component)this.distanceField, gbc);
    }

    public boolean getInput() {
        boolean success = DialogTool.showInputDialog("inputTitle", this.panel);
        if (!success) {
            return success;
        }
        try {
            distance = Double.parseDouble(this.distanceField.getText());
            if (distance <= 0.0) {
                DialogTool.handleException("errorInvalidNumberValue", "labelInvalidNumberValue");
            }
        }
        catch (NumberFormatException nfe) {
            return DialogTool.handleException("errorDataType", "labelErrorDataType");
        }
        return success;
    }

    public double getDistance() {
        return distance;
    }
}

