/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.dialogs;

import de.grogra.imp3d.advancedselection.dialogs.DialogTool;
import de.grogra.util.I18NBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputDialogIntervalSpatialPartition {
    public static final I18NBundle I18N = I18NBundle.getInstance(DialogTool.class);
    static double size;
    static double translation;
    String[] choicesAxis = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    int axisMask;
    JComboBox axisSelection = new JComboBox<String>(this.choicesAxis);
    JLabel label;
    JTextField sizeField;
    JTextField translationField;
    JPanel panel;
    String title;

    public InputDialogIntervalSpatialPartition() {
        size = -1.0;
        translation = 0.0;
        this.axisMask = -1;
        this.label = new JLabel(I18N.getString("planeSpatialLabel"));
        this.sizeField = new JTextField(5);
        this.translationField = new JTextField(5);
        this.panel = new JPanel();
        this.title = I18N.getString("planeSpatialTitle");
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 5, 20);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.panel.add((Component)this.label, gbc);
        gbc.gridwidth = 3;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.panel.add((Component)new JLabel(" "), gbc);
        gbc.gridwidth = 2;
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.panel.add(this.axisSelection);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.panel.add((Component)new JLabel(I18N.getString("planeSpatialSize")), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.panel.add((Component)this.sizeField, gbc);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.panel.add((Component)new JLabel(I18N.getString("planeSpatialTranslation")), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.panel.add((Component)this.translationField, gbc);
    }

    public boolean getInput() {
        boolean success = DialogTool.showInputDialog("inputTitle", this.panel);
        if (!success) {
            return success;
        }
        try {
            size = Double.parseDouble(this.sizeField.getText());
            if (size <= 0.0) {
                DialogTool.handleException("errorInvalidNumberValue", "labelInvalidNumberValue");
            }
            translation = Double.parseDouble(this.translationField.getText());
        }
        catch (NumberFormatException nfe) {
            return DialogTool.handleException("errorDataType", "labelErrorDataType");
        }
        String axisString = (String)this.axisSelection.getSelectedItem();
        if (axisString.equals("X-Axis")) {
            this.axisMask = 1;
        } else if (axisString.equals("Y-Axis")) {
            this.axisMask = 2;
        } else if (axisString.equals("Z-Axis")) {
            this.axisMask = 4;
        } else {
            System.err.println(axisString);
            return DialogTool.handleException("errorAxisSelection", DialogTool.I18N.getString("labelErrorAxisSelection"));
        }
        return success;
    }

    public double getRange() {
        return size;
    }

    public double getTranslation() {
        return translation;
    }

    public int getAxisMask() {
        return this.axisMask;
    }
}

