/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.dialogs;

import de.grogra.imp3d.advancedselection.dialogs.DialogTool;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputDialogDegreeSelection {
    double startAngle;
    double endAngle;
    boolean zeroRadiusNodeIncluded = false;
    String[] choicesAxis = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    int axisMask;
    JPanel panel = new JPanel();
    JTextField startAngleField = new JTextField(5);
    JTextField endAngleField = new JTextField(5);
    JCheckBox checkBox = new JCheckBox(DialogTool.I18N.getString("degreeSelectionCheckbox"));
    JComboBox axisSelection = new JComboBox<String>(this.choicesAxis);

    public InputDialogDegreeSelection() {
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 5, 20);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.panel.add((Component)new JLabel("start angle:"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.panel.add((Component)this.startAngleField, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.panel.add((Component)new JLabel("end angle:"), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.panel.add((Component)this.endAngleField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.panel.add(this.axisSelection);
    }

    public boolean getInput() {
        boolean success = DialogTool.showInputDialog("inputTitle", this.panel);
        if (!success) {
            return success;
        }
        try {
            this.startAngle = Double.parseDouble(this.startAngleField.getText());
            this.endAngle = Double.parseDouble(this.endAngleField.getText());
            if (this.startAngle < 0.0 || this.endAngle < 0.0) {
                this.startAngle -= 360.0;
                this.endAngle -= 360.0;
            }
            if (this.startAngle >= this.endAngle) {
                return DialogTool.handleException("errorIntervalBoundaries", DialogTool.I18N.getString("labelErrorIntervalBoundaries"));
            }
        }
        catch (NumberFormatException nfe) {
            return DialogTool.handleException("errorNumber", DialogTool.I18N.getString("labelErrorNumber"));
        }
        if (this.axisSelection.getSelectedItem() == null) {
            return DialogTool.handleException("errorComboBoxNullItem", DialogTool.I18N.getString("labelErrorComboBoxNullItem"));
        }
        String axisString = (String)this.axisSelection.getSelectedItem();
        if (axisString.equals("X-Axis")) {
            this.axisMask = 1;
        } else if (axisString.equals("Y-Axis")) {
            this.axisMask = 2;
        } else if (axisString.equals("Z-Axis")) {
            this.axisMask = 4;
        } else {
            System.err.println(axisString);
            return DialogTool.handleException("errorAxisSelection", DialogTool.I18N.getString("labelErrorAxisSelection"));
        }
        return success;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public boolean isZeroRadiusNodeIncluded() {
        return this.zeroRadiusNodeIncluded;
    }

    public int getAxisMask() {
        return this.axisMask;
    }
}

