/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.aggregation;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.advancedselection.aggregation.AggregationNode;
import de.grogra.imp3d.advancedselection.aggregation.AggregationNodeRef;
import de.grogra.imp3d.advancedselection.aggregation.GraphAggregationTools;
import de.grogra.imp3d.advancedselection.dialogs.InputDialogDegreeSpatialPartition;
import de.grogra.imp3d.advancedselection.dialogs.InputDialogIntervalSpatialPartition;
import de.grogra.imp3d.advancedselection.dialogs.InputDialogRectangleSpatialPartition;
import de.grogra.imp3d.advancedselection.objects.Interval;
import de.grogra.imp3d.advancedselection.objects.SceneBoundaries;
import de.grogra.imp3d.advancedselection.selection.Selection;
import de.grogra.imp3d.advancedselection.selection.SelectionTools;
import de.grogra.imp3d.advancedselection.selection.impl.AxisIntervalSelection;
import de.grogra.imp3d.advancedselection.selection.impl.NTypeSelection;
import de.grogra.imp3d.advancedselection.selection.impl.RectangleIntervalSelection;
import de.grogra.imp3d.advancedselection.spatialpartition.DegreeSpatialPartition;
import de.grogra.imp3d.advancedselection.spatialpartition.PlaneSpatialPartition;
import de.grogra.imp3d.advancedselection.spatialpartition.RectangleSpatialPartition;
import de.grogra.imp3d.advancedselection.spatialpartition.SpatialPartition;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.ui.Context;
import java.util.List;

public class Commands {
    private static void registerAggregationNode(AggregationNode agg, Context ctx) {
        Registry r = ctx.getWorkbench().getRegistry();
        AggregationNodeRef ref = new AggregationNodeRef(agg);
        Item dir = r.getDirectory("/project/objects/aggregations", null);
        dir.addUserItemWithUniqueName((Item)ref, "AggNode: " + Long.toString(agg.getId()));
    }

    public static void aggregateSelected(Item item, Object info, Context ctx) {
        List<Node> nodes = SelectionTools.getSelectedNodes(ctx);
        if (nodes == null) {
            return;
        }
        AggregationNode agg = new AggregationNode();
        for (Node n : nodes) {
            agg.addEdgeBitsTo(n, 4096, null);
        }
        if (!nodes.isEmpty()) {
            Commands.registerAggregationNode(agg, ctx);
        }
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("aggregate_selected_done"));
    }

    public static void aggregateAggregations(Item item, Object info, Context ctx) {
        NTypeSelection sel = new NTypeSelection("de.grogra.imp3d.advancedselection.aggregation.AggregationNode");
        SelectionTools.innitializeSelection(sel, ctx);
        List<Node> nodes = sel.getSelectedNodes();
        AggregationNode agg = new AggregationNode();
        for (Node n : nodes) {
            if (n.getSource() != null) continue;
            agg.addEdgeBitsTo(n, 4096, null);
        }
        if (!sel.getSelectedNodes().isEmpty()) {
            Commands.registerAggregationNode(agg, ctx);
        }
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("aggregation_of_aggregations_done"));
    }

    public static void aggregateDegreeSpatialPartition(Item item, Object info, Context ctx) {
        InputDialogDegreeSpatialPartition inputPanel = new InputDialogDegreeSpatialPartition();
        if (!inputPanel.getInput()) {
            System.err.println("Input Panel for angular Spatial Partition has failed");
            return;
        }
        int nIntervals = inputPanel.getNSectors();
        int axisMask = inputPanel.getAxisMask();
        DegreeSpatialPartition partition = new DegreeSpatialPartition(nIntervals, axisMask);
        ((SpatialPartition)partition).createAllSpatialPartition();
        ((SpatialPartition)partition).selection();
        for (SpatialPartition sp : partition.getPartitionList()) {
            Selection sel = sp.getSelection();
            SelectionTools.select(SelectionTools.innitializeSelection(sel, ctx), ctx);
            GraphAggregationTools.removeZeroRGG(sel.getSelectedNodes());
        }
        partition.aggregate();
        Commands.register(partition, ctx);
        partition.dispose();
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("spatial_partition_degree_done"));
    }

    public static void aggregatePlaneSpatialPartition(Item i, Object info, Context ctx) {
        InputDialogIntervalSpatialPartition inputPanel = new InputDialogIntervalSpatialPartition();
        if (!inputPanel.getInput()) {
            System.err.println("Input Panel for planar Spatial Partition has failed");
            return;
        }
        SceneBoundaries boundaries = GraphAggregationTools.getSceneBoundaries(ctx);
        double translation = inputPanel.getTranslation();
        double size = inputPanel.getRange();
        int axisMask = inputPanel.getAxisMask();
        PlaneSpatialPartition partition = new PlaneSpatialPartition(boundaries, size, translation, axisMask);
        ((SpatialPartition)partition).createAllSpatialPartition();
        for (SpatialPartition sp : partition.getPartitionList()) {
            sp.setSelection(new AxisIntervalSelection(((PlaneSpatialPartition)sp).getInterval()));
            Selection sel = sp.getSelection();
            SelectionTools.select(SelectionTools.innitializeSelection(sel, ctx), ctx);
            GraphAggregationTools.removeZeroRGG(sel.getSelectedNodes());
        }
        partition.aggregate();
        Commands.register(partition, ctx);
        partition.dispose();
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("spatial_partition_plane_done"));
    }

    public static void aggregateRectangleSpatialPartition(Item i, Object info, Context ctx) {
        InputDialogRectangleSpatialPartition inputPanel = new InputDialogRectangleSpatialPartition();
        if (!inputPanel.getInput()) {
            System.err.println("Input Panel for rectengular Spatial Partition has failed");
            return;
        }
        SceneBoundaries boundaries = GraphAggregationTools.getSceneBoundaries(ctx);
        double size = inputPanel.getSize();
        RectangleSpatialPartition partition = new RectangleSpatialPartition(boundaries, size);
        ((SpatialPartition)partition).createAllSpatialPartition();
        for (SpatialPartition sp : partition.getPartitionList()) {
            Interval x = ((RectangleSpatialPartition)sp).getIntervalX();
            Interval y = ((RectangleSpatialPartition)sp).getIntervalY();
            Interval z = ((RectangleSpatialPartition)sp).getIntervalZ();
            sp.setSelection(new RectangleIntervalSelection(x, y, z));
            Selection sel = sp.getSelection();
            SelectionTools.select(SelectionTools.innitializeSelection(sel, ctx), ctx);
            GraphAggregationTools.removeZeroRGG(sel.getSelectedNodes());
        }
        partition.aggregate();
        Commands.register(partition, ctx);
        partition.dispose();
        ctx.getWorkbench().logGUIInfo(Selection.I18N.msg("spatial_partition_plane_done"));
    }

    public static void register(SpatialPartition partition, Context ctx) {
        for (SpatialPartition sp : partition.getPartitionList()) {
            if (sp.getAggregation() == null) continue;
            Commands.registerAggregationNode(sp.getAggregation(), ctx);
        }
    }
}

