/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.advancedselection.aggregation;

import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.View;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.advancedselection.aggregation.AggregationNode;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.persistence.Transaction;
import de.grogra.pf.registry.NodeReference;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Showable;
import de.grogra.pf.ui.Window;

public class AggregationNodeRef
extends NodeReference
implements Showable,
SharedObjectReference,
SharedObjectProvider,
ChangeBoundaryListener {
    public static final Node.NType $TYPE = new Node.NType((Node)new AggregationNodeRef());

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new AggregationNodeRef();
    }

    private AggregationNodeRef() {
        this(null);
    }

    public AggregationNodeRef(Node ref) {
        super(ref);
    }

    public final Object getObject() {
        return this.getSharedObject();
    }

    public final Shareable getSharedObject() {
        return (Shareable)this.getBaseObjectImpl();
    }

    protected void activateImpl() {
        super.activateImpl();
        this.getSharedObject().initProvider((SharedObjectProvider)this);
        this.getSharedObject().addReference((SharedObjectReference)this);
        GraphManager g = ((Node)this.getSharedObject()).getGraph();
        g.addChangeBoundaryListener((ChangeBoundaryListener)this);
    }

    protected void deactivateImpl() {
        Node n = (Node)this.getSharedObject();
        n.removeReference((SharedObjectReference)this);
        n.getGraph().removeChangeBoundaryListener((ChangeBoundaryListener)this);
        if ((n.getGraph().getLifeCycleState((Object)n, true) & 3) == 0) {
            n.removeAll(n.getGraph().getActiveTransaction());
        }
    }

    public void show(Context ctx) {
        View3D view = View3D.getDefaultView((Context)ctx);
        if (view == null) {
            Window w = ctx.getWindow();
            View view2 = view = w != null ? (View)w.getPanel("/ui/panels/2d/graph") : null;
            if (view == null) {
                return;
            }
        }
        ViewSelection s = ViewSelection.get((Context)view);
        s.set(4, Path.PATH_0, true);
        AggregationNode node = (AggregationNode)this.getSharedObject();
        for (Edge e = node.getFirstEdge(); e != null; e = e.getNext((Node)node)) {
            if (!e.testEdgeBits(4096) || !e.isSource((Node)node)) continue;
            Node target = e.getTarget();
            Path p = GraphUtils.getTreePath((GraphState)view.getWorkbenchGraphState(), (Object)target, (boolean)true);
            s.toggle(4, p);
        }
    }

    public void sharedObjectModified(Shareable object, Transaction t) {
        if (object == this.getSharedObject()) {
            // empty if block
        }
    }

    public void beginChange(GraphState gs) {
    }

    public void endChange(GraphState gs) {
        Node n = (Node)this.getSharedObject();
        if ((n.getGraph().getLifeCycleState((Object)n, true) & 3) != 0) {
            this.deactivate();
            this.remove();
        }
    }

    public int getPriority() {
        return 10;
    }

    static {
        $TYPE.validate();
    }
}

